/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.modules.BedHandlingModule;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.SleepingParticleMessage;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class EntityAISleep
implements IStateAI {
    private static final int TICK_INTERVAL = 30;
    private static final int CHANCE = 33;
    private static final int MAX_BED_TICKS = 10;
    private final EntityCitizen citizen;
    private BlockPos usedBed = null;
    private int bedTicks = 0;

    public EntityAISleep(EntityCitizen citizen) {
        this.citizen = citizen;
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(CitizenAIState.SLEEP, () -> true, this::checkSleep, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(SleepState.WALKING_HOME, () -> true, this::walkHome, 30));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(SleepState.FIND_BED, this::findBed, () -> SleepState.SLEEPING, 30));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(SleepState.SLEEPING, () -> true, this::sleep, 30));
    }

    private IState checkSleep() {
        this.initAI();
        return SleepState.WALKING_HOME;
    }

    private IState walkHome() {
        BlockPos homePosition;
        IBuilding homeBuilding = this.citizen.getCitizenData().getHomeBuilding();
        if (homeBuilding == null ? (homePosition = this.citizen.m_21534_()).m_123331_((Vec3i)BlockPos.m_274561_((double)Math.floor(this.citizen.m_20185_()), (double)this.citizen.m_20186_(), (double)Math.floor(this.citizen.m_20189_()))) <= 16.0 : homeBuilding.isInBuilding(this.citizen.m_20183_())) {
            return SleepState.FIND_BED;
        }
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SLEEP);
        this.goHome();
        return SleepState.WALKING_HOME;
    }

    private boolean findBed() {
        if (!this.citizen.getCitizenSleepHandler().isAsleep() || this.bedTicks < 10) {
            this.findBedAndTryToSleep();
            return false;
        }
        return true;
    }

    public void initAI() {
        this.usedBed = null;
    }

    private void findBedAndTryToSleep() {
        IColony colony;
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.f_121853_)) {
                this.usedBed = null;
            }
        }
        if ((colony = this.citizen.getCitizenColonyHandler().getColony()) != null && colony.getBuildingManager().getBuilding(this.citizen.m_21534_()) != null) {
            if (this.usedBed == null) {
                IBuilding hut = colony.getBuildingManager().getBuilding(this.citizen.m_21534_());
                ArrayList bedList = new ArrayList();
                hut.getFirstOptionalModuleOccurance(BedHandlingModule.class).ifPresent(module -> bedList.addAll(module.getRegisteredBlocks()));
                for (BlockPos pos : bedList) {
                    if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)this.citizen.f_19853_, pos)) continue;
                    Level world = this.citizen.f_19853_;
                    BlockState state = world.m_8055_(pos);
                    BlockState above = world.m_8055_(pos.m_7494_());
                    if (!state.m_204336_(BlockTags.f_13038_) || ((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue() || !((BedPart)state.m_61143_((Property)BedBlock.f_49440_)).equals((Object)BedPart.HEAD) || this.isBedOccupied(hut, pos) || !above.m_204336_(BlockTags.f_13038_) && !(above.m_60734_() instanceof PanelBlock) && !(above.m_60734_() instanceof TrapDoorBlock) && above.m_280296_()) continue;
                    this.usedBed = pos;
                    this.setBedOccupied(true);
                    return;
                }
                this.usedBed = this.citizen.m_21534_();
            }
            if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 3)) {
                ++this.bedTicks;
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    this.citizen.getCitizenData().setBedPos(BlockPos.f_121853_);
                    this.usedBed = null;
                }
                this.citizen.getCitizenData().getCitizenHappinessHandler().resetModifier("slepttonight");
            }
        }
    }

    private IState sleep() {
        if (this.usedBed != null && this.usedBed.m_123331_((Vec3i)this.citizen.m_20183_()) > 9.0) {
            return SleepState.WALKING_HOME;
        }
        Network.getNetwork().sendToTrackingEntity(new SleepingParticleMessage(this.citizen.m_20185_(), this.citizen.m_20186_() + 1.0, this.citizen.m_20189_()), (Entity)this.citizen);
        return null;
    }

    private void goHome() {
        int chance;
        BlockPos pos = this.citizen.getCitizenSleepHandler().findHomePos();
        if (!this.citizen.isWorkerAtSiteWithMove(pos, 2) && this.citizen.m_20089_() == Pose.SLEEPING) {
            this.citizen.m_20124_(Pose.STANDING);
        }
        if ((chance = this.citizen.m_217043_().m_188503_(33)) <= 1 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null && this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.m_20183_(), EventType.OFF_TO_BED, this.citizen.getCitizenData());
        }
    }

    private void setBedOccupied(boolean occupied) {
        BlockState headState = this.citizen.f_19853_.m_8055_(this.usedBed);
        this.citizen.f_19853_.m_7731_(this.usedBed, (BlockState)headState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(occupied)), 3);
        BlockPos feetPos = this.usedBed.m_121945_(((Direction)headState.m_61143_((Property)BedBlock.f_54117_)).m_122424_());
        BlockState feetState = this.citizen.f_19853_.m_8055_(feetPos);
        if (feetState.m_204336_(BlockTags.f_13038_)) {
            this.citizen.f_19853_.m_7731_(feetPos, (BlockState)feetState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(occupied)), 3);
        }
    }

    private boolean isBedOccupied(IBuilding hut, BlockPos bed) {
        for (ICitizenData citizen : hut.getAllAssignedCitizen()) {
            if (this.citizen.getCivilianID() == citizen.getId() || !citizen.getBedPos().equals((Object)bed)) continue;
            return true;
        }
        return false;
    }

    public static enum SleepState implements IState
    {
        WALKING_HOME,
        FIND_BED,
        SLEEPING;

    }
}

