/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.util.WorldUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class LookAtEntityGoal
extends Goal {
    public static final float DEFAULT_PROBABILITY = 0.02f;
    protected final Mob mob;
    @Nullable
    protected Entity lookAt;
    protected final float lookDistance;
    private int lookTime;
    protected final float probability;
    private final boolean onlyHorizontal;
    protected final Class<? extends LivingEntity> lookAtType;

    public LookAtEntityGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance) {
        this(mob, lookAtType, lookDistance, 0.02f);
    }

    public LookAtEntityGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability) {
        this(mob, lookAtType, lookDistance, probability, false);
    }

    public LookAtEntityGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability, boolean p_148122_) {
        this.mob = mob;
        this.lookAtType = lookAtType;
        this.lookDistance = lookDistance;
        this.probability = probability;
        this.onlyHorizontal = p_148122_;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188501_() >= this.probability) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            this.lookAt = this.mob.m_5448_();
        }
        this.lookAt = this.lookAtType == Player.class ? WorldUtil.getNearestPlayer(this.mob, this.mob.m_146903_(), this.mob.m_146904_() + 1, this.mob.m_146907_(), this.lookDistance) : WorldUtil.getNearestEntity(this.mob.f_19853_.m_6443_(this.lookAtType, this.mob.m_20191_().m_82377_((double)this.lookDistance, 3.0, (double)this.lookDistance), entity -> true), this.mob, this.mob.m_146903_(), this.mob.m_146904_() + 1, this.mob.m_146907_(), this.lookDistance);
        return this.lookAt != null;
    }

    public boolean m_8045_() {
        if (!this.lookAt.m_6084_()) {
            return false;
        }
        if (this.mob.m_20280_(this.lookAt) > (double)(this.lookDistance * this.lookDistance)) {
            return false;
        }
        return this.lookTime > 0;
    }

    public void m_8056_() {
        this.lookTime = this.m_183277_(40 + this.mob.m_217043_().m_188503_(40));
    }

    public void m_8041_() {
        this.lookAt = null;
    }

    public void m_8037_() {
        if (this.lookAt.m_6084_()) {
            double d0 = this.onlyHorizontal ? this.mob.m_20188_() : this.lookAt.m_20188_();
            this.mob.m_21563_().m_24946_(this.lookAt.m_20185_(), d0, this.lookAt.m_20189_());
            --this.lookTime;
        }
    }
}

