/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;

public class CitizenChatHandler
implements ICitizenChatHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenChatHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            MessageUtils.format("", new Object[0]).with(ChatFormatting.RED).append(this.citizen.m_21231_().m_19293_()).append((Component)Component.m_237113_((String)"! ")).append((Component)Component.m_237110_((String)"block.blockhuttownhall.messagecolonistgravelocation", (Object[])new Object[]{Math.round(this.citizen.m_20185_()), Math.round(this.citizen.m_20186_()), Math.round(this.citizen.m_20189_())})).sendTo(this.citizen.getCitizenColonyHandler().getColony()).forManagers();
        }
    }

    @Override
    public void sendLocalizedChat(String keyIn, Object ... msg) {
        this.sendLocalizedChat((Component)Component.m_237110_((String)keyIn, (Object[])msg));
    }

    @Override
    public void sendLocalizedChat(Component component) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            MessageUtils.MessageBuilder builder = job != null ? MessageUtils.format(job.getJobRegistryEntry().getTranslationKey(), new Object[0]).append((Component)Component.m_237113_((String)" ")).append(this.citizen.m_7770_()).append((Component)Component.m_237113_((String)": ")).append(component) : MessageUtils.format(this.citizen.m_7770_()).append((Component)Component.m_237113_((String)": ")).append(component);
            builder.sendTo(this.citizen.getCitizenColonyHandler().getColony()).forAllPlayers();
        }
    }
}

