/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyRelated;
import com.minecolonies.api.entity.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.sounds.MercenarySounds;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.EntityMercenaryAI;
import com.minecolonies.coremod.entity.pathfinding.GeneralEntityWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityMercenary
extends AbstractFastMinecoloniesEntity
implements Npc,
IColonyRelated {
    private static final int SLAP_INTERVAL = 100;
    private IColony colony;
    private AbstractAdvancedPathNavigate newNavigator;
    private GeneralEntityWalkToProxy proxy;
    private int slapTimer = 0;
    private final Random rand = new Random();
    private long worldTimeAtSpawn = 0L;
    private boolean isLeader = false;
    private List<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
    private int spawnEventTime = 0;
    private boolean doSpawnEvent = false;
    private ITickRateStateMachine<IState> stateMachine;
    private static final String ENTITY_NAME = "Mercenary";

    public EntityMercenary(EntityType<EntityMercenary> type, Level world) {
        super(type, world);
        this.f_21345_ = new CustomGoalSelector(this.f_21345_);
        this.f_21346_ = new CustomGoalSelector(this.f_21346_);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EntityMercenaryAI(this));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIInteractToggleAble((Mob)this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 10, true, false, e -> e instanceof Enemy && !(e instanceof Llama)));
        this.m_20340_(true);
        this.m_21530_();
        ItemStack mainhand = new ItemStack((ItemLike)Items.f_42430_, 1);
        mainhand.m_41663_(Enchantments.f_44981_, 1);
        this.m_8061_(EquipmentSlot.MAINHAND, mainhand);
        ItemStack helmet = new ItemStack((ItemLike)Items.f_42472_, 1);
        helmet.m_41663_(Enchantments.f_44965_, 4);
        this.m_8061_(EquipmentSlot.HEAD, helmet);
        ItemStack chest = new ItemStack((ItemLike)Items.f_42477_, 1);
        chest.m_41663_(Enchantments.f_44965_, 4);
        this.m_8061_(EquipmentSlot.CHEST, chest);
        ItemStack legs = new ItemStack((ItemLike)Items.f_42466_, 1);
        this.m_8061_(EquipmentSlot.LEGS, legs);
        ItemStack boots = new ItemStack((ItemLike)Items.f_42467_, 1);
        this.m_8061_(EquipmentSlot.FEET, boots);
        this.m_21051_(Attributes.f_22277_).m_22100_(35.0);
        this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
        this.m_21051_(Attributes.f_22276_).m_22100_(60.0);
        this.m_21153_(this.m_21233_());
        this.stateMachine = new TickRateStateMachine<EntityMercenaryAI.State>(EntityMercenaryAI.State.INIT, this::handleStateException);
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.INIT, this::isInitialized, () -> EntityMercenaryAI.State.SPAWN_EVENT, 20));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.SPAWN_EVENT, this::spawnEvent, () -> EntityMercenaryAI.State.ALIVE, 30));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.ALIVE, this::shouldDespawn, () -> EntityMercenaryAI.State.DEAD, 100));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.DEAD, () -> true, this::getState, 500));
    }

    private void handleStateException(RuntimeException e) {
        Log.getLogger().warn("Mercenary entity threw an exception:", (Throwable)e);
    }

    private boolean shouldDespawn() {
        if (this.f_19853_ == null || this.f_19853_.m_46467_() - this.worldTimeAtSpawn > 48000L || this.colony == null || this.m_20145_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    private boolean isInitialized() {
        if (this.worldTimeAtSpawn == 0L) {
            this.worldTimeAtSpawn = this.f_19853_.m_46467_();
        }
        return this.f_19853_ != null && this.colony != null && this.m_6084_() && !this.m_20145_();
    }

    private boolean spawnEvent() {
        if (this.spawnEventTime > 0) {
            --this.spawnEventTime;
        }
        if (!this.doSpawnEvent || this.spawnEventTime == 0) {
            return true;
        }
        if (!this.isLeader) {
            return false;
        }
        if (!this.getNavigation().m_26571_()) {
            return false;
        }
        BlockPos first = this.soldiers.get(0).m_20183_().m_7918_(0, 0, 1);
        BlockPos last = this.soldiers.get(this.soldiers.size() - 1).m_20183_().m_7918_(0, 0, 1);
        this.m_5496_(MercenarySounds.mercenaryCelebrate, 2.0f, 1.0f);
        if (this.m_20183_().equals((Object)first)) {
            this.getNavigation().tryMoveToBlockPos(last, 0.5);
        } else {
            this.getNavigation().tryMoveToBlockPos(first, 0.5);
        }
        return false;
    }

    public void setDoSpawnEvent() {
        this.doSpawnEvent = true;
        this.spawnEventTime = 15;
    }

    public void setLeader(List<EntityMercenary> soldiers) {
        this.soldiers = soldiers;
        this.isLeader = true;
        this.doSpawnEvent = true;
        this.spawnEventTime = 17;
    }

    public IState getState() {
        return this.stateMachine.getState();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(MercenarySounds.mercenaryStep, 0.45f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return MercenarySounds.mercenaryHurt;
    }

    protected SoundEvent m_5592_() {
        return MercenarySounds.mercenaryDie;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return MercenarySounds.mercenarySay;
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128356_("time", this.worldTimeAtSpawn);
        compound.m_128405_("colony", this.colony == null ? 0 : this.colony.getID());
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.m_128454_("time");
        if (compound.m_128441_("colony") && (colonyId = compound.m_128451_("colony")) != 0) {
            this.setColony(IColonyManager.getInstance().getColonyByWorld(colonyId, this.f_19853_));
        }
        super.m_7378_(compound);
    }

    public Component m_7755_() {
        return Component.m_237113_((String)ENTITY_NAME);
    }

    @Override
    public void registerWithColony() {
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, Attributes.f_22281_.m_22082_()).m_22268_(Attributes.f_22277_, 100.0);
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
            this.registerWithColony();
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_7639_() instanceof LivingEntity) {
            this.m_6710_((LivingEntity)source.m_7639_());
        }
        return super.m_6469_(source, damage);
    }

    protected void m_7324_(Entity entityIn) {
        if (this.slapTimer == 0 && entityIn instanceof Player) {
            this.slapTimer = 100;
            entityIn.m_6469_(entityIn.f_19853_.m_269111_().m_269298_(DamageSourceKeys.SLAP, (Entity)this), 1.0f);
            this.m_6674_(InteractionHand.OFF_HAND);
        }
        if (this.slapTimer == 0 && entityIn instanceof EntityCitizen && this.colony != null && ((EntityCitizen)entityIn).isActive()) {
            this.slapTimer = 100;
            IItemHandler handler = ((EntityCitizen)entityIn).getItemHandlerCitizen();
            ItemStack stack = handler.extractItem(this.rand.nextInt(handler.getSlots()), 5, false);
            if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                this.m_6674_(InteractionHand.OFF_HAND);
                MessageUtils.format("com.minecolonies.coremod.mercenary.mercenarystealcitizen", entityIn.m_7755_().getString(), stack.m_41786_().getString()).sendTo(this.colony).forAllPlayers();
            }
        }
    }

    public GeneralEntityWalkToProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new GeneralEntityWalkToProxy((Mob)this);
        }
        return this.proxy;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = new MinecoloniesAdvancedPathNavigate((Mob)this, this.f_19853_);
            this.f_21344_ = this.newNavigator;
            this.newNavigator.m_7008_(true);
            this.newNavigator.m_26575_().m_77355_(true);
        }
        return this.newNavigator;
    }

    public void m_8107_() {
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            this.stateMachine.tick();
        }
        if (this.slapTimer > 0) {
            --this.slapTimer;
        }
        this.m_21203_();
        super.m_8107_();
    }

    public boolean m_8023_() {
        return true;
    }

    public static void spawnMercenariesInColony(@NotNull IColony colony) {
        Level world = colony.getWorld();
        if (colony.getMercenaryUseTime() != 0L && world.m_46467_() - colony.getMercenaryUseTime() < 48000L) {
            return;
        }
        colony.usedMercenaries();
        int amountOfMercenaries = colony.getCitizenManager().getCurrentCitizenCount();
        amountOfMercenaries /= 10;
        BlockPos spawn = EntityMercenary.findMercenarySpawnPos(colony, amountOfMercenaries += 3);
        ArrayList<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
        for (int i = 0; i < amountOfMercenaries; ++i) {
            EntityMercenary merc = (EntityMercenary)ModEntities.MERCENARY.m_20615_(world);
            merc.setColony(colony);
            merc.m_6034_(spawn.m_123341_() + i, spawn.m_123342_(), spawn.m_123343_());
            merc.setDoSpawnEvent();
            soldiers.add(merc);
            world.m_7967_((Entity)merc);
        }
        EntityMercenary merc = (EntityMercenary)ModEntities.MERCENARY.m_20615_(world);
        merc.setColony(colony);
        merc.m_6034_(spawn.m_123341_(), spawn.m_123342_(), spawn.m_123343_() + 1);
        merc.setLeader(soldiers);
        world.m_7967_((Entity)merc);
    }

    private static BlockPos findMercenarySpawnPos(IColony colony, int amountOfMercenaries) {
        Tuple<BlockPos, BlockPos> buildingArea = colony.getBuildingManager().getTownHall().getCorners();
        BlockPos spawn = new BlockPos((((BlockPos)buildingArea.m_14419_()).m_123341_() + ((BlockPos)buildingArea.m_14418_()).m_123341_()) / 2, 0, ((BlockPos)buildingArea.m_14418_()).m_123343_());
        int height = colony.getWorld().m_6924_(Heightmap.Types.WORLD_SURFACE, spawn.m_123341_(), spawn.m_123343_());
        if (height > ((BlockPos)buildingArea.m_14419_()).m_123342_()) {
            height = ((BlockPos)buildingArea.m_14418_()).m_123342_() + 1;
        }
        spawn = spawn.m_7918_(0, height, 0);
        for (int i = -3; i < 4; ++i) {
            if (!EntityMercenary.isValidSpawnForMercenaries((LevelAccessor)colony.getWorld(), spawn.m_7918_(0, 0, i), amountOfMercenaries)) continue;
            spawn = spawn.m_7918_(0, 0, i);
            break;
        }
        return spawn;
    }

    private static boolean isValidSpawnForMercenaries(LevelAccessor world, BlockPos spawn, int amountOfMercenaries) {
        for (int i = 0; i < amountOfMercenaries; ++i) {
            if (world.m_46859_(spawn.m_7494_().m_7918_(i, 0, 0)) && world.m_46859_(spawn.m_7494_().m_7918_(i, 0, 1))) continue;
            return false;
        }
        return true;
    }
}

