/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.pathfinding.AbstractWalkToProxy;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.MinerLevel;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class EntityCitizenWalkToProxy
extends AbstractWalkToProxy {
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private final AbstractEntityCitizen citizen;

    public EntityCitizenWalkToProxy(AbstractEntityCitizen entity) {
        super((Mob)entity);
        this.citizen = entity;
    }

    @Override
    public Set<BlockPos> getWayPoints() {
        if (this.citizen.getCitizenColonyHandler().getColony() == null) {
            return Collections.emptySet();
        }
        return this.citizen.getCitizenColonyHandler().getColony().getWayPoints().keySet();
    }

    @Override
    public boolean careAboutY() {
        return true;
    }

    @Override
    public BlockPos getSpecializedProxy(BlockPos target, double distanceToPath) {
        IBuilding miner;
        AbstractBuildingGuards guardbuilding;
        IBuilding building = this.citizen.getCitizenColonyHandler().getWorkBuilding();
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobMiner && building instanceof BuildingMiner) {
            return this.getMinerProxy(target, distanceToPath, (BuildingMiner)building);
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && this.citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && building instanceof AbstractBuildingGuards && (guardbuilding = (AbstractBuildingGuards)building).getTask().equals("com.minecolonies.core.guard.setting.patrol_mine") && guardbuilding.getMinePos() != null && (miner = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(guardbuilding.getMinePos())) instanceof BuildingMiner) {
            return this.getMinerProxy(target, distanceToPath, (BuildingMiner)miner);
        }
        return null;
    }

    @NotNull
    private BlockPos getMinerProxy(BlockPos target, double distanceToPath, @NotNull BuildingMiner building) {
        MinerLevelManagementModule module = (MinerLevelManagementModule)building.getFirstModuleOccurance(MinerLevelManagementModule.class);
        MinerLevel level = module.getCurrentLevel();
        BlockPos ladderPos = building.getLadderLocation();
        if (level != null) {
            BlockPos vector = building.getLadderLocation().m_121996_((Vec3i)building.getCobbleLocation());
            int levelDepth = level.getDepth() + 2;
            int targetY = target.m_123342_();
            int workerY = this.citizen.m_20183_().m_123342_();
            if (workerY <= levelDepth && targetY > levelDepth) {
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    Node currentNode = level.getNode(module.getActiveNode().getParent());
                    if (currentNode == null) {
                        module.setActiveNode(null);
                        module.setOldNode(null);
                        return this.getProxy(target, this.citizen.m_20183_(), distanceToPath);
                    }
                    while (currentNode.getParent() != null) {
                        if (currentNode.getStyle() == Node.NodeType.SHAFT) {
                            Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(currentNode.getX(), 0, currentNode.getZ()));
                            BlockPos ladderHeight = new BlockPos(ladderPos.m_123341_(), targetY + 1, ladderPos.m_123343_());
                            return new BlockPos((Vec3i)ladderHeight.m_5484_(facing, 7));
                        }
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                this.addToProxyList(new BlockPos(ladderPos.m_123341_() + vector.m_123341_() * 6, level.getDepth(), ladderPos.m_123343_() + vector.m_123343_() * 6));
                return this.getProxy(target, this.citizen.m_20183_(), distanceToPath);
            }
            if (targetY <= levelDepth && workerY > levelDepth) {
                BlockPos buildingPos = building.getPosition();
                BlockPos newProxy = this.getProxy(buildingPos, this.citizen.m_20183_(), BlockPosUtil.getDistanceSquared(this.citizen.m_20183_(), buildingPos));
                if (buildingPos.m_123342_() - level.getDepth() > 25) {
                    this.addToProxyList(new BlockPos(ladderPos.m_123341_() + vector.m_123341_(), level.getDepth() + (buildingPos.m_123342_() - level.getDepth()) / 2, ladderPos.m_123343_() + vector.m_123343_()));
                }
                this.addToProxyList(new BlockPos(ladderPos.m_123341_() + vector.m_123341_() * 6, level.getDepth(), ladderPos.m_123343_() + vector.m_123343_() * 6));
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                return newProxy;
            }
            if (targetY <= levelDepth) {
                double closestNode = Double.MAX_VALUE;
                Node lastNode = null;
                for (Map.Entry<Vec2i, Node> node : level.getNodes().entrySet()) {
                    double distanceToNode = node.getKey().distanceSq(this.citizen.m_20183_().m_123341_(), this.citizen.m_20183_().m_123343_());
                    if (!(distanceToNode < closestNode)) continue;
                    lastNode = node.getValue();
                    closestNode = distanceToNode;
                }
                if (lastNode != null && lastNode.getStyle() == Node.NodeType.SHAFT) {
                    Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(lastNode.getX(), 0, lastNode.getZ()));
                    BlockPos ladderHeight = new BlockPos(ladderPos.m_123341_(), targetY + 1, ladderPos.m_123343_());
                    return new BlockPos((Vec3i)ladderHeight.m_5484_(facing, 7));
                }
                if (lastNode != null && lastNode.getParent() != null) {
                    Node currentNode = level.getNode(lastNode.getParent());
                    while (new Vec2i(currentNode.getX(), currentNode.getZ()).equals(currentNode.getParent()) && currentNode.getParent() != null) {
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                if (!this.getProxyList().isEmpty()) {
                    return this.getProxyList().get(0);
                }
                return target;
            }
        }
        return this.getProxy(target, this.citizen.m_20183_(), distanceToPath);
    }

    private void calculateNodes(MinerLevel level, int levelDepth, BuildingMiner buildingMiner) {
        ArrayList<BlockPos> nodesToTarget = new ArrayList<BlockPos>();
        Node currentNode = level.getNode(((MinerLevelManagementModule)buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class)).getActiveNode().getParent());
        while (currentNode != null && currentNode.getParent() != null) {
            if (currentNode.getStyle() == Node.NodeType.SHAFT) {
                BlockPos ladderPos = buildingMiner.getLadderLocation();
                Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(currentNode.getX(), 0, currentNode.getZ()));
                BlockPos ladderHeight = new BlockPos(ladderPos.m_123341_(), levelDepth + 1, ladderPos.m_123343_());
                nodesToTarget.add(new BlockPos((Vec3i)ladderHeight.m_5484_(facing, 7)));
            } else {
                nodesToTarget.add(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
            }
            currentNode = level.getNode(currentNode.getParent());
        }
        for (int i = nodesToTarget.size() - 1; i >= 0; --i) {
            this.addToProxyList((BlockPos)nodesToTarget.get(i));
        }
    }

    @Override
    public boolean isLivingAtSiteWithMove(Mob entity, int x, int y, int z, int range) {
        if (!WorkerUtil.isWorkerAtSiteWithMove((AbstractEntityCitizen)entity, x, y, z, range)) {
            EntityUtils.tryMoveLivingToXYZ(entity, x, y, z);
            return false;
        }
        return true;
    }
}

