/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.interfaces.IRSComponentBlock;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockScarecrow;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.VisitorSpawnedEvent;
import com.minecolonies.coremod.colony.interactionhandling.RecruitmentInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.coremod.commands.EntryPoint;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.EntityMercenary;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesChunkCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldColonyManagerCapabilityProvider;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.network.messages.client.OpenSuggestionWindowMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkRangeCapabilityMessage;
import com.minecolonies.coremod.util.ChunkClientDataHelper;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    private static Map<UUID, ChunkPos> playerPositions = new HashMap<UUID, ChunkPos>();

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onEntityAdded(@NotNull EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_() && ((Boolean)MineColonies.getConfig().getServer().mobAttackCitizens.get()).booleanValue() && event.getEntity() instanceof Mob && event.getEntity() instanceof Enemy && !event.getEntity().m_6095_().m_204039_(ModTags.mobAttackBlacklist)) {
            ((Mob)event.getEntity()).f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)event.getEntity(), EntityCitizen.class, true, citizen -> !citizen.m_20145_()));
            ((Mob)event.getEntity()).f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)event.getEntity(), EntityMercenary.class, true));
        }
    }

    @SubscribeEvent
    public static void onAttachingCapabilitiesChunk(@NotNull AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(new ResourceLocation("minecolonies", "closecolony"), (ICapabilityProvider)new MinecoloniesChunkCapabilityProvider());
    }

    @SubscribeEvent
    public static void onAttachingCapabilitiesWorld(@NotNull AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("minecolonies", "chunkupdate"), (ICapabilityProvider)new MinecoloniesWorldCapabilityProvider());
        event.addCapability(new ResourceLocation("minecolonies", "colonymanager"), (ICapabilityProvider)new MinecoloniesWorldColonyManagerCapabilityProvider());
    }

    @SubscribeEvent
    public static void onChunkLoad(@NotNull ChunkEvent.Load event) {
        if (event.getLevel() instanceof ServerLevel) {
            ChunkDataHelper.loadChunk((LevelChunk)event.getChunk(), (Level)((ServerLevel)event.getLevel()));
        } else if (event.getLevel() instanceof ClientLevel && event.getChunk() instanceof LevelChunk) {
            ChunkClientDataHelper.applyLate((LevelChunk)event.getChunk());
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            ChunkDataHelper.unloadChunk((LevelChunk)event.getChunk(), (Level)((ServerLevel)event.getLevel()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer && !event.isCanceled()) {
            IColony oldColony;
            ServerPlayer player = (ServerPlayer)event.getEntity();
            LevelChunk oldChunk = player.f_19853_.m_6325_(player.m_146902_().f_45578_, player.m_146902_().f_45579_);
            IColonyTagCapability oldCloseColonies = oldChunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (oldCloseColonies != null && oldCloseColonies.getOwningColony() != 0 && (oldColony = IColonyManager.getInstance().getColonyByWorld(oldCloseColonies.getOwningColony(), player.f_19853_)) != null) {
                oldColony.removeVisitingPlayer((Player)player);
                oldColony.getPackageManager().removeCloseSubscriber(player);
            }
        }
    }

    @SubscribeEvent
    public static void playerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            IColony newColony;
            ServerPlayer player = (ServerPlayer)event.getEntity();
            LevelChunk newChunk = player.f_19853_.m_6325_(player.m_146902_().f_45578_, player.m_146902_().f_45579_);
            IColonyTagCapability closeColonyCap = newChunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (closeColonyCap != null && (newColony = IColonyManager.getInstance().getColonyByWorld(closeColonyCap.getOwningColony(), player.f_19853_)) != null) {
                newColony.addVisitingPlayer((Player)player);
                newColony.getPackageManager().addCloseSubscriber(player);
            }
        }
    }

    @SubscribeEvent
    public static void onEnteringChunk(TickEvent.PlayerTickEvent event) {
        IColony colony;
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.m_5776_() || event.player.f_19853_.m_46467_() % 100L != 0L) {
            return;
        }
        Level world = event.player.f_19853_;
        ChunkPos chunkPos = event.player.m_146902_();
        ChunkPos oldPos = playerPositions.get(event.player.m_20148_());
        if (oldPos != null && oldPos.equals((Object)chunkPos)) {
            return;
        }
        playerPositions.put(event.player.m_20148_(), chunkPos);
        LevelChunk chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        if (chunk.m_6430_()) {
            return;
        }
        ChunkDataHelper.loadChunk(chunk, world);
        Network.getNetwork().sendToPlayer(new UpdateChunkRangeCapabilityMessage(world, chunkPos.f_45578_, chunkPos.f_45579_, 8, true), (ServerPlayer)event.player);
        IColonyTagCapability newCloseColonies = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (newCloseColonies == null) {
            return;
        }
        Network.getNetwork().sendToPlayer(new UpdateChunkCapabilityMessage(newCloseColonies, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_), (ServerPlayer)event.player);
        if (newCloseColonies.getOwningColony() != -1 && (colony = IColonyManager.getInstance().getColonyByWorld(newCloseColonies.getOwningColony(), world)) != null) {
            colony.addVisitingPlayer(event.player);
            colony.getPackageManager().addCloseSubscriber((ServerPlayer)event.player);
        }
        if (newCloseColonies.getOwningColony() != 0) {
            for (Map.Entry<Integer, Set<BlockPos>> entry : newCloseColonies.getAllClaimingBuildings().entrySet()) {
                IColony newColony = IColonyManager.getInstance().getColonyByWorld(entry.getKey(), world);
                if (newColony == null) continue;
                for (BlockPos buildingPos : entry.getValue()) {
                    IBuilding building = newColony.getBuildingManager().getBuilding(buildingPos);
                    if (building == null) continue;
                    building.onPlayerEnterNearby(event.player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(MobSpawnEvent.FinalizeSpawn event) {
        if (!(event.getEntity() instanceof Enemy) || !(event.getLevel() instanceof Level)) {
            return;
        }
        BlockPos pos = BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ());
        if (event.getSpawnType() == MobSpawnType.SPAWNER || event.getLevel().m_5776_() || !WorldUtil.isEntityBlockLoaded((LevelAccessor)event.getLevel(), pos)) {
            return;
        }
        IColonyTagCapability closeColonyCap = ((Level)event.getLevel()).m_46745_(pos).getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (closeColonyCap == null || closeColonyCap.getOwningColony() == 0) {
            return;
        }
        IColony newColony = IColonyManager.getInstance().getColonyByWorld(closeColonyCap.getOwningColony(), (Level)event.getLevel());
        if (newColony == null) {
            return;
        }
        for (BlockPos buildingPos : closeColonyCap.getAllClaimingBuildings().getOrDefault(closeColonyCap.getOwningColony(), Collections.emptySet())) {
            IBuilding building = newColony.getBuildingManager().getBuilding(buildingPos);
            if (building == null || building.getBuildingLevel() < 1 || !building.isInBuilding(pos)) continue;
            event.setSpawnCancelled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                if (!colony.getPermissions().hasPermission((Player)player, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY) && !colony.getPermissions().hasPermission((Player)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
                colony.getPackageManager().addImportantColonyPlayer(player);
                colony.getPackageManager().sendColonyViewPackets();
                colony.getPackageManager().sendPermissionsPackets();
            }
            int size = player.m_150109_().m_6643_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!(stack.m_41720_() instanceof ItemBannerRallyGuards)) continue;
                ItemBannerRallyGuards.broadcastPlayerToRally(stack, player.f_19853_, new EntityLocation(player.m_20148_()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getPackageManager().removeCloseSubscriber(player);
                colony.getPackageManager().removeImportantColonyPlayer(player);
                playerPositions.remove(player.m_20148_());
            }
        }
    }

    public static void onEnteringChunkEntity(@NotNull EntityCitizen entityCitizen, ChunkPos newChunkPos) {
        if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && newChunkPos != null) {
            IColony colony;
            Level world;
            LevelChunk chunk;
            IColonyTagCapability chunkCapability;
            if (entityCitizen.f_19853_ == null || !WorldUtil.isEntityChunkLoaded((LevelAccessor)entityCitizen.f_19853_, new ChunkPos(newChunkPos.f_45578_, newChunkPos.f_45579_))) {
                return;
            }
            if (entityCitizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && (chunkCapability = (IColonyTagCapability)(chunk = (world = entityCitizen.m_20193_()).m_6325_(newChunkPos.f_45578_, newChunkPos.f_45579_)).getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null)) != null && chunkCapability.getOwningColony() != 0 && entityCitizen.getCitizenColonyHandler().getColonyId() != chunkCapability.getOwningColony() && (colony = IColonyManager.getInstance().getColonyByWorld(chunkCapability.getOwningColony(), entityCitizen.f_19853_)) != null) {
                colony.addGuardToAttackers(entityCitizen, ((IGuardBuilding)entityCitizen.getCitizenColonyHandler().getWorkBuilding()).getPlayerToFollowOrRally());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        IColony colony;
        BlockEntity spawner;
        if (event.getLevel().m_5776_() || !(event.getLevel() instanceof Level)) {
            return;
        }
        Level world = (Level)event.getLevel();
        if (event.getState().m_60734_() instanceof SpawnerBlock && (spawner = event.getLevel().m_7702_(event.getPos())) instanceof SpawnerBlockEntity && (colony = IColonyManager.getInstance().getColonyByDimension(((SpawnerBlockEntity)spawner).m_59801_().f_45444_.m_186567_().m_128451_("colony"), (ResourceKey<Level>)world.m_46472_())) != null) {
            colony.getEventManager().onTileEntityBreak(((SpawnerBlockEntity)spawner).m_59801_().f_45444_.m_186567_().m_128451_("mc_event_id"), spawner);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Block block;
        IColony colony;
        Player player = event.getEntity();
        Level world = event.getLevel();
        BlockPos bedBlockPos = event.getPos();
        if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.m_8055_(event.getPos()).m_60734_() instanceof AbstractBlockHut) {
            IColony colony2 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony2 != null && !colony2.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
            }
            return;
        }
        if (world.m_8055_(event.getPos()).m_60734_().isBed(world.m_8055_(event.getPos()), (BlockGetter)world, event.getPos(), (Entity)player) && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, bedBlockPos)) != null && world.m_8055_(event.getPos()).m_61138_((Property)BedBlock.f_49440_)) {
            List<ICitizenData> citizenList = colony.getCitizenManager().getCitizens();
            BlockState potentialBed = world.m_8055_(event.getPos());
            if (potentialBed.m_60734_() instanceof BedBlock && potentialBed.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                bedBlockPos = bedBlockPos.m_121945_((Direction)world.m_8055_(event.getPos()).m_61143_((Property)BedBlock.f_54117_));
            }
            for (ICitizenData citizen : citizenList) {
                if (!citizen.getBedPos().equals((Object)bedBlockPos) || !citizen.isAsleep()) continue;
                event.setCanceled(true);
                MessageUtils.format("block.minecraft.bed.occupied", new Object[0]).sendTo(player);
            }
        }
        EventHandler.handleEventCancellation((PlayerInteractEvent)event, player);
        if (!event.isCanceled() && event.getEntity() instanceof Player && event.getItemStack().m_41720_() instanceof BlockItem && (block = ((BlockItem)event.getItemStack().m_41720_()).m_40614_()) instanceof AbstractBlockHut && !(block instanceof IRSComponentBlock)) {
            IColony colony3 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony3 != null && !colony3.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
                return;
            }
            if (!(!((Boolean)MineColonies.getConfig().getServer().suggestBuildToolPlacement.get()).booleanValue() || player.m_7500_() && player.m_6144_())) {
                ItemStack stack = event.getItemStack();
                if (!stack.m_41619_() && !world.f_46443_) {
                    Network.getNetwork().sendToPlayer(new OpenSuggestionWindowMessage((BlockState)block.m_49966_().m_61124_((Property)AbstractBlockHut.FACING, (Comparable)event.getEntity().m_6350_()), event.getPos().m_121945_(event.getFace()), stack), (ServerPlayer)player);
                }
                event.setCanceled(true);
            }
            return;
        }
    }

    private static boolean playerRightClickInteract(@NotNull Player player, Level world, BlockPos pos) {
        return !player.m_6144_() || player.m_21205_() == null || player.m_21205_().m_41720_() == null || player.m_21205_().m_41720_().doesSneakBypassUse(player.m_21205_(), (LevelReader)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull Player player) {
        Block heldBlock = Block.m_49814_((Item)event.getItemStack().m_41720_());
        if (heldBlock instanceof AbstractBlockHut || heldBlock instanceof BlockScarecrow) {
            if (event.getLevel().m_5776_()) {
                event.setCanceled(((Boolean)MineColonies.getConfig().getServer().suggestBuildToolPlacement.get()).booleanValue());
            } else {
                event.setCanceled(!EventHandler.onBlockHutPlaced(event.getLevel(), player, heldBlock, event.getPos().m_121945_(event.getFace())));
            }
        }
    }

    public static boolean onBlockHutPlaced(@NotNull Level world, @NotNull Player player, Block block, BlockPos pos) {
        if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(world)) {
            MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(player);
            return false;
        }
        return EventHandler.onBlockHutPlaced(world, player, pos, block);
    }

    private static boolean onBlockHutPlaced(Level world, @NotNull Player player, BlockPos pos, Block block) {
        IColony colony = IColonyManager.getInstance().getIColony(world, pos);
        if (colony == null) {
            if (block instanceof BlockHutTownHall) {
                return true;
            }
            if (IColonyManager.getInstance().getIColonyByOwner(world, player) == null) {
                MessageUtils.format("tile.blockhut.messagenotownhall", new Object[0]).sendTo(player);
            } else {
                MessageUtils.format("tile.blockhut.messagetoofarfromtownhall", new Object[0]).sendTo(player);
            }
            return player.m_7500_();
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            MessageUtils.format("tile.blockhut.messagenopermission", colony.getName()).sendTo(player);
            return false;
        }
        return player.m_7500_() || colony.getBuildingManager().canPlaceAt(block, pos, player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldLoad(@NotNull LevelEvent.Load event) {
        if (event.getLevel() instanceof Level) {
            IColonyManager.getInstance().onWorldLoad((Level)event.getLevel());
        }
        if (event.getLevel().m_5776_() && ((Boolean)MineColonies.getConfig().getServer().holidayFeatures.get()).booleanValue() && (LocalDateTime.now().getDayOfMonth() == 31 && LocalDateTime.now().getMonth() == Month.OCTOBER || LocalDateTime.now().getDayOfMonth() == 1 && LocalDateTime.now().getMonth() == Month.NOVEMBER || LocalDateTime.now().getDayOfMonth() == 2 && LocalDateTime.now().getMonth() == Month.NOVEMBER)) {
            RenderBipedCitizen.isItGhostTime = false;
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(@NotNull LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_() && event.getLevel() instanceof Level) {
            IColonyManager.getInstance().onWorldUnload((Level)event.getLevel());
        }
        if (event.getLevel().m_5776_()) {
            IColonyManager.getInstance().resetColonyViews();
            Log.getLogger().info("Removed all colony views");
        }
    }

    @SubscribeEvent
    public static void onCropTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (!event.getLevel().m_5776_() && event.getEntity() instanceof AbstractEntityCitizen && ((AbstractEntityCitizen)event.getEntity()).getCitizenJobHandler().getColonyJob() instanceof JobFarmer && ((AbstractEntityCitizen)event.getEntity()).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SOFT_SHOES) > 0.0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityConverted(@NotNull LivingConversionEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ZombieVillager && event.getOutcome() == EntityType.f_20492_) {
            Level world = entity.m_20193_();
            IColony colony = IColonyManager.getInstance().getIColony(world, entity.m_20183_());
            if (colony != null && colony.hasBuilding("tavern", 1, false)) {
                event.setCanceled(true);
                if (ForgeEventFactory.canLivingConvert((LivingEntity)entity, ModEntities.VISITOR, null)) {
                    IVisitorData visitorData = (IVisitorData)colony.getVisitorManager().createAndRegisterCivilianData();
                    BlockPos tavernPos = colony.getBuildingManager().getRandomBuilding(b -> !b.getModules(TavernBuildingModule.class).isEmpty());
                    IBuilding tavern = colony.getBuildingManager().getBuilding(tavernPos);
                    visitorData.setHomeBuilding(tavern);
                    visitorData.setBedPos(tavernPos);
                    tavern.getModules(TavernBuildingModule.class).forEach(mod -> mod.getExternalCitizens().add(visitorData.getId()));
                    int recruitLevel = world.f_46441_.m_188503_(10 * tavern.getBuildingLevel()) + 15;
                    List<Tuple<Item, Integer>> recruitCosts = IColonyManager.getInstance().getCompatibilityManager().getRecruitmentCostsWeights();
                    visitorData.getCitizenSkillHandler().init(recruitLevel);
                    colony.getVisitorManager().spawnOrCreateCivilian(visitorData, world, entity.m_20183_(), false);
                    colony.getEventDescriptionManager().addEventDescription(new VisitorSpawnedEvent(entity.m_20183_(), visitorData.getName()));
                    if (visitorData.getEntity().isPresent()) {
                        AbstractEntityCitizen visitorEntity = visitorData.getEntity().get();
                        for (EquipmentSlot slotType : EquipmentSlot.values()) {
                            ItemStack itemstack = entity.m_6844_(slotType);
                            if (slotType.m_20743_() != EquipmentSlot.Type.ARMOR || itemstack.m_41619_()) continue;
                            visitorEntity.m_8061_(slotType, itemstack);
                        }
                    }
                    if (!entity.m_20067_()) {
                        world.m_5898_((Player)null, 1027, entity.m_20183_(), 0);
                    }
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                    Tuple<Item, Integer> cost = recruitCosts.get(world.f_46441_.m_188503_(recruitCosts.size()));
                    visitorData.setRecruitCosts(new ItemStack((ItemLike)cost.getA(), (int)((double)recruitLevel * 3.0 / (double)cost.getB().intValue())));
                    visitorData.triggerInteraction(new RecruitmentInteraction((Component)Component.m_237110_((String)"com.minecolonies.coremod.gui.chat.recruitstorycured", (Object[])new Object[]{visitorData.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        double lastTickMs = (double)event.getServer().f_129748_[event.getServer().m_129921_() % 100] * 1.0E-6;
        TickRateStateMachine.slownessFactor = lastTickMs > 50.0 ? Mth.m_14008_((double)(lastTickMs / 50.0), (double)1.0, (double)5.0) : 1.0;
    }
}

