/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TextureReloadListener
extends SimplePreparableReloadListener<TexturePacks> {
    public static final List<String> TEXTURE_PACKS = new ArrayList<String>();

    @NotNull
    protected TexturePacks prepare(@NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        HashSet<String> set = new HashSet<String>();
        ArrayList resLocs = new ArrayList(manager.m_214159_("textures/entity/citizen", f -> true).keySet());
        for (ResourceLocation res : resLocs) {
            String folder;
            if (!res.m_135815_().contains("png") || !res.m_135815_().contains("textures/entity/citizen") || (folder = res.m_135815_().split("/")[3]).isEmpty()) continue;
            set.add(folder);
        }
        TexturePacks packs = new TexturePacks();
        packs.packs = new ArrayList<String>(set);
        return packs;
    }

    protected void apply(@NotNull TexturePacks packs, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        TEXTURE_PACKS.clear();
        TEXTURE_PACKS.addAll(packs.packs);
    }

    @SubscribeEvent
    public static void modInitClient(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new TextureReloadListener());
    }

    public static class TexturePacks {
        public List<String> packs = new ArrayList<String>();
    }
}

