/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.generation.CustomRecipeAndLootTableProvider;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import com.minecolonies.coremod.generation.DatagenLootTableManager;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DefaultSifterCraftingProvider
extends CustomRecipeAndLootTableProvider {
    public static final String SIFTER = ModJobs.SIFTER_ID.m_135815_();
    private final Map<Item, List<SifterMeshDetails>> inputs = new HashMap<Item, List<SifterMeshDetails>>();
    private final DatagenLootTableManager lootTableManager;

    public DefaultSifterCraftingProvider(@NotNull PackOutput packOutput, @NotNull DatagenLootTableManager lootTableManager) {
        super(packOutput);
        this.lootTableManager = lootTableManager;
        this.inputs.put(Items.f_42329_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(71)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(28)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42577_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42578_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42733_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41828_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41827_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42577_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42578_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42733_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41828_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41827_).m_79707_(5))))));
        this.inputs.put(Items.f_41832_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(85)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42484_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42484_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(46)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42534_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42534_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(2))))));
        this.inputs.put(Items.f_41830_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(2)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(85)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(5)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42533_).m_79707_(10)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42533_).m_79707_(15))))));
        this.inputs.put(Items.f_42049_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(90)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(70)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42593_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42542_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42593_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42542_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42680_).m_79707_(5))))));
    }

    @NotNull
    public String m_6055_() {
        return "SifterCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
        for (Map.Entry<Item, List<SifterMeshDetails>> inputEntry : this.inputs.entrySet()) {
            for (SifterMeshDetails mesh : inputEntry.getValue()) {
                String name = mesh.getName() + "/" + ForgeRegistries.ITEMS.getKey((Object)inputEntry.getKey()).m_135815_();
                List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops((LootDataManager)this.lootTableManager, mesh.getLootTable().m_79167_());
                Stream loot = drops.stream().flatMap(drop -> drop.getItemStacks().stream().sorted(Comparator.comparing(ItemStack::m_41613_).reversed().thenComparing(ItemStack::m_41778_)).map(ItemStack::m_41720_));
                CustomRecipeProvider.CustomRecipeBuilder.create(SIFTER, "custom", name).inputs(Stream.of(new ItemStorage(new ItemStack((ItemLike)inputEntry.getKey())), new ItemStorage(new ItemStack((ItemLike)mesh.getMesh()), true, false)).collect(Collectors.toList())).secondaryOutputs(Stream.concat(Stream.of(mesh.getMesh()), loot).map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + name)).minBuildingLevel(mesh.getMinBuildingLevel()).build(consumer);
            }
        }
        this.mesh(consumer, ModJobs.FLETCHER_ID, (ItemLike)Items.f_42401_, (ItemLike)ModItems.sifterMeshString, ResearchConstants.SIFTER_STRING);
        this.mesh(consumer, ModJobs.STONEMASON_ID, (ItemLike)Items.f_42484_, (ItemLike)ModItems.sifterMeshFlint, ResearchConstants.SIFTER_FLINT);
        this.mesh(consumer, ModJobs.BLACKSMITH_ID, (ItemLike)Items.f_42416_, (ItemLike)ModItems.sifterMeshIron, ResearchConstants.SIFTER_IRON);
        this.mesh(consumer, ModJobs.MECHANIC_ID, (ItemLike)Items.f_42415_, (ItemLike)ModItems.sifterMeshDiamond, ResearchConstants.SIFTER_DIAMOND);
    }

    private void mesh(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation job, @NotNull ItemLike input, @NotNull ItemLike output, @NotNull ResourceLocation research) {
        CustomRecipeProvider.CustomRecipeBuilder.create(job.m_135815_(), "crafting", ForgeRegistries.ITEMS.getKey((Object)output.m_5456_()).m_135815_()).inputs(List.of(new ItemStorage(new ItemStack(input)))).result(new ItemStack(output)).minResearchId(research).showTooltip(true).build(consumer);
    }

    @Override
    protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        for (Map.Entry<Item, List<SifterMeshDetails>> inputEntry : this.inputs.entrySet()) {
            for (SifterMeshDetails mesh : inputEntry.getValue()) {
                String name = mesh.getName() + "/" + ForgeRegistries.ITEMS.getKey((Object)inputEntry.getKey()).m_135815_();
                registrar.register(new ResourceLocation("minecolonies", "recipes/" + name), LootContextParamSets.f_81420_, mesh.getLootTable());
            }
        }
    }

    private static class SifterMeshDetails {
        private final String name;
        private final Item mesh;
        private final int minBuildingLevel;
        private final LootTable.Builder lootTable;

        public SifterMeshDetails(@NotNull Item mesh, int minBuildingLevel, @NotNull LootTable.Builder lootTable) {
            this.name = ForgeRegistries.ITEMS.getKey((Object)mesh).m_135815_().replace("sifter_mesh_", "");
            this.mesh = mesh;
            this.minBuildingLevel = minBuildingLevel;
            this.lootTable = lootTable;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Item getMesh() {
            return this.mesh;
        }

        public int getMinBuildingLevel() {
            return this.minBuildingLevel;
        }

        @NotNull
        public LootTable.Builder getLootTable() {
            return this.lootTable;
        }
    }
}

