/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.api.quests.IQuestTemplate;
import com.minecolonies.api.quests.ITriggerReturnData;
import com.minecolonies.coremod.quests.QuestInstance;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class QuestTemplate
implements IQuestTemplate {
    private final ResourceLocation questID;
    private final List<ResourceLocation> parents;
    private final Function<IColony, List<ITriggerReturnData<?>>> questTriggerList;
    private final List<IQuestObjectiveTemplate> objectives;
    private final List<IQuestRewardTemplate> questRewards;
    private final int maxOccurrence;
    private final Component name;
    private final int questTimeout;

    public QuestTemplate(ResourceLocation questID, Component name, List<ResourceLocation> parents, int maxOccurrence, Function<IColony, List<ITriggerReturnData<?>>> questTriggerList, List<IQuestObjectiveTemplate> questObjectives, int questTimeout, List<IQuestRewardTemplate> questRewards) {
        this.questID = questID;
        this.name = name;
        this.parents = parents;
        this.questTriggerList = questTriggerList;
        this.maxOccurrence = maxOccurrence;
        this.objectives = questObjectives;
        this.questTimeout = questTimeout;
        this.questRewards = questRewards;
    }

    @Override
    public IQuestInstance attemptStart(IColony colony) {
        List<ITriggerReturnData<?>> triggerReturnData = this.questTriggerList.apply(colony);
        return triggerReturnData == null || triggerReturnData.isEmpty() ? null : new QuestInstance(this.questID, colony, triggerReturnData);
    }

    @Override
    public int getQuestTimeout() {
        return this.questTimeout;
    }

    @Override
    public int getMaxOccurrence() {
        return this.maxOccurrence;
    }

    @Override
    public void unlockQuestRewards(IColony colony, Player player, IQuestInstance colonyQuest, List<Integer> unlockedRewards) {
        int index = 0;
        for (IQuestRewardTemplate questReward : this.questRewards) {
            if (unlockedRewards.contains(index)) {
                questReward.applyReward(colony, player, colonyQuest);
            }
            ++index;
        }
    }

    @Override
    public IQuestObjectiveTemplate getObjective(int index) {
        return this.objectives.get(index);
    }

    @Override
    public int getObjectiveCount() {
        return this.objectives.size();
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public List<ResourceLocation> getParents() {
        return this.parents;
    }
}

