/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.objectives;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class DialogueObjectiveTemplateTemplate
implements IDialogueObjectiveTemplate {
    private final int target;
    private final IDialogueObjectiveTemplate.DialogueElement dialogueTree;
    private final List<Integer> rewardUnlocks;

    public DialogueObjectiveTemplateTemplate(int target, IDialogueObjectiveTemplate.DialogueElement dialogueTree, List<Integer> rewards) {
        this.target = target;
        this.dialogueTree = dialogueTree;
        this.rewardUnlocks = ImmutableList.copyOf(rewards);
    }

    @Override
    public IDialogueObjectiveTemplate.DialogueElement getDialogueTree() {
        return this.dialogueTree;
    }

    @Override
    public List<Integer> getRewardUnlocks() {
        return this.rewardUnlocks;
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        return new DialogueObjectiveTemplateTemplate(jsonObject.get("target").getAsInt(), IDialogueObjectiveTemplate.DialogueElement.parse(jsonObject), DialogueObjectiveTemplateTemplate.parseRewards(jsonObject));
    }

    public static List<Integer> parseRewards(JsonObject jsonObject) {
        if (!jsonObject.has("unlocks-rewards")) {
            return Collections.emptyList();
        }
        ArrayList<Integer> rewardList = new ArrayList<Integer>();
        JsonArray jsonArray = jsonObject.get("unlocks-rewards").getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            rewardList.add(jsonArray.get(i).getAsInt());
        }
        return rewardList;
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        if (this.target == 0) {
            colonyQuest.getQuestGiver().openDialogue(colonyQuest, colonyQuest.getObjectiveIndex());
        } else {
            colonyQuest.getParticipant(this.target).openDialogue(colonyQuest, colonyQuest.getObjectiveIndex());
        }
        return null;
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        ICitizen citizen = quest.getColony().getCitizen(this.target == 0 ? quest.getQuestGiverId() : this.target - 1);
        if (citizen != null) {
            return Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.answer.progress", (Object[])new Object[]{citizen.getName()}).m_6270_(style);
        }
        return Component.m_237119_();
    }
}

