/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.rewards;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ResearchCompleteRewardTemplate
implements IQuestRewardTemplate {
    private final ResourceLocation research;

    public ResearchCompleteRewardTemplate(ResourceLocation research) {
        this.research = research;
    }

    public static IQuestRewardTemplate createReward(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        ResourceLocation research = new ResourceLocation(details.get("id").getAsString());
        return new ResearchCompleteRewardTemplate(research);
    }

    @Override
    public void applyReward(IColony colony, Player player, IQuestInstance colonyQuest) {
        colony.getResearchManager().getResearchTree().finishResearch(this.research);
        colony.getResearchManager().markDirty();
    }
}

