/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class ResearchEffectCategory {
    public static final String RESEARCH_EFFECT_PROP = "effect";
    public static final String RESEARCH_EFFECT_LEVELS_PROP = "levels";
    private final ResourceLocation effectId;
    private final TranslatableContents effectName;
    private final TranslatableContents subtitle;
    private final List<Double> levelsAbsolute = new ArrayList<Double>();
    private final List<Double> levelsRelative = new ArrayList<Double>();

    public ResearchEffectCategory(String effectId, String effectName, String subtitle) {
        this.effectId = new ResourceLocation(effectId);
        this.effectName = effectName != null ? new TranslatableContents(effectName, null, TranslatableContents.f_237494_) : new TranslatableContents("com." + this.effectId.m_135827_() + ".research." + this.effectId.m_135815_().replaceAll("[ /]", ".") + ".description", null, TranslatableContents.f_237494_);
        this.subtitle = new TranslatableContents(subtitle, null, TranslatableContents.f_237494_);
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public ResearchEffectCategory(String effectId, String effectName) {
        this.effectId = new ResourceLocation(effectId);
        this.effectName = new TranslatableContents(effectName, null, TranslatableContents.f_237494_);
        this.subtitle = new TranslatableContents("", null, TranslatableContents.f_237494_);
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public ResearchEffectCategory(String effectId) {
        this.effectId = new ResourceLocation(effectId);
        this.effectName = new TranslatableContents("com." + this.effectId.m_135827_() + ".research." + this.effectId.m_135815_().replaceAll("[ /]", ".") + ".description", null, TranslatableContents.f_237494_);
        this.subtitle = new TranslatableContents("", null, TranslatableContents.f_237494_);
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public void add(double newVal) {
        this.levelsRelative.add(newVal - this.levelsAbsolute.get(this.levelsAbsolute.size() - 1));
        this.levelsAbsolute.add(newVal);
    }

    public double getDisplay(int level) {
        return this.levelsRelative.get(level);
    }

    public double get(int level) {
        return this.levelsAbsolute.get(level);
    }

    public int getMaxLevel() {
        return this.levelsAbsolute.size() - 1;
    }

    public ResourceLocation getId() {
        return this.effectId;
    }

    public TranslatableContents getName() {
        return this.effectName;
    }

    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }
}

