/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;

public class MutableChunkPos
extends ChunkPos {
    private int mutableX;
    private int mutableZ;

    public MutableChunkPos(int x, int z) {
        super(x, z);
        this.mutableX = x;
        this.mutableZ = z;
    }

    public MutableChunkPos(BlockPos pos) {
        super(pos);
        this.mutableX = pos.m_123341_() >> 4;
        this.mutableZ = pos.m_123343_() >> 4;
    }

    public MutableChunkPos(long longIn) {
        super(longIn);
        this.mutableX = (int)longIn;
        this.mutableZ = (int)(longIn >> 32);
    }

    public long m_45588_() {
        return MutableChunkPos.m_45589_((int)this.mutableX, (int)this.mutableZ);
    }

    public int hashCode() {
        int i = 1664525 * this.mutableX + 1013904223;
        int j = 1664525 * (this.mutableZ ^ 0xDEADBEEF) + 1013904223;
        return i ^ j;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MutableChunkPos) {
            MutableChunkPos mcp = (MutableChunkPos)((Object)obj);
            return this.mutableX == mcp.mutableX && this.mutableZ == mcp.mutableZ;
        }
        if (obj instanceof ChunkPos) {
            ChunkPos cp = (ChunkPos)obj;
            return this.mutableX == cp.f_45578_ && this.mutableZ == cp.f_45579_;
        }
        return false;
    }

    public int m_45604_() {
        return SectionPos.m_123223_((int)this.mutableX);
    }

    public int m_45605_() {
        return SectionPos.m_123223_((int)this.mutableZ);
    }

    public int m_151382_(int offset) {
        return SectionPos.m_175554_((int)this.mutableX, (int)offset);
    }

    public int m_151391_(int offset) {
        return SectionPos.m_175554_((int)this.mutableZ, (int)offset);
    }

    public int m_45610_() {
        return this.mutableX >> 5;
    }

    public int m_45612_() {
        return this.mutableZ >> 5;
    }

    public int m_45613_() {
        return this.mutableX & 0x1F;
    }

    public int m_45614_() {
        return this.mutableZ & 0x1F;
    }

    public String toString() {
        return "[" + this.mutableX + ", " + this.mutableZ + "]";
    }

    public int m_45594_(ChunkPos chunkPosIn) {
        return Math.max(Math.abs(this.mutableX - chunkPosIn.f_45578_), Math.abs(this.mutableZ - chunkPosIn.f_45579_));
    }

    public int getChessboardDistance(MutableChunkPos chunkPosIn) {
        return Math.max(Math.abs(this.mutableX - chunkPosIn.mutableX), Math.abs(this.mutableZ - chunkPosIn.mutableZ));
    }

    public int getX() {
        return this.mutableX;
    }

    public void setX(int x) {
        this.mutableX = x;
    }

    public int getZ() {
        return this.mutableZ;
    }

    public void setZ(int z) {
        this.mutableZ = z;
    }

    public void from(ChunkPos chunkPos) {
        this.mutableX = chunkPos.f_45578_;
        this.mutableZ = chunkPos.f_45579_;
    }

    public ChunkPos toImmutable() {
        return new ChunkPos(this.mutableX, this.mutableZ);
    }
}

