/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.configured;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.impl.forge.ForgeConfig;
import com.mrcrayfish.configured.impl.forge.ForgeFolderEntry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.integration.configured.CustomConfigSelectScreen;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public abstract class CustomConfigScreen
extends ConfigScreen {
    @Nullable
    private static final Field BUTTON_ON_PRESS = CustomConfigScreen.findFieldOrNull(Button.class, "onPress");
    @Nullable
    private static final Field FOLDER_ENTRY = CustomConfigScreen.findFieldOrNull(ConfigScreen.class, "folderEntry");
    @Nullable
    private static final Method SAVE_CONFIG = CustomConfigScreen.findMethodOrNull(ConfigScreen.class, "saveConfig");
    @Nullable
    private static final Field CONFIG_VALUE_HOLDER = CustomConfigScreen.findFieldOrNull(ConfigScreen.ConfigItem.class, "holder");
    @Nullable
    private static final Field BOOLEAN_ITEM_BUTTON = CustomConfigScreen.findFieldOrNull(ConfigScreen.BooleanItem.class, "button");
    protected final String modId;
    protected final Map<String, ItemStack> icons = new HashMap<String, ItemStack>();
    public final ItemStack mainIcon;
    private int ticks = 0;

    @Nullable
    static Method findMethodOrNull(Class<?> c, String methodName) {
        Method field = null;
        try {
            field = ObfuscationReflectionHelper.findMethod(c, (String)methodName, (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    @Nullable
    static Field findFieldOrNull(Class<?> c, String fieldName) {
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(c, (String)fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    public CustomConfigScreen(CustomConfigSelectScreen parent, IModConfig config) {
        this(parent.getModId(), parent.getMainIcon(), parent.getBackgroundTexture(), parent.m_96636_(), (Screen)parent, config);
    }

    public CustomConfigScreen(CustomConfigSelectScreen parent, ModConfig config) {
        this(parent.getModId(), parent.getMainIcon(), parent.getBackgroundTexture(), parent.m_96636_(), (Screen)parent, config);
    }

    public CustomConfigScreen(String modId, ItemStack mainIcon, ResourceLocation background, Component title, Screen parent, ModConfig config) {
        this(modId, mainIcon, background, title, parent, (IModConfig)new ForgeConfig(config));
    }

    public CustomConfigScreen(String modId, ItemStack mainIcon, ResourceLocation background, Component title, Screen parent, IModConfig config) {
        super(parent, title, config, background);
        this.modId = modId;
        this.mainIcon = mainIcon;
    }

    private ItemStack getIcon(String name) {
        if (!this.icons.containsKey(name)) {
            String formatted = name.toLowerCase(Locale.ROOT).replace(" ", "_");
            Optional item = Registry.f_122827_.m_6612_(new ResourceLocation(this.modId, formatted));
            item.ifPresent(value -> this.addIcon(name, value.m_5456_().m_7968_()));
        }
        return this.icons.getOrDefault(name, this.mainIcon);
    }

    private void addIcon(String s, ItemStack i) {
        this.icons.put(s, i);
    }

    protected void m_7856_() {
        super.m_7856_();
        boolean reg = this.hasFancyBooleans() && !this.folderEntry.isRoot();
        this.list.m_5988_(this.replaceItems(this.list.m_6702_(), reg));
        Collection<ListMenuScreen.Item> temp = this.replaceItems(this.entries, reg);
        this.entries = new ArrayList<ListMenuScreen.Item>(temp);
        if (this.saveButton != null && SAVE_CONFIG != null && BUTTON_ON_PRESS != null) {
            try {
                Button.OnPress press = this::saveButtonAction;
                BUTTON_ON_PRESS.set(this.saveButton, press);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract boolean hasFancyBooleans();

    private Collection<ListMenuScreen.Item> replaceItems(Collection<ListMenuScreen.Item> originals, boolean fancyBooleans) {
        ArrayList<ListMenuScreen.Item> newList = new ArrayList<ListMenuScreen.Item>();
        for (ListMenuScreen.Item c : originals) {
            ConfigScreen.BooleanItem b;
            Object wrapper;
            if (c instanceof ConfigScreen.FolderItem) {
                ConfigScreen.FolderItem f = (ConfigScreen.FolderItem)c;
                wrapper = this.wrapFolderItem(f);
                if (wrapper != null) {
                    newList.add((ListMenuScreen.Item)wrapper);
                    continue;
                }
            } else if (c instanceof ConfigScreen.BooleanItem && (wrapper = this.wrapBooleanItem(b = (ConfigScreen.BooleanItem)c, fancyBooleans)) != null) {
                newList.add((ListMenuScreen.Item)wrapper);
                continue;
            }
            newList.add(c);
        }
        return newList;
    }

    private void saveButtonAction(Button button) {
        if (this.config != null) {
            try {
                SAVE_CONFIG.invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isChanged(this.folderEntry)) {
                this.onSave();
            }
        }
        this.f_96541_.m_91152_(this.parent);
    }

    public abstract void onSave();

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 35;
        this.f_96542_.m_115218_(this.mainIcon, this.f_96543_ / 2 + titleWidth / 2 - 17, 2);
        this.f_96542_.m_115218_(this.mainIcon, this.f_96543_ / 2 - titleWidth / 2, 2);
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.ticks;
    }

    @Nullable
    public FolderWrapper wrapFolderItem(ConfigScreen.FolderItem old) {
        try {
            String oldName = old.getLabel();
            ForgeFolderEntry found = null;
            for (IConfigEntry e : this.folderEntry.getChildren()) {
                ForgeFolderEntry f;
                String n;
                if (!(e instanceof ForgeFolderEntry) || !(n = Component.m_237113_((String)ConfigScreen.createLabel((String)(f = (ForgeFolderEntry)e).getEntryName())).getString()).equals(oldName)) continue;
                found = f;
                break;
            }
            if (found != null) {
                return new FolderWrapper(found, oldName);
            }
        }
        catch (Exception ignored) {
            Moonlight.LOGGER.error("error", (Throwable)ignored);
        }
        return null;
    }

    public abstract CustomConfigScreen createSubScreen(Component var1);

    @Nullable
    public BooleanWrapper wrapBooleanItem(ConfigScreen.BooleanItem old, boolean displayItem) {
        try {
            IConfigValue holder = (IConfigValue)CONFIG_VALUE_HOLDER.get(old);
            ValueEntry found = null;
            for (IConfigEntry e : this.folderEntry.getChildren()) {
                ValueEntry value;
                if (!(e instanceof ValueEntry) || holder != (value = (ValueEntry)e).getValue()) continue;
                found = value;
            }
            if (found != null) {
                return displayItem ? new BooleanWrapperItem((IConfigValue<Boolean>)holder) : new BooleanWrapper((IConfigValue<Boolean>)holder);
            }
        }
        catch (Exception ignored) {
            Moonlight.LOGGER.error("error");
        }
        return null;
    }

    private class FolderWrapper
    extends ConfigScreen.FolderItem {
        private final ItemStack icon;
        protected final Button button;
        private int ticks;
        private int lastTick;

        private FolderWrapper(ForgeFolderEntry folderEntry, String label) {
            super((ConfigScreen)CustomConfigScreen.this, (IConfigEntry)folderEntry);
            this.ticks = 0;
            this.lastTick = 1;
            this.button = new Button(10, 5, 44, 20, (Component)Component.m_237113_((String)label).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = CustomConfigScreen.this.f_96539_.m_6879_().m_130946_(" > " + label);
                CustomConfigScreen sc = CustomConfigScreen.this.createSubScreen((Component)newTitle);
                try {
                    FOLDER_ENTRY.set((Object)sc, folderEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CustomConfigScreen.this.f_96541_.m_91152_((Screen)sc);
            });
            this.icon = CustomConfigScreen.this.getIcon(label.toLowerCase(Locale.ROOT));
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public void m_6311_(PoseStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (this.lastTick < CustomConfigScreen.this.ticks) {
                this.ticks = Math.max(0, this.ticks + (selected ? 1 : -2)) % 36;
            }
            this.lastTick = CustomConfigScreen.this.ticks;
            this.button.f_93620_ = left - 1;
            this.button.f_93621_ = top;
            this.button.m_93674_(width);
            this.button.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            int center = this.button.f_93620_ + width / 2;
            ItemRenderer renderer = CustomConfigScreen.this.f_96542_;
            float p = (float)Math.PI / 180;
            RenderUtil.renderGuiItemRelative(this.icon, center + 90 - 17, top + 2, renderer, (s, r) -> {
                if (this.ticks != 0) {
                    if (r.booleanValue()) {
                        s.m_85845_(Vector3f.f_122225_.m_122270_(((float)this.ticks + partialTicks) * p * 10.0f));
                    } else {
                        float scale = 1.0f + 0.1f * Mth.m_14031_((float)(((float)this.ticks + partialTicks) * p * 20.0f));
                        s.m_85841_(scale, scale, scale);
                    }
                }
            });
            RenderUtil.renderGuiItemRelative(this.icon, center - 90, top + 2, renderer, (s, r) -> {
                if (this.ticks != 0) {
                    if (r.booleanValue()) {
                        s.m_85845_(Vector3f.f_122225_.m_122270_(((float)this.ticks + partialTicks) * p * 10.0f));
                    } else {
                        float scale = 1.0f + 0.1f * Mth.m_14031_((float)(((float)this.ticks + partialTicks) * p * 20.0f));
                        s.m_85841_(scale, scale, scale);
                    }
                }
            });
        }
    }

    private class BooleanWrapper
    extends ConfigScreen.BooleanItem {
        private static final int ICON_WIDTH = 12;
        protected Button button;
        protected boolean active;
        protected int iconOffset;

        public BooleanWrapper(IConfigValue<Boolean> holder) {
            super((ConfigScreen)CustomConfigScreen.this, holder);
            this.active = false;
            this.iconOffset = 0;
            try {
                this.button = (Button)BOOLEAN_ITEM_BUTTON.get((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.button.m_93666_((Component)Component.m_237113_((String)""));
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.button.m_93666_((Component)Component.m_237113_((String)""));
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CustomConfigSelectScreen.MISC_ICONS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int iconX = this.iconOffset + (int)((double)this.button.f_93620_ + Math.ceil((float)(this.button.m_5711_() - 12) / 2.0f));
            int iconY = (int)((double)this.button.f_93621_ + Math.ceil((float)(this.button.m_93694_() - 12) / 2.0f));
            int u = (Boolean)this.holder.get() != false ? 12 : 0;
            GuiComponent.m_93143_((PoseStack)poseStack, (int)iconX, (int)iconY, (int)this.button.m_93252_(), (float)u, (float)0.0f, (int)12, (int)12, (int)64, (int)64);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public void onResetValue() {
            this.button.m_93666_((Component)Component.m_237113_((String)""));
        }
    }

    private class BooleanWrapperItem
    extends BooleanWrapper {
        private final ItemStack item;

        public BooleanWrapperItem(IConfigValue<Boolean> holder) {
            super(holder);
            this.item = CustomConfigScreen.this.getIcon(this.label.getString().toLowerCase(Locale.ROOT));
            this.iconOffset = 7;
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean on = (Boolean)this.holder.get();
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            int light = 0xF000F0;
            if (!on) {
                light = 0;
            }
            int center = (int)((float)this.button.f_93620_ + (float)this.button.m_5711_() / 2.0f);
            ItemRenderer renderer = CustomConfigScreen.this.f_96542_;
            RenderUtil.renderGuiItemRelative(this.item, center - 8 - this.iconOffset, top + 2, renderer, (a, b) -> {}, light, OverlayTexture.f_118083_);
        }

        @Override
        public void onResetValue() {
            this.button.m_93666_((Component)Component.m_237113_((String)""));
        }
    }
}

