/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;

public class CustomDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>>
extends MapDecorationType<D, M> {
    public static final Codec<CustomDecorationType<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("custom").forGetter(MapDecorationType::getCustomFactoryID)).apply((Applicative)instance, c -> MapDecorationRegistry.CODE_TYPES_FACTORIES.get(c).get()));
    protected final Supplier<M> markerFactory;
    protected final BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory;
    protected final BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory;
    protected final boolean hasMarker;
    private final ResourceLocation factoryID;

    public CustomDecorationType(ResourceLocation factoryID, Supplier<M> markerFactory, BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
        this.hasMarker = true;
        this.factoryID = factoryID;
    }

    public CustomDecorationType(ResourceLocation factoryID, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decoFromBuffer) {
        this.markerFactory = () -> null;
        this.markerFromWorldFactory = (s, d) -> null;
        this.decorationFactory = decoFromBuffer;
        this.hasMarker = false;
        this.factoryID = factoryID;
    }

    @Override
    public ResourceLocation getCustomFactoryID() {
        return this.factoryID;
    }

    @Override
    public boolean hasMarker() {
        return this.hasMarker;
    }

    @Override
    @Nullable
    public D loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return (D)((CustomMapDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public M loadMarkerFromNBT(CompoundTag compound) {
        if (this.hasMarker) {
            MapBlockMarker marker = (MapBlockMarker)this.markerFactory.get();
            try {
                marker.loadFromNBT(compound);
                return (M)marker;
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public M getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        return (M)(this.hasMarker ? (MapBlockMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }
}

