/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class AntiRepostWarning {
    private static final Set<String> MODS = new HashSet<String>();

    public static void addMod(String id) {
        if (!Objects.equals(id, "minecraft")) {
            MODS.add(id);
        }
    }

    public static void run() {
        if (PlatformHelper.isDev()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Set reposted = MODS.stream().filter(AntiRepostWarning::isFileNameSus).collect(Collectors.toSet());
        try {
            for (String m : reposted) {
                String url = PlatformHelper.getModPageUrl(m);
                if (url == null) continue;
                MutableComponent link = Component.m_237115_((String)"message.moonlight.anti_repost_link");
                String modName = PlatformHelper.getModName(m);
                MutableComponent name = Component.m_237113_((String)modName).m_130940_(ChatFormatting.BOLD);
                ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
                link.m_6270_(link.m_7383_().m_131142_(click).m_131162_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD)));
                player.m_5661_((Component)Component.m_237110_((String)"message.moonlight.anti_repost", (Object[])new Object[]{name, link}), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isFileNameSus(String mod) {
        Path path = PlatformHelper.getModFilePath(mod);
        if (path == null || path.getFileName() == null) {
            Moonlight.LOGGER.warn("Failed to get file path of mod {}", (Object)mod);
        } else {
            String fileName = path.getFileName().toString();
            if (fileName.contains(".jar")) {
                return fileName.contains("-Mod-") || fileName.endsWith("-tw");
            }
        }
        return false;
    }
}

