/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model.forge;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class BakedQuadBuilderImpl
implements BakedQuadBuilder {
    private final QuadBakingVertexConsumer inner = new QuadBakingVertexConsumer(s -> {
        this.output = s;
    });
    private final TextureAtlasSprite sprite;
    private final Matrix4f globalTransform;
    private final Matrix3f normalTransf;
    private int emissivity = 0;
    private BakedQuad output;
    private boolean autoDirection = false;

    public static BakedQuadBuilder create(TextureAtlasSprite sprite, @Nullable Matrix4f transformation) {
        return new BakedQuadBuilderImpl(sprite, transformation);
    }

    private BakedQuadBuilderImpl(TextureAtlasSprite sprite, @Nullable Matrix4f transformation) {
        this.globalTransform = transformation;
        this.sprite = sprite;
        this.inner.setShade(true);
        this.inner.setHasAmbientOcclusion(true);
        this.inner.setSprite(sprite);
        this.normalTransf = transformation == null ? null : new Matrix3f((Matrix4fc)transformation).invert().transpose();
    }

    @Override
    public BakedQuad build() {
        Preconditions.checkNotNull((Object)this.output, (Object)"vertex data has not been fully filled");
        if (this.emissivity != 0) {
            QuadTransformers.settingEmissivity((int)this.emissivity).processInPlace(this.output);
        }
        return this.output;
    }

    @Override
    public BakedQuadBuilderImpl vertex(Matrix4f matrix, float x, float y, float z) {
        BakedQuadBuilder.super.vertex(matrix, x, y, z);
        return this;
    }

    public BakedQuadBuilderImpl vertex(double x, double y, double z) {
        if (this.globalTransform != null) {
            this.inner.m_252986_(new Matrix4f((Matrix4fc)this.globalTransform), (float)x, (float)y, (float)z);
        } else {
            this.inner.m_5483_(x, y, z);
        }
        return this;
    }

    public BakedQuadBuilderImpl color(int red, int green, int blue, int alpha) {
        this.inner.m_6122_(red, green, blue, alpha);
        return this;
    }

    public BakedQuadBuilderImpl uv(float u, float v) {
        this.inner.m_7421_(this.sprite.m_118367_((double)(u * 16.0f)), this.sprite.m_118393_((double)(v * 16.0f)));
        return this;
    }

    public BakedQuadBuilderImpl overlayCoords(int u, int v) {
        this.inner.m_7122_(u, v);
        return this;
    }

    public BakedQuadBuilderImpl uv2(int u, int v) {
        this.inner.m_7120_(u, v);
        return this;
    }

    public BakedQuadBuilderImpl normal(float x, float y, float z) {
        if (this.globalTransform != null) {
            Vector3f normal = this.normalTransf.transform(new Vector3f(x, y, z));
            normal.normalize();
            this.inner.m_5601_(normal.x, normal.y, normal.z);
        } else {
            this.inner.m_5601_(x, y, z);
        }
        if (this.autoDirection) {
            this.setDirection(Direction.m_122372_((float)x, (float)y, (float)z));
        }
        return this;
    }

    public void m_5752_() {
        this.inner.m_5752_();
    }

    public void m_7404_(int defaultR, int defaultG, int defaultB, int defaultA) {
        this.inner.m_7404_(defaultR, defaultG, defaultB, defaultA);
    }

    public void m_141991_() {
        this.inner.m_141991_();
    }

    @Override
    public BakedQuadBuilder setDirection(Direction direction) {
        if (this.globalTransform != null) {
            direction = RotHlpr.rotateDirection(direction, this.globalTransform);
        }
        this.inner.setDirection(direction);
        return this;
    }

    @Override
    public BakedQuadBuilder setAmbientOcclusion(boolean ambientOcclusion) {
        this.inner.setHasAmbientOcclusion(ambientOcclusion);
        return this;
    }

    @Override
    public BakedQuadBuilder setTint(int tintIndex) {
        this.inner.setTintIndex(tintIndex);
        return this;
    }

    @Override
    public BakedQuadBuilder setShade(boolean shade) {
        this.inner.setShade(shade);
        return this;
    }

    @Override
    public BakedQuadBuilder lightEmission(int light) {
        this.emissivity = light;
        return this;
    }

    @Override
    public BakedQuadBuilder fromVanilla(BakedQuad q) {
        int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
        this.output = new BakedQuad(v, q.m_111305_(), q.m_111306_(), q.m_173410_(), q.m_111307_(), q.hasAmbientOcclusion());
        return this;
    }

    @Override
    public BakedQuadBuilder setAutoDirection() {
        this.autoDirection = true;
        return this;
    }
}

