/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.client.util.ColorUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TextUtil {
    private static final FormattedCharSequence CURSOR_MARKER = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_);

    public static Pair<List<FormattedCharSequence>, Float> fitLinesToBox(Font font, FormattedText text, float width, float height) {
        int scalingFactor;
        List splitLines;
        float maxLines;
        int fontWidth = font.m_92852_(text);
        do {
            scalingFactor = Mth.m_14143_((float)Mth.m_14116_((float)((float)fontWidth * 8.0f / (width * height))));
            splitLines = font.m_92923_(text, Mth.m_14143_((float)(width * (float)scalingFactor)));
            maxLines = height * (float)scalingFactor / 8.0f;
            ++fontWidth;
        } while (maxLines < (float)splitLines.size());
        return Pair.of((Object)splitLines, (Object)Float.valueOf(1.0f / (float)scalingFactor));
    }

    public static FormattedText parseText(String s) {
        try {
            MutableComponent mutableComponent = Component.Serializer.m_130701_((String)s);
            if (mutableComponent != null) {
                return mutableComponent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FormattedText.m_130775_((String)s);
    }

    public static void renderGuiLine(RenderProperties properties, String string, Font font, GuiGraphics graphics, MultiBufferSource.BufferSource buffer, int cursorPos, int selectionPos, boolean isSelected, boolean blink, int yOffset) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        if (string != null) {
            if (font.m_92718_()) {
                string = font.m_92801_(string);
            }
            FormattedCharSequence charSequence = FormattedCharSequence.m_13714_((String)string, (Style)properties.style);
            float centerX = (float)(-font.m_92724_(charSequence)) / 2.0f;
            TextUtil.renderLineInternal(charSequence, font, centerX, yOffset, matrix4f, (MultiBufferSource)buffer, properties);
            String substring = string.substring(0, Math.min(cursorPos, string.length()));
            if (isSelected) {
                int pX = (int)((float)font.m_92724_(FormattedCharSequence.m_13714_((String)substring, (Style)properties.style)) + centerX);
                if (blink) {
                    if (cursorPos >= string.length()) {
                        TextUtil.renderLineInternal(CURSOR_MARKER, font, pX, yOffset, matrix4f, (MultiBufferSource)buffer, properties);
                    }
                    buffer.m_109911_();
                }
                if (blink && cursorPos < string.length()) {
                    graphics.m_280509_(pX, yOffset - 1, pX + 1, yOffset + 9, 0xFF000000 | properties.textColor);
                }
                if (selectionPos != cursorPos) {
                    int l3 = Math.min(cursorPos, selectionPos);
                    int l1 = Math.max(cursorPos, selectionPos);
                    int i2 = font.m_92895_(string.substring(0, l3)) - font.m_92895_(string) / 2;
                    int j2 = font.m_92895_(string.substring(0, l1)) - font.m_92895_(string) / 2;
                    int startX = Math.min(i2, j2);
                    int startY = Math.max(i2, j2);
                    RenderSystem.enableColorLogicOp();
                    RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
                    graphics.m_280509_(startX, startY, yOffset, yOffset + 9, -16776961);
                    RenderSystem.disableColorLogicOp();
                }
            }
            if (!isSelected || !blink) {
                buffer.m_109911_();
            }
        }
    }

    public static void renderGuiText(RenderProperties properties, String[] guiLines, Font font, GuiGraphics graphics, MultiBufferSource.BufferSource buffer, int cursorPos, int selectionPos, int currentLine, boolean blink, int lineSpacing) {
        int nOfLines = guiLines.length;
        for (int line = 0; line < nOfLines; ++line) {
            int yOffset = line * lineSpacing - nOfLines * 5;
            TextUtil.renderGuiLine(properties, guiLines[line], font, graphics, buffer, cursorPos, selectionPos, line == currentLine, blink, yOffset);
        }
    }

    public static void renderLine(FormattedCharSequence formattedCharSequences, Font font, float yOffset, PoseStack poseStack, MultiBufferSource buffer, RenderProperties properties) {
        if (formattedCharSequences == null) {
            return;
        }
        float x = (float)(-font.m_92724_(formattedCharSequences)) / 2.0f;
        TextUtil.renderLineInternal(formattedCharSequences, font, x, yOffset, poseStack.m_85850_().m_252922_(), buffer, properties);
    }

    public static void renderAllLines(FormattedCharSequence[] charSequences, int ySeparation, Font font, PoseStack poseStack, MultiBufferSource buffer, RenderProperties properties) {
        for (int i = 0; i < charSequences.length; ++i) {
            TextUtil.renderLine(charSequences[i], font, ySeparation * i, poseStack, buffer, properties);
        }
    }

    private static void renderLineInternal(FormattedCharSequence formattedCharSequences, Font font, float xOffset, float yOffset, Matrix4f matrix4f, MultiBufferSource buffer, RenderProperties properties) {
        if (properties.outline) {
            font.m_168645_(formattedCharSequences, xOffset, yOffset, properties.textColor, properties.darkenedColor, matrix4f, buffer, properties.light);
        } else {
            font.m_272191_(formattedCharSequences, xOffset, yOffset, properties.darkenedColor, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, properties.light);
        }
    }

    private static int getDarkenedColor(int color, boolean glowing, float mult) {
        if (color == DyeColor.BLACK.m_41071_() && glowing) {
            return -988212;
        }
        return ColorUtil.multiply(color, 0.4f * (glowing ? 1.0f : mult));
    }

    private static int getDarkenedColor(int color, boolean glowing) {
        return TextUtil.getDarkenedColor(color, glowing, 1.0f);
    }

    public static RenderProperties renderProperties(DyeColor dyeColor, boolean glowing, int combinedLight, Style style, Vector3f normal, BooleanSupplier isVeryNear) {
        return TextUtil.renderProperties(dyeColor, glowing, 1.0f, combinedLight, style, normal, isVeryNear);
    }

    public static RenderProperties renderProperties(DyeColor dyeColor, boolean glowing, float darkColorMult, int combinedLight, Style style, Vector3f normal, BooleanSupplier isVeryNear) {
        boolean outline = glowing && (dyeColor == DyeColor.BLACK || isVeryNear.getAsBoolean());
        int textColor = dyeColor.m_41071_();
        float shading = ColorUtil.getShading(normal);
        int color = glowing ? textColor : ColorUtil.multiply(textColor, shading);
        int dark = !glowing || outline ? TextUtil.getDarkenedColor(textColor, glowing, darkColorMult * shading) : color;
        return new RenderProperties(color, dark, outline, glowing ? combinedLight : 0xF000F0, style);
    }

    public record RenderProperties(int textColor, int darkenedColor, boolean outline, int light, Style style) {
        @Deprecated(forRemoval=true)
        public RenderProperties(DyeColor color, boolean outline, int combinedLight, Style style, BooleanSupplier isVeryNear) {
            this(color.m_41071_(), TextUtil.getDarkenedColor(color.m_41071_(), outline), outline && (isVeryNear.getAsBoolean() || color == DyeColor.BLACK), outline ? combinedLight : 0xF000F0, style);
        }
    }
}

