/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntUnaryOperator;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class VertexUtil {
    private static final int POSITION = 0;
    private static final int COLOR = 3;
    private static final int UV0 = 4;
    private static final int NORMAL = 7;

    private static int getStride() {
        return DefaultVertexFormat.f_85811_.m_86017_();
    }

    public static List<BakedQuad> swapSprite(List<BakedQuad> quads, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> newList = new ArrayList<BakedQuad>();
        for (BakedQuad q : quads) {
            newList.add(VertexUtil.swapSprite(q, sprite));
        }
        return newList;
    }

    public static BakedQuad swapSprite(BakedQuad q, TextureAtlasSprite sprite) {
        TextureAtlasSprite oldSprite = q.m_173410_();
        int stride = VertexUtil.getStride();
        int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
        float segmentWScale = (float)sprite.m_245424_().m_246492_() / (float)oldSprite.m_245424_().m_246492_();
        float segmentHScale = (float)sprite.m_245424_().m_245330_() / (float)oldSprite.m_245424_().m_245330_();
        for (int i = 0; i < 4; ++i) {
            int offset = i * stride + 4;
            float originalU = Float.intBitsToFloat(v[offset]);
            float originalV = Float.intBitsToFloat(v[offset + 1]);
            float u1 = (originalU - oldSprite.m_118409_()) * segmentWScale;
            v[offset] = Float.floatToRawIntBits(u1 + sprite.m_118409_());
            float v1 = (originalV - oldSprite.m_118411_()) * segmentHScale;
            v[offset + 1] = Float.floatToRawIntBits(v1 + sprite.m_118411_());
        }
        return new BakedQuad(v, q.m_111305_(), q.m_111306_(), sprite, q.m_111307_());
    }

    public static void transformVertices(int[] v, Matrix3f transform) {
        Matrix4f transform4 = new Matrix4f();
        transform4.set((Matrix3fc)transform);
        VertexUtil.transformVertices(v, transform4);
    }

    public static void transformVertices(int[] v, Matrix4f transform) {
        int stride = VertexUtil.getStride();
        for (int i = 0; i < 4; ++i) {
            int offset = i * stride + 0;
            float originalX = Float.intBitsToFloat(v[offset]) - 0.5f;
            float originalY = Float.intBitsToFloat(v[offset + 1]) - 0.5f;
            float originalZ = Float.intBitsToFloat(v[offset + 2]) - 0.5f;
            Vector4f vec = new Vector4f(originalX, originalY, originalZ, 1.0f);
            vec.mul((Matrix4fc)transform);
            vec.div(vec.w);
            v[offset] = Float.floatToRawIntBits(vec.x() + 0.5f);
            v[offset + 1] = Float.floatToRawIntBits(vec.y() + 0.5f);
            v[offset + 2] = Float.floatToRawIntBits(vec.z() + 0.5f);
        }
        Matrix3f normalTransform = new Matrix3f((Matrix4fc)transform).invert().transpose();
        for (int i = 0; i < 4; ++i) {
            int offset = i * stride + 7;
            int normalIn = v[offset];
            if ((normalIn & 0xFFFFFF) == 0) continue;
            float normalX = (float)((byte)(normalIn & 0xFF)) / 127.0f;
            float normalY = (float)((byte)(normalIn >> 8 & 0xFF)) / 127.0f;
            float normalZ = (float)((byte)(normalIn >> 16 & 0xFF)) / 127.0f;
            Vector3f vec = new Vector3f(normalX, normalY, normalZ);
            vec.mul((Matrix3fc)normalTransform);
            vec.normalize();
            v[offset] = (byte)(vec.x() * 127.0f) & 0xFF | ((byte)(vec.y() * 127.0f) & 0xFF) << 8 | ((byte)(vec.z() * 127.0f) & 0xFF) << 16 | normalIn & 0xFF000000;
        }
    }

    public static void recolorVertices(int[] v, IntUnaryOperator indexToABGR) {
        int stride = VertexUtil.getStride();
        for (int i = 0; i < 4; ++i) {
            v[i * stride + 3] = indexToABGR.applyAsInt(i);
        }
    }

    public static void recolorVertices(int[] v, int ABGR) {
        VertexUtil.recolorVertices(v, i -> ABGR);
    }

    public static void addCube(VertexConsumer builder, PoseStack poseStack, float width, float height, int light, int color) {
        VertexUtil.addCube(builder, poseStack, 0.0f, 0.0f, width, height, light, color);
    }

    public static void addCube(VertexConsumer builder, PoseStack poseStack, float uOff, float vOff, float width, float height, int light, int color) {
        VertexUtil.addCube(builder, poseStack, uOff, vOff, width, height, light, color, 1.0f, true, true, false);
    }

    public static void addCube(VertexConsumer builder, PoseStack poseStack, float uOff, float vOff, float w, float h, int combinedLightIn, int color, float alpha, boolean up, boolean down, boolean wrap) {
        VertexUtil.addCube(builder, poseStack, uOff, 1.0f - (vOff + h), uOff + w, 1.0f - vOff, w, h, combinedLightIn, color, alpha, up, down, wrap);
    }

    public static void addCube(VertexConsumer builder, PoseStack poseStack, float minU, float minV, float maxU, float maxV, float w, float h, int combinedLightIn, int color, float alpha, boolean up, boolean down, boolean wrap) {
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float minV2 = maxV - w;
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int a = (int)(255.0f * alpha);
        float hw = w / 2.0f;
        float hh = h / 2.0f;
        float inc = 0.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, hh, 0.0f);
        for (Direction d : Direction.values()) {
            float v0 = minV;
            float t = hw;
            float y0 = -hh;
            float y1 = hh;
            float i = inc;
            if (d.m_122434_() == Direction.Axis.Y) {
                if (!up && d == Direction.UP || !down) continue;
                t = hh;
                y0 = -hw;
                y1 = hw;
                v0 = minV2;
            } else if (wrap) {
                inc += w;
            }
            poseStack.m_85836_();
            poseStack.m_252781_(RotHlpr.rot(d));
            poseStack.m_252880_(0.0f, 0.0f, -t);
            VertexUtil.addQuad(builder, poseStack, -hw, y0, hw, y1, minU + i, v0, maxU + i, maxV, r, g, b, a, lu, lv);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public static void addQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float x1, float y1, int lu, int lv) {
        VertexUtil.addQuad(builder, poseStack, x0, y0, x1, y1, 255, 255, 255, 255, lu, lv);
    }

    public static void addQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float x1, float y1, int r, int g, int b, int a, int lu, int lv) {
        VertexUtil.addQuad(builder, poseStack, x0, y0, x1, y1, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, lu, lv);
    }

    public static void addQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, int r, int g, int b, int a, int lu, int lv) {
        PoseStack.Pose last = poseStack.m_85850_();
        Vector3f vector3f = last.m_252943_().transform(new Vector3f(0.0f, 0.0f, -1.0f));
        float nx = vector3f.x;
        float ny = vector3f.y;
        float nz = vector3f.z;
        VertexUtil.vertF(builder, poseStack, x0, y1, 0.0f, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtil.vertF(builder, poseStack, x1, y1, 0.0f, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtil.vertF(builder, poseStack, x1, y0, 0.0f, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtil.vertF(builder, poseStack, x0, y0, 0.0f, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void vert(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z);
        builder.m_85950_(r, g, b, a);
        builder.m_7421_(u, v);
        builder.m_7122_(0, 10);
        builder.m_7120_(lu, lv);
        builder.m_252939_(poseStack.m_85850_().m_252943_(), nx, ny, nz);
        builder.m_5752_();
    }

    private static void vertF(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int r, int g, int b, int a, int lu, int lv, float nx, float ny, float nz) {
        builder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z);
        builder.m_6122_(r, g, b, a);
        builder.m_7421_(u, v);
        builder.m_7122_(0, 10);
        builder.m_7120_(lu, lv);
        builder.m_5601_(nx, ny, nz);
        builder.m_5752_();
    }

    private static void vertF(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int color, int lu, int lv, float nx, float ny, float nz) {
        builder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z);
        builder.m_193479_(color);
        builder.m_7421_(u, v);
        builder.m_7122_(0, 10);
        builder.m_7120_(lu, lv);
        builder.m_5601_(nx, ny, nz);
        builder.m_5752_();
    }
}

