/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.forge.MapDecorationRegistryImpl;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.JsonDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MapDecorationRegistry {
    public static final Codec<MapDecorationType<?, ?>> CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    public static final Codec<MapDecorationType<?, ?>> NETWORK_CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.NETWORK_CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    public static final Map<ResourceLocation, CustomDataHolder<?>> CUSTOM_MAP_DATA_TYPES = new HashMap();
    public static final ResourceKey<Registry<MapDecorationType<?, ?>>> KEY = ResourceKey.m_135788_((ResourceLocation)Moonlight.res((PlatHelper.getPlatform().isFabric() ? "moonlight/" : "") + "map_markers"));
    public static final ResourceLocation GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final Map<ResourceLocation, CustomDecorationType<?, ?>> CODE_TYPES_FACTORIES = new HashMap();

    public static <T> void registerCustomMapSavedData(ResourceLocation name, Class<T> type, Function<CompoundTag, T> load, BiConsumer<CompoundTag, T> save, PropertyDispatch.TriFunction<MapItemSavedData, Entity, T, Boolean> onItemUpdate, PropertyDispatch.TriFunction<MapItemSavedData, ItemStack, T, Component> onItemTooltip) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + name);
        }
        CUSTOM_MAP_DATA_TYPES.put(name, new CustomDataHolder<T>(name, load, save, onItemUpdate, onItemTooltip));
    }

    public static MapDecorationType<?, ?> getGenericStructure() {
        return MapDecorationRegistry.get(GENERIC_STRUCTURE_ID);
    }

    public static <T extends CustomDecorationType<?, ?>> void registerCustomType(T markerType) {
        CODE_TYPES_FACTORIES.put(markerType.getCustomFactoryID(), markerType);
    }

    public static CustomDecorationType<?, ?> getCustomType(ResourceLocation resourceLocation) {
        return Objects.requireNonNull(CODE_TYPES_FACTORIES.get(resourceLocation), "No map decoration type with id: " + resourceLocation);
    }

    public static MapDecorationType<?, ?> getAssociatedType(Holder<Structure> structure) {
        for (MapDecorationType<?, ?> v : MapDecorationRegistry.getValues()) {
            Optional<HolderSet<Structure>> associatedStructure = v.getAssociatedStructure();
            if (!associatedStructure.isPresent() || !associatedStructure.get().m_203333_(structure)) continue;
            return v;
        }
        return MapDecorationRegistry.getGenericStructure();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDecorationRegistryImpl.init();
    }

    public static Registry<MapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().m_175515_(KEY);
    }

    public static Registry<MapDecorationType<?, ?>> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(KEY);
    }

    public static Collection<MapDecorationType<?, ?>> getValues() {
        return MapDecorationRegistry.hackyGetRegistry().m_123024_().toList();
    }

    public static Set<Map.Entry<ResourceKey<MapDecorationType<?, ?>>, MapDecorationType<?, ?>>> getEntries() {
        return MapDecorationRegistry.hackyGetRegistry().m_6579_();
    }

    @Nullable
    public static MapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return MapDecorationRegistry.get(new ResourceLocation(id));
    }

    public static MapDecorationType<?, ?> get(ResourceLocation id) {
        Registry<MapDecorationType<?, ?>> reg = MapDecorationRegistry.hackyGetRegistry();
        MapDecorationType r = (MapDecorationType)reg.m_7745_(id);
        if (r == null) {
            return (MapDecorationType)reg.m_7745_(GENERIC_STRUCTURE_ID);
        }
        return r;
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(ResourceLocation id) {
        return MapDecorationRegistry.hackyGetRegistry().m_6612_(id);
    }

    @Nullable
    @ApiStatus.Internal
    public static MapBlockMarker<?> readWorldMarker(CompoundTag compound) {
        for (Map.Entry<ResourceKey<MapDecorationType<?, ?>>, MapDecorationType<?, ?>> e : MapDecorationRegistry.getEntries()) {
            String id = e.getKey().m_135782_().toString();
            if (!compound.m_128441_(id)) continue;
            return e.getValue().loadMarkerFromNBT(compound.m_128469_(id));
        }
        return null;
    }

    @ApiStatus.Internal
    public static List<MapBlockMarker<?>> getMarkersFromWorld(BlockGetter reader, BlockPos pos) {
        ArrayList list = new ArrayList();
        for (MapDecorationType<?, ?> type : MapDecorationRegistry.getValues()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }
}

