/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.item.FuelBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.QuadConsumer;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.forge.RegHelperImpl;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class RegHelper {
    private static final List<ResourceLocation> DEFAULT_AFTER_ENTRIES = List.of(CreativeModeTabs.f_256731_.m_135782_());

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T, E extends T> RegSupplier<E> register(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> regKey) {
        void var2_2;
        void var1_1;
        return RegHelperImpl.register(name, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void registerInBatch(Registry<T> reg, Consumer<Registrator<T>> eventListener) {
        void var1_1;
        RegHelperImpl.registerInBatch(reg, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T, E extends T> RegSupplier<E> registerAsync(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> regKey) {
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerAsync(name, var1_1, var2_2);
    }

    public static <T extends Block> RegSupplier<T> registerBlock(ResourceLocation name, Supplier<T> block) {
        return RegHelper.register(name, block, Registries.f_256747_);
    }

    public static <T extends Block> RegSupplier<T> registerBlockWithItem(ResourceLocation name, Supplier<T> blockFactory) {
        return RegHelper.registerBlockWithItem(name, blockFactory, 0);
    }

    public static <T extends Block> RegSupplier<T> registerBlockWithItem(ResourceLocation name, Supplier<T> blockFactory, int burnTime) {
        return RegHelper.registerBlockWithItem(name, blockFactory, new Item.Properties(), burnTime);
    }

    public static <T extends Block> RegSupplier<T> registerBlockWithItem(ResourceLocation name, Supplier<T> blockFactory, Item.Properties properties, int burnTime) {
        RegSupplier block = RegHelper.registerBlock(name, blockFactory);
        RegHelper.registerItem(name, () -> {
            if (burnTime == 0) {
                return new BlockItem((Block)block.get(), properties);
            }
            return new FuelBlockItem((Block)block.get(), properties, () -> burnTime);
        });
        return block;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Fluid> RegSupplier<T> registerFluid(ResourceLocation name, Supplier<T> fluid) {
        void var1_1;
        return RegHelperImpl.registerFluid(name, var1_1);
    }

    public static <T extends Item> RegSupplier<T> registerItem(ResourceLocation name, Supplier<T> item) {
        return RegHelper.register(name, item, Registries.f_256913_);
    }

    public static <T extends Feature<?>> RegSupplier<T> registerFeature(ResourceLocation name, Supplier<T> feature) {
        return RegHelper.register(name, feature, Registries.f_256833_);
    }

    public static <T extends StructureType<?>> RegSupplier<T> registerStructure(ResourceLocation name, Supplier<T> feature) {
        return RegHelper.registerAsync(name, feature, Registries.f_256938_);
    }

    public static <T extends SoundEvent> RegSupplier<T> registerSound(ResourceLocation name, Supplier<T> sound) {
        return RegHelper.register(name, sound, Registries.f_256840_);
    }

    public static RegSupplier<SoundEvent> registerSound(ResourceLocation name) {
        return RegHelper.registerSound(name, () -> SoundEvent.m_262824_((ResourceLocation)name));
    }

    public static RegSupplier<SoundEvent> registerSound(ResourceLocation name, float fixedRange) {
        return RegHelper.registerSound(name, () -> SoundEvent.m_262856_((ResourceLocation)name, (float)fixedRange));
    }

    public static <T extends PaintingVariant> RegSupplier<T> registerPainting(ResourceLocation name, Supplier<T> painting) {
        return RegHelper.register(name, painting, Registries.f_256836_);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <C extends AbstractContainerMenu> RegSupplier<MenuType<C>> registerMenuType(ResourceLocation name, TriFunction<Integer, Inventory, FriendlyByteBuf, C> containerFactory) {
        void var1_1;
        return RegHelperImpl.registerMenuType(name, var1_1);
    }

    public static <T extends MobEffect> RegSupplier<T> registerEffect(ResourceLocation name, Supplier<T> effect) {
        return RegHelper.register(name, effect, Registries.f_256929_);
    }

    public static <T extends Enchantment> RegSupplier<T> registerEnchantment(ResourceLocation name, Supplier<T> enchantment) {
        return RegHelper.register(name, enchantment, Registries.f_256762_);
    }

    public static <T extends SensorType<? extends Sensor<?>>> RegSupplier<T> registerSensor(ResourceLocation name, Supplier<T> sensorType) {
        return RegHelper.register(name, sensorType, Registries.f_256937_);
    }

    public static <T extends Sensor<?>> RegSupplier<SensorType<T>> registerSensorI(ResourceLocation name, Supplier<T> sensor) {
        return RegHelper.register(name, () -> new SensorType(sensor), Registries.f_256937_);
    }

    public static <T extends Activity> RegSupplier<T> registerActivity(ResourceLocation name, Supplier<T> activity) {
        return RegHelper.register(name, activity, Registries.f_257025_);
    }

    public static RegSupplier<Activity> registerActivity(ResourceLocation name) {
        return RegHelper.registerActivity(name, () -> new Activity(name.m_135815_()));
    }

    public static <T extends Schedule> RegSupplier<T> registerSchedule(ResourceLocation name, Supplier<T> schedule) {
        return RegHelper.register(name, schedule, Registries.f_256723_);
    }

    public static <T extends MemoryModuleType<?>> RegSupplier<T> registerMemoryModule(ResourceLocation name, Supplier<T> memory) {
        return RegHelper.register(name, memory, Registries.f_257023_);
    }

    public static <U> RegSupplier<MemoryModuleType<U>> registerMemoryModule(ResourceLocation name, @Nullable Codec<U> codec) {
        return RegHelper.register(name, () -> new MemoryModuleType(Optional.ofNullable(codec)), Registries.f_257023_);
    }

    public static <T extends RecipeSerializer<?>> RegSupplier<T> registerRecipeSerializer(ResourceLocation name, Supplier<T> recipe) {
        return RegHelper.register(name, recipe, Registries.f_256764_);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends CraftingRecipe> RegSupplier<RecipeSerializer<T>> registerSpecialRecipe(ResourceLocation name, SimpleCraftingRecipeSerializer.Factory<T> factory) {
        void var1_1;
        return RegHelperImpl.registerSpecialRecipe(name, var1_1);
    }

    public static <T extends Recipe<?>> Supplier<RecipeType<T>> registerRecipeType(ResourceLocation name) {
        return RegHelper.register(name, () -> {
            final String id = name.toString();
            return new RecipeType<T>(){

                public String toString() {
                    return id;
                }
            };
        }, Registries.f_256954_);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> RegSupplier<T> registerBlockEntityType(ResourceLocation name, Supplier<T> blockEntity) {
        return RegHelper.register(name, blockEntity, Registries.f_256922_);
    }

    public static RegSupplier<SimpleParticleType> registerParticle(ResourceLocation name) {
        return RegHelper.register(name, PlatHelper::newParticle, Registries.f_256890_);
    }

    public static RegSupplier<BannerPattern> registerBannerPattern(ResourceLocation name, String patternId) {
        return RegHelper.register(name, () -> new BannerPattern(patternId), Registries.f_256969_);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height) {
        return RegHelper.registerEntityType(name, factory, category, width, height, 5);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange) {
        return RegHelper.registerEntityType(name, factory, category, width, height, clientTrackingRange, 3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange, int updateInterval) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerEntityType(name, var1_1, (MobCategory)var2_2, (float)var3_3, (float)var4_4, (int)var5_5, (int)var6_6);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, Supplier<EntityType<T>> type) {
        return RegHelper.register(name, type, Registries.f_256939_);
    }

    public static void registerCompostable(ItemLike name, float chance) {
        ComposterBlock.f_51914_.put((Object)name, chance);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemBurnTime(Item item, int burnTime) {
        void var1_1;
        RegHelperImpl.registerItemBurnTime(item, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockFlammability(Block item, int fireSpread, int flammability) {
        void var2_2;
        void var1_1;
        RegHelperImpl.registerBlockFlammability(item, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerVillagerTrades(VillagerProfession profession, int level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        void var2_2;
        void var1_1;
        RegHelperImpl.registerVillagerTrades(profession, (int)var1_1, (Consumer<List<VillagerTrades.ItemListing>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerWanderingTraderTrades(int level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        void var1_1;
        RegHelperImpl.registerWanderingTraderTrades(level, (Consumer<List<VillagerTrades.ItemListing>>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSimpleRecipeCondition(ResourceLocation id, Predicate<String> predicate) {
        void var1_1;
        RegHelperImpl.registerSimpleRecipeCondition(id, (Predicate<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RegSupplier<CreativeModeTab> registerCreativeModeTab(ResourceLocation name, List<ResourceLocation> afterTabs, List<ResourceLocation> beforeTabs, Consumer<CreativeModeTab.Builder> configurator) {
        void var3_3;
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerCreativeModeTab(name, (List<ResourceLocation>)var1_1, (List<ResourceLocation>)var2_2, (Consumer<CreativeModeTab.Builder>)var3_3);
    }

    public static RegSupplier<CreativeModeTab> registerCreativeModeTab(ResourceLocation name, Consumer<CreativeModeTab.Builder> configurator) {
        return RegHelper.registerCreativeModeTab(name, DEFAULT_AFTER_ENTRIES, List.of(), configurator);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addItemsToTabsRegistration(Consumer<ItemToTabEvent> event) {
        RegHelperImpl.addItemsToTabsRegistration(event);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addAttributeRegistration(Consumer<AttributeEvent> eventListener) {
        RegHelperImpl.addAttributeRegistration(eventListener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addSpawnPlacementsRegistration(Consumer<SpawnPlacementEvent> eventListener) {
        RegHelperImpl.addSpawnPlacementsRegistration(eventListener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addCommandRegistration(CommandRegistration eventListener) {
        RegHelperImpl.addCommandRegistration(eventListener);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBaseBlockSet(ResourceLocation baseName, Block parentBlock) {
        return RegHelper.registerBaseBlockSet(baseName, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parentBlock));
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBaseBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties) {
        return RegHelper.registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerReducedBlockSet(ResourceLocation baseName, Block parentBlock) {
        return RegHelper.registerReducedBlockSet(baseName, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parentBlock));
    }

    public static EnumMap<VariantType, Supplier<Block>> registerReducedBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties) {
        return RegHelper.registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.STAIRS, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerFullBlockSet(ResourceLocation baseName, Block parentBlock) {
        return RegHelper.registerFullBlockSet(baseName, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parentBlock));
    }

    public static EnumMap<VariantType, Supplier<Block>> registerFullBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties) {
        return RegHelper.registerBlockSet(VariantType.values(), baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBlockSet(VariantType[] types, ResourceLocation baseName, BlockBehaviour.Properties properties) {
        if (!new ArrayList<VariantType>(List.of(types)).contains((Object)VariantType.BLOCK)) {
            throw new IllegalStateException("Must contain base variant type");
        }
        RegSupplier<Block> block = RegHelper.registerBlock(baseName, () -> VariantType.BLOCK.create(properties, null));
        RegHelper.registerItem(baseName, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        EnumMap<VariantType, Supplier<Block>> m = RegHelper.registerBlockSet(types, block, baseName.m_135827_());
        m.put(VariantType.BLOCK, block);
        return m;
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBlockSet(VariantType[] types, RegSupplier<? extends Block> baseBlock, String modId) {
        ResourceLocation baseName = baseBlock.getId();
        EnumMap<VariantType, Supplier<Block>> map = new EnumMap<VariantType, Supplier<Block>>(VariantType.class);
        for (VariantType type : types) {
            if (type.equals((Object)VariantType.BLOCK)) continue;
            Object name = baseName.m_135815_();
            name = (String)name + "_" + type.name().toLowerCase(Locale.ROOT);
            ResourceLocation blockId = new ResourceLocation(modId, (String)name);
            RegSupplier<Block> block = RegHelper.registerBlock(blockId, () -> type.create(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)baseBlock.get())), baseBlock::get));
            RegHelper.registerItem(blockId, () -> new BlockItem((Block)block.get(), new Item.Properties()));
            map.put(type, block);
        }
        return map;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addLootTableInjects(Consumer<LootInjectEvent> eventListener) {
        RegHelperImpl.addLootTableInjects(eventListener);
    }

    public static enum VariantType {
        BLOCK(Block::new),
        STAIRS(ModStairBlock::new),
        SLAB(SlabBlock::new),
        WALL(WallBlock::new);

        private final BiFunction<Supplier<Block>, BlockBehaviour.Properties, Block> constructor;

        private VariantType(BiFunction<Supplier<Block>, BlockBehaviour.Properties, Block> constructor) {
            this.constructor = constructor;
        }

        private VariantType(Function<BlockBehaviour.Properties, Block> constructor) {
            this.constructor = (b, p) -> (Block)constructor.apply((BlockBehaviour.Properties)p);
        }

        public Block create(BlockBehaviour.Properties properties, @Nullable Supplier<Block> parent) {
            return this.constructor.apply(parent, properties);
        }

        public static void addToTab(ItemToTabEvent event, Map<VariantType, Supplier<Block>> blocks) {
            EnumMap<VariantType, Supplier<Block>> m = new EnumMap<VariantType, Supplier<Block>>(blocks);
            event.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike[])m.values().stream().map(Supplier::get).toArray(Block[]::new));
        }
    }

    public static interface LootInjectEvent {
        public ResourceLocation getTable();

        public void addTableReference(ResourceLocation var1);
    }

    @FunctionalInterface
    public static interface CommandRegistration {
        public void accept(CommandDispatcher<CommandSourceStack> var1, CommandBuildContext var2, Commands.CommandSelection var3);
    }

    @FunctionalInterface
    public static interface SpawnPlacementEvent {
        public <T extends Entity> void register(EntityType<T> var1, SpawnPlacements.Type var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }

    @FunctionalInterface
    public static interface AttributeEvent {
        public void register(EntityType<? extends LivingEntity> var1, AttributeSupplier.Builder var2);
    }

    public record ItemToTabEvent(QuadConsumer<ResourceKey<CreativeModeTab>, @Nullable Predicate<ItemStack>, Boolean, Collection<ItemStack>> action) {
        public void add(ResourceKey<CreativeModeTab> tab, ItemLike ... items) {
            this.addAfter(tab, null, items);
        }

        public void add(ResourceKey<CreativeModeTab> tab, ItemStack ... items) {
            this.addAfter(tab, null, items);
        }

        public void addAfter(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.action.accept(tab, target, true, Arrays.stream(items).map(i -> i.m_5456_().m_7968_()).toList());
        }

        public void addAfter(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            this.action.accept(tab, target, true, List.of(items));
        }

        public void addBefore(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.action.accept(tab, target, false, Arrays.stream(items).map(i -> i.m_5456_().m_7968_()).toList());
        }

        public void addBefore(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            this.action.accept(tab, target, false, List.of(items));
        }
    }
}

