/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.setup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.QuadConsumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public interface IDeferredCommonSetup {
    default public void setup() {
    }

    default public void asyncSetup() {
    }

    default public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
    }

    default public void registerAttributes(AttributeEvent event) {
    }

    default public void registerSpawnPlacements(SpawnPlacementEvent event) {
    }

    default public void registerServerReloadListener(ReloadListenerEvent event) {
    }

    default public void registerBuiltinDataPack(DataPackEvent event) {
    }

    default public void addItemsToTabs(ItemToTabEvent event) {
    }

    default public void addLootTableInjects(LootInjectEvent event) {
    }

    public static interface LootInjectEvent {
        public ResourceLocation getTable();

        public void addTableReference(ResourceLocation var1);
    }

    public record ItemToTabEvent(QuadConsumer<ResourceKey<CreativeModeTab>, @Nullable Predicate<ItemStack>, Boolean, Collection<ItemStack>> action) {
        public void add(ResourceKey<CreativeModeTab> tab, ItemLike ... items) {
            this.addAfter(tab, null, items);
        }

        public void add(ResourceKey<CreativeModeTab> tab, ItemStack ... items) {
            this.addAfter(tab, null, items);
        }

        public void addAfter(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.action.accept(tab, target, true, Arrays.stream(items).map(i -> i.m_5456_().m_7968_()).toList());
        }

        public void addAfter(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            this.action.accept(tab, target, true, List.of(items));
        }

        public void addBefore(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.action.accept(tab, target, false, Arrays.stream(items).map(i -> i.m_5456_().m_7968_()).toList());
        }

        public void addBefore(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            this.action.accept(tab, target, false, List.of(items));
        }
    }

    @FunctionalInterface
    public static interface DataPackEvent {
        public void register(Supplier<Pack> var1);
    }

    @FunctionalInterface
    public static interface ReloadListenerEvent {
        public void register(Supplier<PreparableReloadListener> var1, ResourceLocation var2);
    }

    @FunctionalInterface
    public static interface SpawnPlacementEvent {
        public <T extends Entity> void register(EntityType<T> var1, SpawnPlacements.Type var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }

    @FunctionalInterface
    public static interface AttributeEvent {
        public void register(EntityType<? extends LivingEntity> var1, AttributeSupplier.Builder var2);
    }
}

