/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MapItemSavedData.HoldingPlayer.class})
public abstract class HoldingPlayerMixin
implements IHoldingPlayerExtension {
    @Unique
    private boolean moonlight$customDataDirty = true;
    @Unique
    private boolean moonlight$customMarkersDirty = true;
    @Unique
    private int moonlight$dirtyDecorationTicks = 0;
    @Unique
    private int moonlight$volatileDecorationRefreshTicks = 0;
    @Final
    @Shadow
    MapItemSavedData f_77961_;
    @Shadow
    @Final
    public Player f_77959_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initializeDirty(MapItemSavedData mapItemSavedData, Player player, CallbackInfo ci) {
        this.moonlight$customMarkersDirty = true;
        this.moonlight$customDataDirty = true;
    }

    @ModifyReturnValue(method={"nextUpdatePacket"}, at={@At(value="TAIL")})
    public Packet<?> addExtraPacketData(@Nullable Packet<?> packet, int mapId) {
        MapItemSavedData data = this.f_77961_;
        ExpandedMapData ed = (ExpandedMapData)data;
        boolean updateData = false;
        boolean updateDeco = false;
        if (this.moonlight$customDataDirty) {
            this.moonlight$customDataDirty = false;
            updateData = true;
        }
        if (this.moonlight$customMarkersDirty && this.moonlight$dirtyDecorationTicks++ % 5 == 0) {
            this.moonlight$customMarkersDirty = false;
            updateDeco = true;
        }
        ArrayList extra = new ArrayList();
        if (updateDeco || this.moonlight$volatileDecorationRefreshTicks++ % 100 == 0) {
            for (MapDecorationType<?, ?> t : MapDecorationRegistry.getValues()) {
                Set<?> l = t.getDynamicDecorations(this.f_77959_, data);
                if (l.isEmpty()) continue;
                extra.addAll(l);
            }
            updateData = true;
        }
        if (updateData || updateDeco) {
            if (packet == null) {
                packet = new ClientboundMapItemDataPacket(mapId, this.f_77961_.f_77890_, this.f_77961_.f_77892_, null, null);
            }
            IMapDataPacketExtension ep = (IMapDataPacketExtension)packet;
            if (updateData) {
                ep.moonlight$sendCustomMapData(ed.getCustomData().values());
            }
            if (updateDeco) {
                ArrayList<CustomMapDecoration> decorations = new ArrayList<CustomMapDecoration>(ed.getCustomDecorations().values());
                decorations.addAll(extra);
                ep.moonlight$sendCustomDecorations(decorations);
            }
        }
        return packet;
    }

    @Override
    public void moonlight$setCustomDataDirty() {
        this.moonlight$customDataDirty = true;
    }

    @Override
    public void moonlight$setCustomMarkersDirty() {
        this.moonlight$customMarkersDirty = true;
    }
}

