/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUpConfig;
import com.supermartijn642.packedup.screen.BackpackContainer;
import com.supermartijn642.packedup.storage.BackpackInventory;
import com.supermartijn642.packedup.storage.BackpackStorageManager;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PackedUpCommon {
    public static void openBackpackInventory(ItemStack stack, Player player, int bagSlot) {
        PackedUpCommon.updateOldBackpack(stack);
        BackpackType type = ((BackpackItem)stack.getItem()).type;
        MutableComponent name = TextComponents.itemStack((ItemStack)stack).get();
        Integer inventoryIndex = (Integer)stack.get(BackpackItem.INVENTORY_ID);
        if (inventoryIndex == null || BackpackStorageManager.getInventory(inventoryIndex) == null) {
            inventoryIndex = BackpackStorageManager.createInventoryIndex(type);
            stack.set(BackpackItem.INVENTORY_ID, (Object)inventoryIndex);
        } else {
            BackpackStorageManager.getInventory(inventoryIndex).adjustSize(type);
        }
        BackpackInventory inventory = BackpackStorageManager.getInventory(inventoryIndex);
        CommonUtils.openContainer((BaseContainer)new BackpackContainer(player, bagSlot, (Component)name, inventoryIndex, type, inventory.bagsInThisBag, inventory.bagsThisBagIsIn, inventory.layer));
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDropsEvent e) {
        List<ItemEntity> stacksToBeSaved;
        if (e.getEntity() instanceof Player && PackedUpConfig.keepBackpacksOnDeath.get().booleanValue() && !e.isCanceled() && !(stacksToBeSaved = e.getDrops().stream().filter(itemEntity -> itemEntity.isAlive() && !itemEntity.getItem().isEmpty() && itemEntity.getItem().getItem() instanceof BackpackItem).collect(Collectors.toList())).isEmpty()) {
            stacksToBeSaved.forEach(e.getDrops()::remove);
            ListTag itemData = new ListTag();
            stacksToBeSaved.stream().map(ItemEntity::getItem).forEach(stack -> itemData.add((Object)stack.save((HolderLookup.Provider)e.getEntity().registryAccess())));
            e.getEntity().getPersistentData().put("packedup:backpacks", (Tag)itemData);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone e) {
        if (e.getOriginal().getPersistentData().contains("packedup:backpacks", 9)) {
            ListTag itemData = e.getOriginal().getPersistentData().getList("packedup:backpacks", 10);
            itemData.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(tag -> ItemStack.parseOptional((HolderLookup.Provider)e.getEntity().registryAccess(), (CompoundTag)tag)).forEach(stack -> e.getEntity().getInventory().placeItemBackInInventory(stack));
        }
    }

    private static void updateOldBackpack(ItemStack stack) {
        CustomData data;
        if (stack.has(DataComponents.CUSTOM_DATA) && (data = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null && data.getUnsafe().contains("packedup:invIndex", 3)) {
            stack.set(BackpackItem.INVENTORY_ID, (Object)data.copyTag().getInt("packedup:invIndex"));
            if (data.getUnsafe().size() <= 1) {
                stack.remove(DataComponents.CUSTOM_DATA);
            } else {
                stack.set(DataComponents.CUSTOM_DATA, (Object)data.update(t -> t.remove("packedup:invIndex")));
            }
        }
    }
}

