/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.screen;

import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.PackedUpCommon;
import com.supermartijn642.packedup.screen.BackpackSlot;
import com.supermartijn642.packedup.storage.BackpackInventory;
import com.supermartijn642.packedup.storage.BackpackStorageManager;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackContainer
extends BaseContainer {
    public final BackpackType type;
    public final int bagSlot;
    public final Component bagName;
    public final BackpackInventory inventory;

    public BackpackContainer(Player player, int bagSlot, Component bagName, int inventoryIndex, BackpackType type, Set<Integer> bagsInThisBag, Set<Integer> bagsThisBagIsIn, int layer) {
        super(PackedUp.container, player);
        this.bagSlot = bagSlot;
        this.bagName = bagName;
        this.type = type;
        this.inventory = player.level().isClientSide ? new BackpackInventory(true, inventoryIndex, type.getSlots(), bagsInThisBag, bagsThisBagIsIn, layer) : BackpackStorageManager.getInventory(inventoryIndex);
        this.addSlots();
    }

    protected void addSlots(Player player) {
        int startX = Math.max(0, 9 - this.type.getColumns()) * 18 / 2 + 8;
        int startY = 17;
        for (int row = 0; row < this.type.getRows(); ++row) {
            for (int column = 0; column < this.type.getColumns(); ++column) {
                int x = startX + 18 * column;
                int y = startY + 18 * row;
                int index = row * this.type.getColumns() + column;
                this.addSlot(new BackpackSlot(this.inventory, index, x, y));
            }
        }
        startX = Math.max(0, this.type.getColumns() - 9) * 18 / 2 + 8;
        this.addPlayerSlots(startX, startY += this.type.getRows() * 18 + 13);
    }

    protected void addPlayerSlots(int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                if (this.bagSlot == row * 9 + column + 9) {
                    this.addSlot(new Slot(this, (Container)this.player.getInventory(), row * 9 + column + 9, x + 18 * column, y + 18 * row){

                        public boolean mayPickup(Player player) {
                            return false;
                        }
                    });
                    continue;
                }
                this.addSlot(new Slot((Container)this.player.getInventory(), row * 9 + column + 9, x + 18 * column, y + 18 * row));
            }
        }
        for (int column = 0; column < 9; ++column) {
            if (this.bagSlot == column) {
                this.addSlot(new Slot(this, (Container)this.player.getInventory(), column, x + 18 * column, y + 58){

                    public boolean mayPickup(Player player) {
                        return false;
                    }
                });
                continue;
            }
            this.addSlot(new Slot((Container)this.player.getInventory(), column, x + 18 * column, y + 58));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack returnStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            returnStack = slotStack.copy();
            if (index < this.type.getSlots() ? !this.moveItemStackTo(slotStack, this.type.getSlots(), this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.type.getSlots(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return returnStack;
    }

    public void clicked(int index, int dragType, ClickType clickType, Player player) {
        ItemStack stack;
        if (clickType == ClickType.SWAP && dragType == this.bagSlot) {
            return;
        }
        if (clickType == ClickType.PICKUP && dragType == 1 && index >= 0 && (stack = this.getSlot(index).getItem()).getItem() instanceof BackpackItem) {
            int playerSlot = index - this.type.getSlots();
            if (playerSlot >= 0) {
                playerSlot += playerSlot < 27 ? 9 : -27;
            }
            if (!player.level().isClientSide) {
                PackedUpCommon.openBackpackInventory(stack, player, playerSlot < 0 ? this.bagSlot : playerSlot);
            }
            return;
        }
        super.clicked(index, dragType, clickType, player);
    }
}

