/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private bdr entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gp> setLitChunkPos = new HashSet();
    private gp.a blockPosMutable = new gp.a();

    public DynamicLight(bdr entity) {
        this.entity = entity;
        this.offsetY = entity.cF();
    }

    public void update(fdt renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dk() - 0.5;
        double posY = this.entity.dm() - 0.5 + this.offsetY;
        double posZ = this.entity.dq() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((bdr)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            gv dirX = (aoc.b((double)posX) & 0xF) >= 8 ? gv.f : gv.e;
            gv dirY = (aoc.b((double)posY) & 0xF) >= 8 ? gv.b : gv.a;
            gv dirZ = (aoc.b((double)posZ) & 0xF) >= 8 ? gv.d : gv.c;
            gp chunkPos = new gp(posX, posY, posZ);
            fgl.c chunk = renderGlobal.getRenderChunk(chunkPos);
            gp chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            fgl.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gp chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            fgl.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gp chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            fgl.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gp chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            fgl.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gp chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            fgl.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gp chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            fgl.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gp chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            fgl.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gp getChunkPos(fgl.c renderChunk, gp pos, gv facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(fgl.c renderChunk, Set<gp> setPrevPos, Set<gp> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        fgl.b compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        gp pos = renderChunk.f().i();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(fdt renderGlobal) {
        for (gp posOld : this.setLitChunkPos) {
            fgl.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public bdr getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

