/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.ArrayUtils;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEntities {
    private static Map<String, RandomEntityProperties<acf>> mapProperties = new HashMap();
    private static Map<String, RandomEntityProperties<acf>> mapSpriteProperties = new HashMap();
    private static boolean active = false;
    private static fio entityRenderDispatcher;
    private static RandomEntity randomEntity;
    private static ffr tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String SEPARATOR_DIGITS = ".";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE = "optifine/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(bdr entity, cjw world) {
        if (world == null) {
            return;
        }
        abq edm = entity.al();
        edm.spawnPosition = entity.df();
        edm.spawnBiome = (ckt)world.w(edm.spawnPosition).a();
        if (entity instanceof bql) {
            bql esr = (bql)entity;
            RandomEntities.checkEntityShoulder((bql)esr, (boolean)false);
        }
    }

    public static void entityUnloaded(bdr entity, cjw world) {
        if (entity instanceof bql) {
            bql esr = (bql)entity;
            RandomEntities.checkEntityShoulder((bql)esr, (boolean)true);
        }
    }

    public static void checkEntityShoulder(bql entity, boolean attach) {
        beg owner = entity.fN();
        if (owner == null) {
            owner = Config.getMinecraft().t;
        }
        if (!(owner instanceof fcw)) {
            return;
        }
        fcw player = (fcw)owner;
        UUID entityUuid = entity.cs();
        if (attach) {
            qp nbtRight;
            player.lastAttachedEntity = entity;
            qp nbtLeft = player.fV();
            if (nbtLeft != null && nbtLeft.e("UUID") && Config.equals((Object)nbtLeft.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderLeft = entity;
                player.lastAttachedEntity = null;
            }
            if ((nbtRight = player.fW()) != null && nbtRight.e("UUID") && Config.equals((Object)nbtRight.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderRight = entity;
                player.lastAttachedEntity = null;
            }
        } else {
            abq edm = entity.al();
            if (player.entityShoulderLeft != null && Config.equals((Object)player.entityShoulderLeft.cs(), (Object)entityUuid)) {
                abq edmShoulderLeft = player.entityShoulderLeft.al();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals((Object)player.entityShoulderRight.cs(), (Object)entityUuid)) {
                abq edmShoulderRight = player.entityShoulderRight.al();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(cjw oldWorld, cjw newWorld) {
        if (newWorld instanceof eyz) {
            eyz newWorldClient = (eyz)newWorld;
            Iterable entities = newWorldClient.e();
            for (bdr entity : entities) {
                RandomEntities.entityLoaded((bdr)entity, (cjw)newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static acf getTextureLocation(acf loc) {
        if (!active) {
            return loc;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            String name = loc.a();
            if (name.startsWith("horse/")) {
                name = RandomEntities.getHorseTexturePath((String)name, (int)"horse/".length());
            }
            if (!name.startsWith("textures/entity/") && !name.startsWith("textures/painting/")) {
                acf acf2 = loc;
                return acf2;
            }
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(name);
            if (props == null) {
                acf acf3 = loc;
                return acf3;
            }
            acf acf4 = (acf)props.getResource(re, (Object)loc);
            return acf4;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i2 = 0; i2 < HORSE_TEXTURES_ABBR.length; ++i2) {
            String abbr = HORSE_TEXTURES_ABBR[i2];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i2];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (entityRenderDispatcher.getRenderedEntity() != null) {
            randomEntity.setEntity(entityRenderDispatcher.getRenderedEntity());
            return randomEntity;
        }
        if (ffr.tileEntityRendered != null) {
            cwl te = ffr.tileEntityRendered;
            if (te.k() != null) {
                randomTileEntity.setTileEntity(te);
                return randomTileEntity;
            }
        }
        return null;
    }

    public static IRandomEntity getRandomEntity(bdr entityIn) {
        randomEntity.setEntity(entityIn);
        return randomEntity;
    }

    public static IRandomEntity getRandomBlockEntity(cwl tileEntityIn) {
        randomTileEntity.setTileEntity(tileEntityIn);
        return randomTileEntity;
    }

    private static RandomEntityProperties<acf> makeProperties(acf loc, RandomEntityContext.Textures context) {
        RandomEntityProperties props;
        String path = loc.a();
        acf locProps = RandomEntities.getLocationProperties((acf)loc, (boolean)context.isLegacy());
        if (locProps != null && (props = RandomEntityProperties.parse((acf)locProps, (acf)loc, (RandomEntityContext)context)) != null) {
            return props;
        }
        int[] variants = RandomEntities.getLocationsVariants((acf)loc, (boolean)context.isLegacy(), (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, loc, variants, (RandomEntityContext)context);
    }

    private static acf getLocationProperties(acf loc, boolean legacy) {
        String path;
        String pathBase;
        String pathProps;
        acf locMcp = RandomEntities.getLocationRandom((acf)loc, (boolean)legacy);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        acf locProps = new acf(domain, pathProps = (pathBase = StrUtils.removeSuffix((String)(path = locMcp.a()), (String)".png")) + ".properties");
        if (Config.hasResource((acf)locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath((String)pathBase);
        if (pathParent == null) {
            return null;
        }
        acf locParentProps = new acf(domain, pathParent + ".properties");
        if (Config.hasResource((acf)locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static acf getLocationRandom(acf loc, boolean legacy) {
        String domain = loc.b();
        String path = loc.a();
        if (path.startsWith("optifine/")) {
            return loc;
        }
        String prefixTextures = "textures/";
        String prefixRandom = "optifine/random/";
        if (legacy) {
            prefixTextures = "textures/entity/";
            prefixRandom = "optifine/mob/";
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix((String)path, (String)prefixTextures, (String)prefixRandom);
        return new acf(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith("optifine/random/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/random/", (String)"textures/");
        }
        if (pathRandom.startsWith("optifine/mob/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/mob/", (String)"textures/entity/");
        }
        return null;
    }

    protected static acf getLocationIndexed(acf loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String separator = StrUtils.endsWithDigit((String)prefix) ? "." : "";
        String pathNew = prefix + separator + index + suffix;
        acf locNew = new acf(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i2 = 0; i2 < DEPENDANT_SUFFIXES.length; ++i2) {
            String suffix = DEPENDANT_SUFFIXES[i2];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix((String)path, (String)suffix);
            return pathParent;
        }
        return null;
    }

    public static int[] getLocationsVariants(acf loc, boolean legacy, RandomEntityContext context) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        acf locRandom = RandomEntities.getLocationRandom((acf)loc, (boolean)legacy);
        if (locRandom == null) {
            return null;
        }
        for (int i2 = 1; i2 < list.size() + 10; ++i2) {
            int index = i2 + 1;
            acf locIndex = RandomEntities.getLocationIndexed((acf)locRandom, (int)index);
            if (!Config.hasResource((acf)locIndex)) continue;
            list.add(index);
        }
        if (list.size() <= 1) {
            return null;
        }
        Integer[] arr = list.toArray(new Integer[list.size()]);
        int[] intArr = ArrayUtils.toPrimitive((Integer[])arr);
        Config.dbg((String)(context.getName() + ": " + loc.a() + ", variants: " + intArr.length));
        return intArr;
    }

    public static void update() {
        entityRenderDispatcher = Config.getEntityRenderDispatcher();
        tileEntityRendererDispatcher = ejf.N().ao();
        mapProperties.clear();
        mapSpriteProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        String[] prefixes = new String[]{"optifine/random/", "optifine/mob/"};
        String[] suffixes = new String[]{".png", ".properties"};
        String[] pathsRandom = ResUtils.collectFiles((String[])prefixes, (String[])suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i2 = 0; i2 < pathsRandom.length; ++i2) {
            RandomEntityProperties props;
            Object path = pathsRandom[i2];
            path = StrUtils.removeSuffix((String)path, (String[])suffixes);
            path = StrUtils.trimTrailing((String)path, (String)"0123456789");
            path = StrUtils.removeSuffix((String)path, (String)".");
            String pathBase = RandomEntities.getPathBase((String)(path = (String)path + ".png"));
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            acf locBase = new acf(pathBase);
            if (!Config.hasResource((acf)locBase) || (props = (RandomEntityProperties)mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties((acf)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(false));
            if (props == null) {
                props = RandomEntities.makeProperties((acf)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(true));
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static synchronized void registerSprites(Set<acf> spriteLocations) {
        if (mapProperties.isEmpty()) {
            return;
        }
        HashSet<acf> newLocations = new HashSet<acf>();
        for (acf loc : spriteLocations) {
            List locs;
            String pathFull = "textures/" + loc.a() + ".png";
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(pathFull);
            if (props == null || (locs = props.getAllResources()) == null) continue;
            for (int i2 = 0; i2 < locs.size(); ++i2) {
                acf propLoc = (acf)locs.get(i2);
                acf locSprite = TextureUtils.getSpriteLocation((acf)propLoc);
                newLocations.add(locSprite);
                mapSpriteProperties.put(locSprite.a(), props);
            }
        }
        spriteLocations.addAll(newLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static fol getRandomSprite(fol spriteIn) {
        if (!active) {
            return spriteIn;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return spriteIn;
        }
        if (working) {
            return spriteIn;
        }
        try {
            fol sprite;
            working = true;
            acf locSpriteIn = spriteIn.getName();
            String name = locSpriteIn.a();
            RandomEntityProperties props = (RandomEntityProperties)mapSpriteProperties.get(name);
            if (props == null) {
                fol fol2 = spriteIn;
                return fol2;
            }
            acf loc = (acf)props.getResource(re, (Object)locSpriteIn);
            if (loc == locSpriteIn) {
                fol fol3 = spriteIn;
                return fol3;
            }
            acf locSprite = TextureUtils.getSpriteLocation((acf)loc);
            fol fol4 = sprite = spriteIn.getTextureAtlas().a(locSprite);
            return fol4;
        }
        finally {
            working = false;
        }
    }

    public static void dbg(String str) {
        Config.dbg((String)("RandomEntities: " + str));
    }

    public static void warn(String str) {
        Config.warn((String)("RandomEntities: " + str));
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, brp.class, String[].class, (int)0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, brp.class, String[].class, (int)1);
    }
}

