/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.Log;
import net.optifine.RandomEntities;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.RendererCache;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<bdv, RandomEntityProperties<IEntityRenderer>> mapEntityProperties = new HashMap();
    private static Map<cwn, RandomEntityProperties<IEntityRenderer>> mapBlockEntityProperties = new HashMap();
    private static int matchingRuleIndex;
    private static Map<bdv, fip> originalEntityRenderMap;
    private static Map<cwn, ffs> originalTileEntityRenderMap;
    private static Map<ctp.a, exg> originalSkullModelMap;
    private static List<cwn> customTileEntityTypes;
    private static eut customBookModel;
    private static boolean debugModels;
    public static final String PREFIX_OPTIFINE_CEM = "optifine/cem/";
    public static final String SUFFIX_JEM = ".jem";
    public static final String SUFFIX_PROPERTIES = ".properties";

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        fdh blockEntityRenderer = ejf.N().ap().getBlockEntityRenderer();
        blockEntityRenderer.j = new exn(ModelAdapter.bakeModelLayer((eyf)eyg.bz));
        fmu.customParrotModel = null;
        customBookModel = null;
        ffs.CACHED_TYPES.clear();
        if (ejf.N().s != null) {
            Iterable entities = ejf.N().s.e();
            for (bdr entity : entities) {
                Map modelVariables = entity.al().modelVariables;
                if (modelVariables == null) continue;
                modelVariables.clear();
            }
        }
        mapEntityProperties.clear();
        mapBlockEntityProperties.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        RandomEntityContext.Models context = new RandomEntityContext.Models();
        RendererCache rendererCache = context.getRendererCache();
        acf[] locs = CustomEntityModels.getModelLocations();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            acf loc = locs[i2];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc = CustomEntityModels.parseEntityRender((acf)loc, (RendererCache)rendererCache, (int)0);
            if (rc == null) continue;
            Either type = rc.getType();
            if (rc instanceof fip) {
                fkc pr;
                ewj pm;
                flb tr;
                exn tm;
                entityRenderMap.put((bdv)type.getLeft().get(), (fip)rc);
                rendererCache.put((bdv)type.getLeft().get(), 0, (fip)rc);
                if (rc instanceof flb && (tm = (exn)Reflector.getFieldValue((Object)(tr = (flb)rc), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.j = tm;
                }
                if (rc instanceof fkc && (pm = (ewj)(pr = (fkc)rc).a()) != null) {
                    fmu.customParrotModel = pm;
                }
            } else if (rc instanceof ffs) {
                tileEntityRenderMap.put((cwn)type.getRight().get(), (ffs)rc);
                rendererCache.put((cwn)type.getRight().get(), 0, (ffs)rc);
                if (rc instanceof ffz) {
                    ffz etr = (ffz)rc;
                    eut bm = (eut)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((eut)bm);
                }
                customTileEntityTypes.add((cwn)type.getRight().get());
            } else {
                Config.warn((String)("Unknown renderer type: " + rc.getClass().getName()));
            }
            active = true;
        }
        CustomEntityModels.updateRandomProperties((RandomEntityContext.Models)context);
    }

    private static void updateRandomProperties(RandomEntityContext.Models context) {
        String[] prefixes = new String[]{"optifine/cem/"};
        String[] suffixes = new String[]{".jem", ".properties"};
        String[] names = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
            Either type = modelAdapter.getType();
            RandomEntityProperties props = CustomEntityModels.makeProperties((String)name, (RandomEntityContext.Models)context);
            if (props == null) {
                props = CustomEntityModels.makeProperties((String)(name + "/" + name), (RandomEntityContext.Models)context);
            }
            if (props == null) continue;
            if (type.getLeft().isPresent()) {
                mapEntityProperties.put((bdv)type.getLeft().get(), props);
                continue;
            }
            mapBlockEntityProperties.put((cwn)type.getRight().get(), props);
        }
    }

    private static RandomEntityProperties makeProperties(String name, RandomEntityContext.Models context) {
        RandomEntityProperties props;
        acf locJem = new acf("optifine/cem/" + name + ".jem");
        acf locProps = new acf("optifine/cem/" + name + ".properties");
        if (Config.hasResource((acf)locProps) && (props = RandomEntityProperties.parse((acf)locProps, (acf)locJem, (RandomEntityContext)context)) != null) {
            return props;
        }
        if (!Config.hasResource((acf)locJem)) {
            return null;
        }
        int[] variants = RandomEntities.getLocationsVariants((acf)locJem, (boolean)false, (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        RandomEntityProperties props2 = new RandomEntityProperties(locJem.a(), locJem, variants, (RandomEntityContext)context);
        if (!props2.isValid(locJem.a())) {
            return null;
        }
        return props2;
    }

    private static void setEnchantmentScreenBookModel(eut bookModel) {
        customBookModel = bookModel;
    }

    private static Map<bdv, fip> getEntityRenderMap() {
        fio rm = ejf.N().an();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<cwn, ffs> getTileEntityRenderMap() {
        ffr blockEntityRenderDispatcher = ejf.N().ao();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<ctp.a, exg> getSkullModelMap() {
        HashMap skullModelMap = fgf.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static acf[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<acf> resourceLocations = new ArrayList<acf>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            String path = prefix + name + suffix;
            acf loc = new acf(path);
            if (!Config.hasResource((acf)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        acf[] locs = resourceLocations.toArray(new acf[resourceLocations.size()]);
        return locs;
    }

    public static IEntityRenderer parseEntityRender(acf location, RendererCache rendererCache, int index) {
        try {
            if (debugModels && index == 0) {
                return CustomEntityModels.makeDebugEntityRenderer((acf)location, (RendererCache)rendererCache, (int)index);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((acf)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo, (String)location.a(), (RendererCache)rendererCache, (int)index);
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + location), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(acf loc, RendererCache rendererCache, int index) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        ewf model = ma.makeModel();
        ccl[] colors = ccl.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i2 = 0; i2 < partNames.length; ++i2) {
            String partName = partNames[i2];
            eyh part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            ccl col = colors[(i2 + offset) % colors.length];
            acf locTexture = new acf("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize(), rendererCache, index);
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path, RendererCache rendererCache, int index) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer.getName();
        name = StrUtils.trimTrailing((String)name, (String)"0123456789");
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        CustomEntityModels.checkNull((Object)type, (String)("Entity type not found: " + name));
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer, (RendererCache)rendererCache, (int)index);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer, RendererCache rendererCache, int index) {
        ewf model;
        acf textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (ewf)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize, rendererCache, index);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (ewf)model, (IEntityRenderer)r, (acf)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, ewf model, IEntityRenderer er, acf textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof fjr) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (ewf)model, (acf)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, ewf model, acf textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            eyh modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, ewf model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr = modelRenderers[i2];
            if (CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (ewf)model, (CustomModelRenderer)cmr, (ModelResolver)mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, ewf model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        eyh parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + model));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                eyh[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    eyh mr = (eyh)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(cyt blockStateIn) {
        for (int i2 = 0; i2 < customTileEntityTypes.size(); ++i2) {
            cwn type = (cwn)customTileEntityTypes.get(i2);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(epb screen) {
        if (customBookModel != null && screen instanceof eqr) {
            eqr es = (eqr)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    public static fip getEntityRenderer(bdr entityIn, fip renderer) {
        if (mapEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomEntity((bdr)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapEntityProperties.get(entityIn.ag());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof fip)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        fip er = (fip)ier;
        return er;
    }

    public static ffs getBlockEntityRenderer(cwl entityIn, ffs renderer) {
        if (mapBlockEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomBlockEntity((cwl)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapBlockEntityProperties.get(entityIn.v());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof ffs)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        ffs ber = (ffs)ier;
        return ber;
    }

    public static int getMatchingRuleIndex() {
        return matchingRuleIndex;
    }

    static {
        originalEntityRenderMap = null;
        originalTileEntityRenderMap = null;
        originalSkullModelMap = null;
        customTileEntityTypes = new ArrayList();
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

