/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.RendererCache;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<bdv, cwn> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(bdv entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(bdv entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cwn tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(cwn tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<bdv, cwn> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<bdv, cwn> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract ewf makeModel();

    public abstract eyh getModelRenderer(ewf var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(ewf var1, float var2, RendererCache var3, int var4);

    public boolean setTextureLocation(IEntityRenderer er, acf textureLocation) {
        return false;
    }

    public eyh[] getModelRenderers(ewf model) {
        String[] names = this.getModelRendererNames();
        ArrayList<eyh> list = new ArrayList<eyh>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            eyh mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        eyh[] mrs = list.toArray(new eyh[list.size()]);
        return mrs;
    }

    public static eyh bakeModelLayer(eyf loc) {
        return ejf.N().an().getContext().a(loc);
    }
}

