/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.TooltipProviderOptions;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.util.StrUtils;

public class TooltipProviderShaderOptions
extends TooltipProviderOptions {
    public String[] getTooltipLines(ekw btn2, int width) {
        if (!(btn2 instanceof GuiButtonShaderOption)) {
            return null;
        }
        GuiButtonShaderOption btnSo = (GuiButtonShaderOption)btn2;
        ShaderOption so = btnSo.getShaderOption();
        String[] lines = this.makeTooltipLines(so, width);
        return lines;
    }

    private String[] makeTooltipLines(ShaderOption so, int width) {
        String name = so.getNameText();
        String desc = Config.normalize((String)so.getDescriptionText()).trim();
        String[] descs = this.splitDescription(desc);
        ejj settings = Config.getGameSettings();
        String id = null;
        if (!name.equals(so.getName()) && settings.m) {
            id = "\u00a78" + Lang.get((String)"of.general.id") + ": " + so.getName();
        }
        String source = null;
        if (so.getPaths() != null && settings.m) {
            source = "\u00a78" + Lang.get((String)"of.general.from") + ": " + Config.arrayToString((Object[])so.getPaths());
        }
        String def = null;
        if (so.getValueDefault() != null && settings.m) {
            String defVal = so.isEnabled() ? so.getValueText(so.getValueDefault()) : Lang.get((String)"of.general.ambiguous");
            def = "\u00a78" + Lang.getDefault() + ": " + defVal;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(name);
        list.addAll(Arrays.asList(descs));
        if (id != null) {
            list.add(id);
        }
        if (source != null) {
            list.add(source);
        }
        if (def != null) {
            list.add(def);
        }
        String[] lines = this.makeTooltipLines(width, list);
        return lines;
    }

    private String[] splitDescription(String desc) {
        if (desc.length() <= 0) {
            return new String[0];
        }
        desc = StrUtils.removePrefix((String)desc, (String)"//");
        String[] descs = desc.split("\\. ");
        for (int i2 = 0; i2 < descs.length; ++i2) {
            descs[i2] = "- " + descs[i2].trim();
            descs[i2] = StrUtils.removeSuffix((String)descs[i2], (String)".");
        }
        return descs;
    }

    private String[] makeTooltipLines(int width, List<String> args) {
        ekm fr = Config.getMinecraft().h;
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String arg = args.get(i2);
            if (arg == null || arg.length() <= 0) continue;
            tf argComp = ss.b((String)arg);
            List parts = fr.b().b((sw)argComp, width, to.a);
            for (sw part : parts) {
                list.add(part.getString());
            }
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }
}

