/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import optifine.OptiFineJar;
import optifine.OptiFineResourceLocator;
import optifine.OptiFineTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptiFineTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static URL ofZipFileUrl;
    private static ZipFile ofZipFile;
    private static Path ofZipFilePath;
    private static OptiFineTransformer transformer;

    public String name() {
        return "OptiFine";
    }

    public void initialize(IEnvironment environment) {
        LOGGER.info("OptiFineTransformationService.initialize");
    }

    public List<ITransformationService.Resource> beginScanning(IEnvironment environment) {
        return List.of();
    }

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        ArrayList<ITransformationService.Resource> list = new ArrayList<ITransformationService.Resource>();
        ArrayList<OptiFineJar> jarList = new ArrayList<OptiFineJar>();
        jarList.add(new OptiFineJar(ofZipFilePath));
        list.add(new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, jarList));
        return list;
    }

    public void onLoad(IEnvironment env2, Set<String> otherServices) throws IncompatibleEnvironmentException {
        LOGGER.info("OptiFineTransformationService.onLoad");
        ofZipFileUrl = OptiFineTransformer.class.getProtectionDomain().getCodeSource().getLocation();
        LOGGER.info("OptiFine ZIP file URL: " + ofZipFileUrl);
        try {
            URI uri = ofZipFileUrl.toURI();
            File file = OptiFineTransformationService.toFile(uri);
            ofZipFile = new ZipFile(file);
            LOGGER.info("OptiFine ZIP file: " + file);
            ofZipFilePath = file.toPath();
            transformer = new OptiFineTransformer(ofZipFile, env2);
            OptiFineResourceLocator.setResourceLocator(transformer);
        }
        catch (Exception e2) {
            LOGGER.error("Error loading OptiFine ZIP file: " + ofZipFileUrl, (Throwable)e2);
            throw new IncompatibleEnvironmentException("Error loading OptiFine ZIP file: " + ofZipFileUrl);
        }
    }

    public static File toFile(URI uri) {
        if (!"union".equals(uri.getScheme())) {
            return new File(uri);
        }
        try {
            String path = uri.getPath();
            if (path.contains("#")) {
                path = path.substring(0, path.lastIndexOf("#"));
            }
            File file = new File(path);
            ofZipFileUrl = file.toURI().toURL();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("create", "true");
            FileSystems.newFileSystem(URI.create("jar:" + ofZipFileUrl + "!/"), map);
            return file;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalResourcesLocator() {
        return super.additionalResourcesLocator();
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalClassesLocator() {
        HashSet<String> key = new HashSet<String>();
        key.add("net.optifine.");
        key.add("optifine.");
        Supplier<Function> value = () -> OptiFineTransformationService::getResourceUrl;
        AbstractMap.SimpleEntry<Set<String>, Supplier<Function<String, Optional<URL>>>> entry = new AbstractMap.SimpleEntry<Set<String>, Supplier<Function<String, Optional<URL>>>>(key, value);
        LOGGER.info("additionalClassesLocator: " + key);
        return entry;
    }

    public static Optional<URL> getResourceUrl(String name) {
        if (name.endsWith(".class") && !name.startsWith("optifine/")) {
            name = "srg/" + name;
        }
        if (transformer == null) {
            return Optional.empty();
        }
        ZipEntry ze = ofZipFile.getEntry(name);
        if (ze == null) {
            return Optional.empty();
        }
        try {
            String ofZipUrlStr = ofZipFileUrl.toExternalForm();
            URL urlJar = new URL("jar:" + ofZipUrlStr + "!/" + name);
            return Optional.of(urlJar);
        }
        catch (IOException e2) {
            LOGGER.error((Object)e2);
            return Optional.empty();
        }
    }

    public List<ITransformer> transformers() {
        LOGGER.info("OptiFineTransformationService.transformers");
        ArrayList<ITransformer> list = new ArrayList<ITransformer>();
        if (transformer != null) {
            list.add(transformer);
        }
        return list;
    }

    public static OptiFineTransformer getTransformer() {
        return transformer;
    }

    public static ZipFile getOfZipFile() {
        return ofZipFile;
    }
}

