/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.optifine.Config;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.Shaders;
import net.optifine.util.TextureUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShadersTex {
    public static final int initialBufferSize = 0x100000;
    public static ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)0x400000);
    public static IntBuffer intBuffer = byteBuffer.asIntBuffer();
    public static int[] intArray = new int[0x100000];
    public static final int defBaseTexColor = 0;
    public static final int defNormTexColor = -8421377;
    public static final int defSpecTexColor = 0;
    public static Map<Integer, MultiTexID> multiTexMap = new HashMap();

    public static IntBuffer getIntBuffer(int size) {
        if (intBuffer.capacity() < size) {
            int bufferSize = ShadersTex.roundUpPOT((int)size);
            byteBuffer = BufferUtils.createByteBuffer((int)(bufferSize * 4));
            intBuffer = byteBuffer.asIntBuffer();
        }
        return intBuffer;
    }

    public static int[] getIntArray(int size) {
        if (intArray == null) {
            intArray = new int[0x100000];
        }
        if (intArray.length < size) {
            intArray = new int[ShadersTex.roundUpPOT((int)size)];
        }
        return intArray;
    }

    public static int roundUpPOT(int x) {
        int i = x - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public static int log2(int x) {
        int log = 0;
        if ((x & 0xFFFF0000) != 0) {
            log += 16;
            x >>= 16;
        }
        if ((x & 0xFF00) != 0) {
            log += 8;
            x >>= 8;
        }
        if ((x & 0xF0) != 0) {
            log += 4;
            x >>= 4;
        }
        if ((x & 6) != 0) {
            log += 2;
            x >>= 2;
        }
        if ((x & 2) != 0) {
            ++log;
        }
        return log;
    }

    public static IntBuffer fillIntBuffer(int size, int value) {
        int[] aint = ShadersTex.getIntArray((int)size);
        IntBuffer intBuf = ShadersTex.getIntBuffer((int)size);
        Arrays.fill(intArray, 0, size, value);
        intBuffer.put(intArray, 0, size);
        return intBuffer;
    }

    public static int[] createAIntImage(int size) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, 0);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static int[] createAIntImage(int size, int color) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, color);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static MultiTexID getMultiTexID(gpw tex) {
        MultiTexID multiTex = tex.multiTex;
        if (multiTex == null) {
            int baseTex = tex.a();
            multiTex = (MultiTexID)multiTexMap.get(baseTex);
            if (multiTex == null) {
                multiTex = new MultiTexID(baseTex, GL11.glGenTextures(), GL11.glGenTextures());
                multiTexMap.put(baseTex, multiTex);
            }
            tex.multiTex = multiTex;
        }
        return multiTex;
    }

    public static void deleteTextures(gpw atex, int texid) {
        MultiTexID multiTex = atex.multiTex;
        if (multiTex != null) {
            atex.multiTex = null;
            multiTexMap.remove(multiTex.base);
            GlStateManager._deleteTexture((int)multiTex.norm);
            GlStateManager._deleteTexture((int)multiTex.spec);
            if (multiTex.base != texid) {
                SMCLog.warning((String)("Error : MultiTexID.base mismatch: " + multiTex.base + ", texid: " + texid));
                GlStateManager._deleteTexture((int)multiTex.base);
            }
        }
    }

    public static void bindNSTextures(int normTex, int specTex, boolean normalBlend, boolean specularBlend, boolean mipmaps) {
        if (Shaders.isRenderingWorld && GlStateManager.getActiveTextureUnit() == 33984) {
            int minFilter;
            if (Shaders.configNormalMap) {
                GlStateManager._activeTexture((int)33985);
                GlStateManager._bindTexture((int)normTex);
                if (!normalBlend) {
                    minFilter = mipmaps ? 9984 : 9728;
                    GlStateManager._texParameter((int)3553, (int)10241, (int)minFilter);
                    GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                }
            }
            if (Shaders.configSpecularMap) {
                GlStateManager._activeTexture((int)33987);
                GlStateManager._bindTexture((int)specTex);
                if (!specularBlend) {
                    minFilter = mipmaps ? 9984 : 9728;
                    GlStateManager._texParameter((int)3553, (int)10241, (int)minFilter);
                    GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                }
            }
            GlStateManager._activeTexture((int)33984);
        }
    }

    public static void bindNSTextures(MultiTexID multiTex) {
        ShadersTex.bindNSTextures((int)multiTex.norm, (int)multiTex.spec, (boolean)true, (boolean)true, (boolean)false);
    }

    public static void bindTextures(int baseTex, int normTex, int specTex) {
        if (Shaders.isRenderingWorld && GlStateManager.getActiveTextureUnit() == 33984) {
            GlStateManager._activeTexture((int)33985);
            GlStateManager._bindTexture((int)normTex);
            GlStateManager._activeTexture((int)33987);
            GlStateManager._bindTexture((int)specTex);
            GlStateManager._activeTexture((int)33984);
        }
        GlStateManager._bindTexture((int)baseTex);
    }

    public static void bindTextures(MultiTexID multiTex, boolean normalBlend, boolean specularBlend, boolean mipmaps) {
        if (Shaders.isRenderingWorld && GlStateManager.getActiveTextureUnit() == 33984) {
            int minFilter;
            if (Shaders.configNormalMap) {
                GlStateManager._activeTexture((int)33985);
                GlStateManager._bindTexture((int)multiTex.norm);
                if (!normalBlend) {
                    minFilter = mipmaps ? 9984 : 9728;
                    GlStateManager._texParameter((int)3553, (int)10241, (int)minFilter);
                    GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                }
            }
            if (Shaders.configSpecularMap) {
                GlStateManager._activeTexture((int)33987);
                GlStateManager._bindTexture((int)multiTex.spec);
                if (!specularBlend) {
                    minFilter = mipmaps ? 9984 : 9728;
                    GlStateManager._texParameter((int)3553, (int)10241, (int)minFilter);
                    GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                }
            }
            GlStateManager._activeTexture((int)33984);
        }
        GlStateManager._bindTexture((int)multiTex.base);
    }

    public static void bindTexture(int id) {
        gpw tex = Config.getTextureManager().getTextureById(id);
        if (tex == null) {
            GlStateManager._bindTexture((int)id);
            return;
        }
        ShadersTex.bindTexture((gpw)tex);
    }

    public static void bindTexture(gpw tex) {
        MultiTexID multiTex;
        int texId = tex.a();
        boolean normalBlend = true;
        boolean specularBlend = true;
        boolean mipmaps = false;
        if (tex instanceof gqk) {
            gqk at = (gqk)tex;
            normalBlend = at.isNormalBlend();
            specularBlend = at.isSpecularBlend();
            mipmaps = at.isMipmaps();
        }
        if ((multiTex = tex.getMultiTexID()) != null) {
            ShadersTex.bindTextures((MultiTexID)multiTex, (boolean)normalBlend, (boolean)specularBlend, (boolean)mipmaps);
        } else {
            GlStateManager._bindTexture((int)texId);
        }
        if (GlStateManager.getActiveTextureUnit() == 33984) {
            int prevSizeX = Shaders.atlasSizeX;
            int prevSizeY = Shaders.atlasSizeY;
            if (tex instanceof gqk) {
                Shaders.atlasSizeX = ((gqk)tex).atlasWidth;
                Shaders.atlasSizeY = ((gqk)tex).atlasHeight;
            } else {
                Shaders.atlasSizeX = 0;
                Shaders.atlasSizeY = 0;
            }
        }
    }

    public static void bindTextures(int baseTex) {
        MultiTexID multiTex = (MultiTexID)multiTexMap.get(baseTex);
        ShadersTex.bindTextures((MultiTexID)multiTex, (boolean)true, (boolean)true, (boolean)false);
    }

    public static void initDynamicTextureNS(gpy tex) {
        MultiTexID multiTex = tex.getMultiTexID();
        faj nativeImage = tex.e();
        int width = nativeImage.a();
        int height = nativeImage.b();
        faj imageNormal = ShadersTex.makeImageColor((int)width, (int)height, (int)-8421377);
        TextureUtil.prepareImage((int)multiTex.norm, (int)width, (int)height);
        imageNormal.a(0, 0, 0, 0, 0, width, height, false, false, false, true);
        faj imageSpecular = ShadersTex.makeImageColor((int)width, (int)height, (int)0);
        TextureUtil.prepareImage((int)multiTex.spec, (int)width, (int)height);
        imageSpecular.a(0, 0, 0, 0, 0, width, height, false, false, false, true);
        GlStateManager._bindTexture((int)multiTex.base);
    }

    public static void updateDynTexSubImage1(int[] src, int width, int height, int posX, int posY, int page) {
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer((int)size);
        intBuf.clear();
        int offset = page * size;
        if (src.length < offset + size) {
            return;
        }
        intBuf.put(src, offset, size).position(0).limit(size);
        TextureUtils.resetDataUnpacking();
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        intBuf.clear();
    }

    public static gpw createDefaultTexture() {
        gpy tex = new gpy(1, 1, true);
        tex.e().a(0, 0, -1);
        tex.d();
        return tex;
    }

    public static void allocateTextureMapNS(int mipmapLevels, int width, int height, gqk tex) {
        MultiTexID multiTex = ShadersTex.getMultiTexID((gpw)tex);
        if (Shaders.configNormalMap) {
            SMCLog.info((String)("Allocate texture map normal: " + width + "x" + height + ", mipmaps: " + mipmapLevels));
            TextureUtil.prepareImage((int)multiTex.norm, (int)mipmapLevels, (int)width, (int)height);
        }
        if (Shaders.configSpecularMap) {
            SMCLog.info((String)("Allocate texture map specular: " + width + "x" + height + ", mipmaps: " + mipmapLevels));
            TextureUtil.prepareImage((int)multiTex.spec, (int)mipmapLevels, (int)width, (int)height);
        }
        GlStateManager._bindTexture((int)multiTex.base);
    }

    private static faj[] generateMipmaps(faj image, int levels) {
        if (levels < 0) {
            levels = 0;
        }
        faj[] mipmapImages = new faj[levels + 1];
        mipmapImages[0] = image;
        if (levels > 0) {
            for (int level = 1; level <= levels; ++level) {
                faj imageParent = mipmapImages[level - 1];
                faj imageChild = new faj(imageParent.a() >> 1, imageParent.b() >> 1, false);
                int k2 = imageChild.a();
                int l2 = imageChild.b();
                for (int x = 0; x < k2; ++x) {
                    for (int y2 = 0; y2 < l2; ++y2) {
                        imageChild.a(x, y2, ShadersTex.blend4Simple((int)imageParent.a(x * 2 + 0, y2 * 2 + 0), (int)imageParent.a(x * 2 + 1, y2 * 2 + 0), (int)imageParent.a(x * 2 + 0, y2 * 2 + 1), (int)imageParent.a(x * 2 + 1, y2 * 2 + 1)));
                    }
                }
                mipmapImages[level] = imageChild;
            }
        }
        return mipmapImages;
    }

    public static BufferedImage readImage(akr resLoc) {
        try {
            if (!Config.hasResource((akr)resLoc)) {
                return null;
            }
            InputStream istr = Config.getResourceStream((akr)resLoc);
            if (istr == null) {
                return null;
            }
            BufferedImage image = ImageIO.read(istr);
            istr.close();
            return image;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static int[][] genMipmapsSimple(int maxLevel, int width, int[][] data) {
        for (int level = 1; level <= maxLevel; ++level) {
            if (data[level] != null) continue;
            int cw = width >> level;
            int pw = cw * 2;
            int[] aintp = data[level - 1];
            data[level] = new int[cw * cw];
            int[] aintc = data[level];
            for (int y2 = 0; y2 < cw; ++y2) {
                for (int x = 0; x < cw; ++x) {
                    int ppos = y2 * 2 * pw + x * 2;
                    aintc[y2 * cw + x] = ShadersTex.blend4Simple((int)aintp[ppos], (int)aintp[ppos + 1], (int)aintp[ppos + pw], (int)aintp[ppos + pw + 1]);
                }
            }
        }
        return data;
    }

    public static void uploadTexSub1(int[][] src, int width, int height, int posX, int posY, int page) {
        TextureUtils.resetDataUnpacking();
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer((int)size);
        int numLevel = src.length;
        int level = 0;
        int lw = width;
        int lh = height;
        int px = posX;
        int py = posY;
        while (lw > 0 && lh > 0 && level < numLevel) {
            int lsize = lw * lh;
            int[] aint = src[level];
            intBuf.clear();
            if (aint.length >= lsize * (page + 1)) {
                intBuf.put(aint, lsize * page, lsize).position(0).limit(lsize);
                GL11.glTexSubImage2D((int)3553, (int)level, (int)px, (int)py, (int)lw, (int)lh, (int)32993, (int)33639, (IntBuffer)intBuf);
            }
            lw >>= 1;
            lh >>= 1;
            px >>= 1;
            py >>= 1;
            ++level;
        }
        intBuf.clear();
    }

    public static int blend4Alpha(int c0, int c1, int c2, int c3) {
        int dv;
        int a0 = c0 >>> 24 & 0xFF;
        int a1 = c1 >>> 24 & 0xFF;
        int a2 = c2 >>> 24 & 0xFF;
        int a3 = c3 >>> 24 & 0xFF;
        int as = a0 + a1 + a2 + a3;
        int an = (as + 2) / 4;
        if (as != 0) {
            dv = as;
        } else {
            dv = 4;
            a0 = 1;
            a1 = 1;
            a2 = 1;
            a3 = 1;
        }
        int frac = (dv + 1) / 2;
        int color = an << 24 | ((c0 >>> 16 & 0xFF) * a0 + (c1 >>> 16 & 0xFF) * a1 + (c2 >>> 16 & 0xFF) * a2 + (c3 >>> 16 & 0xFF) * a3 + frac) / dv << 16 | ((c0 >>> 8 & 0xFF) * a0 + (c1 >>> 8 & 0xFF) * a1 + (c2 >>> 8 & 0xFF) * a2 + (c3 >>> 8 & 0xFF) * a3 + frac) / dv << 8 | ((c0 >>> 0 & 0xFF) * a0 + (c1 >>> 0 & 0xFF) * a1 + (c2 >>> 0 & 0xFF) * a2 + (c3 >>> 0 & 0xFF) * a3 + frac) / dv << 0;
        return color;
    }

    public static int blend4Simple(int c0, int c1, int c2, int c3) {
        int color = ((c0 >>> 24 & 0xFF) + (c1 >>> 24 & 0xFF) + (c2 >>> 24 & 0xFF) + (c3 >>> 24 & 0xFF) + 2) / 4 << 24 | ((c0 >>> 16 & 0xFF) + (c1 >>> 16 & 0xFF) + (c2 >>> 16 & 0xFF) + (c3 >>> 16 & 0xFF) + 2) / 4 << 16 | ((c0 >>> 8 & 0xFF) + (c1 >>> 8 & 0xFF) + (c2 >>> 8 & 0xFF) + (c3 >>> 8 & 0xFF) + 2) / 4 << 8 | ((c0 >>> 0 & 0xFF) + (c1 >>> 0 & 0xFF) + (c2 >>> 0 & 0xFF) + (c3 >>> 0 & 0xFF) + 2) / 4 << 0;
        return color;
    }

    public static void genMipmapAlpha(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y2 = 0; y2 < h1; ++y2) {
                int p1 = o1 + y2 * w1;
                int p2 = o2 + y2 * 2 * w2;
                for (int x = 0; x < w1; ++x) {
                    aint[p1 + x] = ShadersTex.blend4Alpha((int)aint[p2 + x * 2], (int)aint[p2 + (x * 2 + 1)], (int)aint[p2 + w2 + x * 2], (int)aint[p2 + w2 + (x * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y3 = 0; y3 < h2; ++y3) {
                for (int x = 0; x < w2; ++x) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y3 / 2 * w1 + x / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static void genMipmapSimple(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y2 = 0; y2 < h1; ++y2) {
                int p1 = o1 + y2 * w1;
                int p2 = o2 + y2 * 2 * w2;
                for (int x = 0; x < w1; ++x) {
                    aint[p1 + x] = ShadersTex.blend4Simple((int)aint[p2 + x * 2], (int)aint[p2 + (x * 2 + 1)], (int)aint[p2 + w2 + x * 2], (int)aint[p2 + w2 + (x * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y3 = 0; y3 < h2; ++y3) {
                for (int x = 0; x < w2; ++x) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y3 / 2 * w1 + x / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static boolean isSemiTransparent(int[] aint, int width, int height) {
        int size = width * height;
        if (aint[0] >>> 24 == 255 && aint[size - 1] == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            int alpha = aint[i] >>> 24;
            if (alpha == 0 || alpha == 255) continue;
            return true;
        }
        return false;
    }

    public static void updateSubTex1(int[] src, int width, int height, int posX, int posY) {
        int level = 0;
        int cw = width;
        int ch = height;
        int cx = posX;
        int cy = posY;
        while (cw > 0 && ch > 0) {
            GL11.glCopyTexSubImage2D((int)3553, (int)level, (int)cx, (int)cy, (int)0, (int)0, (int)cw, (int)ch);
            ++level;
            cw /= 2;
            ch /= 2;
            cx /= 2;
            cy /= 2;
        }
    }

    public static void updateSubImage(MultiTexID multiTex, int[] src, int width, int height, int posX, int posY, boolean linear, boolean clamp) {
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer((int)size);
        TextureUtils.resetDataUnpacking();
        intBuf.clear();
        intBuf.put(src, 0, size);
        intBuf.position(0).limit(size);
        GlStateManager._bindTexture((int)multiTex.base);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        if (src.length == size * 3) {
            intBuf.clear();
            intBuf.put(src, size, size).position(0);
            intBuf.position(0).limit(size);
        }
        GlStateManager._bindTexture((int)multiTex.norm);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        if (src.length == size * 3) {
            intBuf.clear();
            intBuf.put(src, size * 2, size);
            intBuf.position(0).limit(size);
        }
        GlStateManager._bindTexture((int)multiTex.spec);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        GlStateManager._activeTexture((int)33984);
    }

    public static akr getNSMapLocation(akr location, String mapName) {
        if (location == null) {
            return null;
        }
        String basename = location.a();
        String[] basenameParts = basename.split(".png");
        String basenameNoFileType = basenameParts[0];
        return new akr(location.b(), basenameNoFileType + "_" + mapName + ".png");
    }

    private static faj loadNSMapImage(aue manager, akr location, int width, int height, int defaultColor) {
        faj image = ShadersTex.loadNSMapFile((aue)manager, (akr)location, (int)width, (int)height);
        if (image == null) {
            image = new faj(width, height, false);
            int colAbgr = TextureUtils.toAbgr((int)defaultColor);
            image.a(0, 0, width, height, colAbgr);
        }
        return image;
    }

    private static faj makeImageColor(int width, int height, int defaultColor) {
        faj image = new faj(width, height, false);
        int colAbgr = TextureUtils.toAbgr((int)defaultColor);
        image.a(0, 0, width, height, colAbgr);
        return image;
    }

    private static faj loadNSMapFile(aue manager, akr location, int width, int height) {
        if (location == null) {
            return null;
        }
        try {
            auc res = manager.getResourceOrThrow(location);
            faj image = faj.a((InputStream)res.d());
            if (image == null) {
                return null;
            }
            if (image.a() != width || image.b() != height) {
                image.close();
                return null;
            }
            return image;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void loadSimpleTextureNS(int textureID, faj nativeImage, boolean blur, boolean clamp, aue resourceManager, akr location, MultiTexID multiTex) {
        int width = nativeImage.a();
        int height = nativeImage.b();
        akr locNormal = ShadersTex.getNSMapLocation((akr)location, (String)"n");
        faj imageNormal = ShadersTex.loadNSMapImage((aue)resourceManager, (akr)locNormal, (int)width, (int)height, (int)-8421377);
        TextureUtil.prepareImage((int)multiTex.norm, (int)0, (int)width, (int)height);
        imageNormal.a(0, 0, 0, 0, 0, width, height, blur, clamp, false, true);
        akr locSpecular = ShadersTex.getNSMapLocation((akr)location, (String)"s");
        faj imageSpecular = ShadersTex.loadNSMapImage((aue)resourceManager, (akr)locSpecular, (int)width, (int)height, (int)0);
        TextureUtil.prepareImage((int)multiTex.spec, (int)0, (int)width, (int)height);
        imageSpecular.a(0, 0, 0, 0, 0, width, height, blur, clamp, false, true);
        GlStateManager._bindTexture((int)multiTex.base);
    }

    public static void mergeImage(int[] aint, int dstoff, int srcoff, int size) {
    }

    public static int blendColor(int color1, int color2, int factor1) {
        int factor2 = 255 - factor1;
        return ((color1 >>> 24 & 0xFF) * factor1 + (color2 >>> 24 & 0xFF) * factor2) / 255 << 24 | ((color1 >>> 16 & 0xFF) * factor1 + (color2 >>> 16 & 0xFF) * factor2) / 255 << 16 | ((color1 >>> 8 & 0xFF) * factor1 + (color2 >>> 8 & 0xFF) * factor2) / 255 << 8 | ((color1 >>> 0 & 0xFF) * factor1 + (color2 >>> 0 & 0xFF) * factor2) / 255 << 0;
    }

    public static void updateTextureMinMagFilter() {
        gqm texman = fgo.Q().aa();
        gpw texObj = texman.b(gqk.e);
        if (texObj != null) {
            MultiTexID multiTex = texObj.getMultiTexID();
            GlStateManager._bindTexture((int)multiTex.base);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilB]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilB]);
            GlStateManager._bindTexture((int)multiTex.norm);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilN]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilN]);
            GlStateManager._bindTexture((int)multiTex.spec);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilS]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilS]);
            GlStateManager._bindTexture((int)0);
        }
    }

    public static int[][] getFrameTexData(int[][] src, int width, int height, int frameIndex) {
        int numLevel = src.length;
        int[][] dst = new int[numLevel][];
        for (int level = 0; level < numLevel; ++level) {
            int[] sr1 = src[level];
            if (sr1 == null) continue;
            int frameSize = (width >> level) * (height >> level);
            int[] ds1 = new int[frameSize * 3];
            dst[level] = ds1;
            int srcSize = sr1.length / 3;
            int srcPos = frameSize * frameIndex;
            int dstPos = 0;
            System.arraycopy(sr1, srcPos, ds1, dstPos, frameSize);
            System.arraycopy(sr1, srcPos += srcSize, ds1, dstPos += frameSize, frameSize);
            System.arraycopy(sr1, srcPos += srcSize, ds1, dstPos += frameSize, frameSize);
        }
        return dst;
    }

    public static int[][] prepareAF(gql tas, int[][] src, int width, int height) {
        boolean skip = true;
        return src;
    }

    public static void fixTransparentColor(gql tas, int[] aint) {
    }
}

