/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityHelper {
    public static FluidHelper FLUIDS = new FluidHelper();
    public static ItemHelper ITEMS = new ItemHelper();
    public static ComparatorHelper COMPARATOR = new ComparatorHelper();

    public static class FluidHelper {
        public boolean isFluidContainer(ItemStack stack, Direction facing) {
            return !stack.m_41619_() && this.getHandler(stack, facing) != null;
        }

        public boolean isFluidContainer(BlockEntity tile, Direction facing) {
            return tile != null && this.getHandler(tile, facing) != null;
        }

        public boolean isFluidContainer(LevelAccessor world, BlockPos pos, Direction facing) {
            return world != null && pos != null && this.getHandler(world, pos, facing) != null;
        }

        @Nullable
        public IFluidHandler getHandler(ItemStack stack, Direction facing) {
            LazyOptional instHandlerItem;
            IFluidHandler handler = null;
            if (!stack.m_41619_() && (handler = (IFluidHandler)(instHandlerItem = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing)).orElse(null)) == null) {
                LazyOptional instHandler = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
                handler = (IFluidHandler)instHandler.orElse(null);
            }
            return handler;
        }

        @Nullable
        public IFluidHandler getHandler(BlockEntity tile, Direction facing) {
            return tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).orElse(null);
        }

        @Nullable
        public IFluidHandler getHandler(LevelAccessor world, BlockPos pos, Direction facing) {
            BlockEntity tileEntity;
            BlockState state;
            Block block;
            if (world != null && pos != null && (block = (state = world.m_8055_(pos)).m_60734_()) instanceof EntityBlock && (tileEntity = world.m_7702_(pos)) != null) {
                return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).orElse(null);
            }
            return null;
        }
    }

    public static class ItemHelper {
        public boolean isItemContainer(ItemStack stack, Direction facing) {
            return !stack.m_41619_() && this.getHandler(stack, facing) != null;
        }

        public boolean isItemContainer(BlockEntity tile, Direction facing) {
            return tile != null && this.getHandler(tile, facing) != null;
        }

        public boolean isItemContainer(LevelAccessor world, BlockPos pos, Direction facing) {
            return world != null && pos != null && this.getHandler(world, pos, facing) != null;
        }

        @Nullable
        public IItemHandler getHandler(ItemStack stack, Direction facing) {
            return stack.m_41619_() ? null : (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null);
        }

        @Nullable
        public IItemHandler getHandler(BlockEntity tile, Direction facing) {
            return tile == null ? null : (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null);
        }

        @Nullable
        public IItemHandler getHandler(LevelAccessor world, BlockPos pos, Direction facing) {
            return world == null || pos == null ? null : this.getHandler(world.m_7702_(pos), facing);
        }
    }

    public static class ComparatorHelper {
        public int getInputOverride(IFluidHandler handler) {
            if (handler != null) {
                int fluidCount = 0;
                float fullness = 0.0f;
                int tankCount = handler.getTanks();
                for (int tank = 0; tank < tankCount; ++tank) {
                    FluidStack stack = handler.getFluidInTank(tank);
                    if (stack == FluidStack.EMPTY || stack.getAmount() <= 0) continue;
                    fullness += (float)stack.getAmount() / (float)handler.getTankCapacity(tank);
                    ++fluidCount;
                }
                return Mth.m_14143_((float)((fullness /= (float)tankCount) * 14.0f)) + (fluidCount > 0 ? 1 : 0);
            }
            return 0;
        }

        public int getInputOverride(IItemHandler handler) {
            if (handler != null) {
                int itemCount = 0;
                float fullness = 0.0f;
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (stack.m_41619_()) continue;
                    fullness += (float)stack.m_41613_() / (float)Math.min(handler.getSlotLimit(slot), stack.m_41741_());
                    ++itemCount;
                }
                return Mth.m_14143_((float)((fullness /= (float)handler.getSlots()) * 14.0f)) + (itemCount > 0 ? 1 : 0);
            }
            return 0;
        }

        public int getInputOverride(BlockEntity tile) {
            if (tile != null) {
                IFluidHandler fluidHandler;
                int counter = 0;
                float value = 0.0f;
                IItemHandler itemHandler = ITEMS.getHandler(tile, null);
                if (itemHandler != null) {
                    value += (float)this.getInputOverride(itemHandler) / 15.0f;
                    ++counter;
                }
                if ((fluidHandler = FLUIDS.getHandler(tile, null)) != null) {
                    value += (float)this.getInputOverride(fluidHandler) / 15.0f;
                    ++counter;
                }
                if (counter > 0) {
                    return Mth.m_14143_((float)(value / (float)counter * 14.0f)) + (value > 0.0f ? 1 : 0);
                }
            }
            return 0;
        }

        public int getInputOverride(LevelAccessor world, BlockPos pos) {
            return world == null || pos == null ? 0 : this.getInputOverride(world.m_7702_(pos));
        }
    }
}

