/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;
import net.minecraft.util.Unit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ResourceHelper {
    private static final List<ResourceLocation> ERROR_SHOWN = new ArrayList<ResourceLocation>();
    private static ReloadableResourceManager resourceManager = null;
    private static final CompletableFuture<Unit> RESOURCE_RELOAD_INIT_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);

    public static void initialize() {
        if (resourceManager == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                resourceManager = new SimpleReloadableResourceManager(PackType.SERVER_DATA);
                List list = Minecraft.m_91087_().m_91099_().m_10524_().stream().map(Pack::m_10445_).collect(Collectors.toList());
                resourceManager.m_142463_((Executor)Util.m_183991_(), (Executor)Minecraft.m_91087_(), RESOURCE_RELOAD_INIT_TASK, list);
            });
            DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
                if (ServerLifecycleHooks.getCurrentServer() != null) {
                    resourceManager = (ReloadableResourceManager)ServerLifecycleHooks.getCurrentServer().m_177941_();
                }
            });
        }
    }

    public static InputStream getResource(ResourceLocation location) {
        return ResourceHelper.getResource(location, false);
    }

    public static InputStream getResource(ResourceLocation location, boolean hideError) {
        if (resourceManager == null) {
            ResourceHelper.initialize();
        }
        if (resourceManager != null && !resourceManager.m_7187_().isEmpty()) {
            InputStream stream;
            block4: {
                stream = null;
                try {
                    stream = resourceManager.m_142591_(location).m_6679_();
                }
                catch (Exception error) {
                    if (hideError || ERROR_SHOWN.contains(location)) break block4;
                    error.printStackTrace();
                    ERROR_SHOWN.add(location);
                }
            }
            return stream;
        }
        return null;
    }
}

