/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class BlockItemWithTooltip
extends BlockItem {
    private ITooltipPredicate tooltipPredicate;

    public BlockItemWithTooltip(Block block, Item.Properties builder, String tooltipKey) {
        this(block, builder, () -> (stack, world, tooltips, advanced) -> tooltips.add(new TranslatableComponent(tooltipKey)));
    }

    public BlockItemWithTooltip(Block block, Item.Properties builder, Supplier<ITooltipPredicate> tooltipPredicate) {
        super(block, builder);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.lambda$new$2((Supplier)tooltipPredicate));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (this.tooltipPredicate != null) {
            this.tooltipPredicate.test(stack, world, tooltip, tooltipFlag.m_7050_());
        }
    }

    private /* synthetic */ void lambda$new$2(Supplier tooltipPredicate) {
        this.tooltipPredicate = (ITooltipPredicate)tooltipPredicate.get();
    }

    public static interface ITooltipPredicate {
        public void test(ItemStack var1, Level var2, List<Component> var3, Boolean var4);
    }
}

