/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.api;

import com.mojang.blaze3d.platform.NativeImage;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.MeshHelper;
import dev.tr7zw.skinlayers.api.MeshProvider;
import dev.tr7zw.skinlayers.api.MeshTransformerProvider;
import dev.tr7zw.skinlayers.api.PlayerData;
import dev.tr7zw.skinlayers.render.CustomizableCubeListBuilder;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.util.NMSWrapper;
import dev.tr7zw.skinlayers.versionless.util.wrapper.SolidPixelWrapper;
import java.util.Collections;
import net.minecraft.client.player.AbstractClientPlayer;

public class SkinLayersAPI {
    private static final MeshHelper meshHelper = new MeshHelperImplementation();
    private static final MeshProvider meshProvider = new MeshProviderImplementation();
    private static MeshTransformerProvider meshTransformerProvider = MeshTransformerProvider.EMPTY_PROVIDER;

    private SkinLayersAPI() {
    }

    public static MeshHelper getMeshHelper() {
        return meshHelper;
    }

    public static MeshProvider getMeshProvider() {
        return meshProvider;
    }

    public static void setupMeshTransformerProvider(MeshTransformerProvider provider) {
        meshTransformerProvider = provider;
    }

    public static MeshTransformerProvider getMeshTransformerProvider() {
        return meshTransformerProvider;
    }

    private static class MeshHelperImplementation
    implements MeshHelper {
        private MeshHelperImplementation() {
        }

        @Override
        public Mesh create3DMesh(NativeImage natImage, int width, int height, int depth, int textureU, int textureV, boolean topPivot, float rotationOffset) {
            CustomizableCubeListBuilder builder = new CustomizableCubeListBuilder();
            if (SolidPixelWrapper.wrapBox(builder, new NMSWrapper.WrappedNativeImage(natImage), width, height, depth, textureU, textureV, topPivot, rotationOffset) != null) {
                return new CustomizableModelPart(builder.getVanillaCubes(), builder.getCubes(), Collections.emptyMap());
            }
            return Mesh.EMPTY;
        }
    }

    private static class MeshProviderImplementation
    implements MeshProvider {
        private MeshProviderImplementation() {
        }

        @Override
        public PlayerData getPlayerMesh(AbstractClientPlayer abstractClientPlayerEntity) {
            if (abstractClientPlayerEntity instanceof PlayerData) {
                return (PlayerData)abstractClientPlayerEntity;
            }
            return null;
        }
    }
}

