/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.renderlayers.CustomLayerFeatureRenderer;
import dev.tr7zw.skinlayers.util.NMSHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private boolean loaded = false;

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float f) {
        super(context, entityModel, f);
    }

    @Inject(method={"setModelProperties"}, at={@At(value="RETURN")})
    public void setModelProperties(AbstractClientPlayer abstractClientPlayer, CallbackInfo info) {
        if (!this.loaded) {
            this.addLayer(new CustomLayerFeatureRenderer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this));
            this.loaded = true;
        }
        if (Minecraft.getInstance().player == null || abstractClientPlayer.distanceToSqr(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerModel playerModel = (PlayerModel)this.getModel();
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        if (settings.getHeadMesh() == null) {
            return;
        }
        playerModel.hat.visible = playerModel.hat.visible && !SkinLayersModBase.config.enableHat;
        playerModel.jacket.visible = playerModel.jacket.visible && !SkinLayersModBase.config.enableJacket;
        playerModel.leftSleeve.visible = playerModel.leftSleeve.visible && !SkinLayersModBase.config.enableLeftSleeve;
        playerModel.rightSleeve.visible = playerModel.rightSleeve.visible && !SkinLayersModBase.config.enableRightSleeve;
        playerModel.leftPants.visible = playerModel.leftPants.visible && !SkinLayersModBase.config.enableLeftPants;
        playerModel.rightPants.visible = playerModel.rightPants.visible && !SkinLayersModBase.config.enableRightPants;
    }

    @Inject(method={"renderHand"}, at={@At(value="RETURN")})
    private void renderHand(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, ModelPart arm, ModelPart sleeve, CallbackInfo info) {
        boolean rightSleeve;
        boolean bl = rightSleeve = ((PlayerModel)this.getModel()).leftSleeve != sleeve;
        if (rightSleeve ? !SkinLayersModBase.config.enableRightSleeve : !SkinLayersModBase.config.enableLeftSleeve) {
            return;
        }
        sleeve.visible = false;
        if (!abstractClientPlayer.isModelPartShown(rightSleeve ? PlayerModelPart.RIGHT_SLEEVE : PlayerModelPart.LEFT_SLEEVE)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        float armHeightScaling = 1.1f;
        boolean thinArms = ((PlayerEntityModelAccessor)this.getModel()).hasThinArms();
        if (!SkinUtil.setup3dLayers(abstractClientPlayer, settings, thinArms, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.getModel()))) {
            return;
        }
        Mesh part = sleeve == ((PlayerModel)this.model).leftSleeve ? settings.getLeftArmMesh() : settings.getRightArmMesh();
        part.copyFrom(arm);
        poseStack.pushPose();
        poseStack.scale(SkinLayersModBase.config.firstPersonPixelScaling, armHeightScaling, SkinLayersModBase.config.firstPersonPixelScaling);
        boolean left = sleeve == ((PlayerModel)this.model).leftSleeve;
        float x = left ? 5.0f : -5.0f;
        float y = 1.4f;
        double scaleOffset = ((double)SkinLayersModBase.config.firstPersonPixelScaling - 1.1) * 5.0;
        x = left ? (float)((double)x - scaleOffset) : (float)((double)x + scaleOffset);
        if (!thinArms) {
            x = left ? (float)((double)x + 0.45) : (float)((double)x - 0.45);
        }
        part.setPosition(x, y, 0.0f);
        part.render(poseStack, multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)NMSHelper.getPlayerSkin(abstractClientPlayer))), i, OverlayTexture.NO_OVERLAY);
        part.setPosition(0.0f, 0.0f, 0.0f);
        part.setRotation(0.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }
}

