/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class RefillUpgradeWrapper
extends UpgradeWrapperBase<RefillUpgradeWrapper, RefillUpgradeItem>
implements IFilteredUpgrade,
ITickableUpgrade {
    private static final int COOLDOWN = 5;
    private final FilterLogic filterLogic;

    public RefillUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((Integer)Config.COMMON.refillUpgrade.filterSlots.get()).intValue());
        this.filterLogic.setAllowByDefault();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (entity == null || this.isInCooldown(world)) {
            return;
        }
        entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(playerInvHandler -> InventoryHelper.iterate((IItemHandler)this.filterLogic.getFilterHandler(), (slot, filter) -> {
            if (filter.m_41619_()) {
                return;
            }
            int missingCount = InventoryHelper.getCountMissingInHandler((IItemHandler)playerInvHandler, (ItemStack)filter, (int)filter.m_41741_());
            if (missingCount == 0) {
                return;
            }
            ITrackedContentsItemHandler extractFromHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
            ItemStack toMove = filter.m_41777_();
            toMove.m_41764_(missingCount);
            ItemStack extracted = InventoryHelper.extractFromInventory((ItemStack)toMove, (IItemHandler)extractFromHandler, (boolean)true);
            if (extracted.m_41619_()) {
                return;
            }
            if (missingCount < filter.m_41741_()) {
                this.refillExistingStack((IItemHandler)playerInvHandler, (IItemHandler)extractFromHandler, extracted);
            } else {
                this.refillAnywhereInInventory((IItemHandler)playerInvHandler, (IItemHandler)extractFromHandler, toMove, extracted);
            }
        }));
        this.setCooldown(world, 5);
    }

    private void refillExistingStack(IItemHandler playerInvHandler, IItemHandler extractFromHandler, ItemStack extracted) {
        AtomicBoolean refilledStack = new AtomicBoolean(false);
        InventoryHelper.iterate((IItemHandler)playerInvHandler, (slot, stack) -> {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)extracted)) {
                playerInvHandler.insertItem(slot.intValue(), InventoryHelper.extractFromInventory((ItemStack)extracted, (IItemHandler)extractFromHandler, (boolean)false), false);
                refilledStack.set(true);
            }
        }, refilledStack::get);
    }

    private void refillAnywhereInInventory(IItemHandler playerInvHandler, IItemHandler extractFromHandler, ItemStack toMove, ItemStack extracted) {
        ItemStack remaining = InventoryHelper.insertIntoInventory((ItemStack)extracted, (IItemHandler)playerInvHandler, (boolean)true);
        if (remaining.m_41613_() == extracted.m_41613_()) {
            return;
        }
        toMove.m_41764_(extracted.m_41613_() - remaining.m_41613_());
        InventoryHelper.insertIntoInventory((ItemStack)InventoryHelper.extractFromInventory((ItemStack)toMove, (IItemHandler)extractFromHandler, (boolean)false), (IItemHandler)playerInvHandler, (boolean)false);
    }
}

