/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackCloseMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BlockToolSwapMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.EntityToolSwapMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.InventoryInteractionMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.UpgradeToggleMessage;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class KeybindHandler {
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_Z = 90;
    private static final int KEY_X = 88;
    private static final int KEY_UNKNOWN = -1;
    private static final int MIDDLE_BUTTON = 2;
    private static final int CHEST_SLOT_INDEX = 6;
    private static final String KEYBIND_SOPHISTICATEDBACKPACKS_CATEGORY = "keybind.sophisticatedbackpacks.category";
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_5 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_5"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.m_84895_(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_4 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_4"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.m_84895_(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_3 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_3"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.m_84895_(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_2 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_2"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputConstants.Type.KEYSYM.m_84895_(88), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_1 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_1"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputConstants.Type.KEYSYM.m_84895_(90), "keybind.sophisticatedbackpacks.category");
    public static final Map<Integer, KeyMapping> UPGRADE_SLOT_TOGGLE_KEYBINDS = Map.of(0, BACKPACK_TOGGLE_UPGRADE_1, 1, BACKPACK_TOGGLE_UPGRADE_2, 2, BACKPACK_TOGGLE_UPGRADE_3, 3, BACKPACK_TOGGLE_UPGRADE_4, 4, BACKPACK_TOGGLE_UPGRADE_5);
    public static final KeyMapping SORT_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("sort"), (IKeyConflictContext)BackpackGuiKeyConflictContext.INSTANCE, InputConstants.Type.MOUSE.m_84895_(2), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping TOOL_SWAP_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("tool_swap"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.m_84895_(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping INVENTORY_INTERACTION_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("inventory_interaction"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.m_84895_(67), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_OPEN_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("open_backpack"), (IKeyConflictContext)BackpackKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.m_84895_(66), "keybind.sophisticatedbackpacks.category");

    private KeybindHandler() {
    }

    public static void register() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(KeybindHandler::handleKeyInputEvent);
        eventBus.addListener(KeybindHandler::screenKeyPressed);
        eventBus.addListener(EventPriority.HIGH, KeybindHandler::handleGuiMouseKeyPress);
        eventBus.addListener(EventPriority.HIGH, KeybindHandler::handleGuiKeyPress);
    }

    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(BACKPACK_OPEN_KEYBIND);
        event.register(INVENTORY_INTERACTION_KEYBIND);
        event.register(TOOL_SWAP_KEYBIND);
        event.register(SORT_KEYBIND);
        UPGRADE_SLOT_TOGGLE_KEYBINDS.forEach((slot, keybind) -> event.register(keybind));
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        InputConstants.Key key = InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode());
        if (SORT_KEYBIND.isActiveAndMatches(key) && KeybindHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        } else if (BACKPACK_OPEN_KEYBIND.isActiveAndMatches(key)) {
            KeybindHandler.sendBackpackOpenOrCloseMessage();
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(event.getButton());
        if (SORT_KEYBIND.isActiveAndMatches(input) && KeybindHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        } else if (BACKPACK_OPEN_KEYBIND.isActiveAndMatches(input)) {
            KeybindHandler.sendBackpackOpenOrCloseMessage();
        }
    }

    public static void handleKeyInputEvent(TickEvent.ClientTickEvent event) {
        if (BACKPACK_OPEN_KEYBIND.m_90859_()) {
            KeybindHandler.sendBackpackOpenOrCloseMessage();
        } else if (INVENTORY_INTERACTION_KEYBIND.m_90859_()) {
            KeybindHandler.sendInteractWithInventoryMessage();
        } else if (TOOL_SWAP_KEYBIND.m_90859_()) {
            KeybindHandler.sendToolSwapMessage();
        } else {
            for (Map.Entry<Integer, KeyMapping> slotKeybind : UPGRADE_SLOT_TOGGLE_KEYBINDS.entrySet()) {
                if (!slotKeybind.getValue().m_90859_()) continue;
                SBPPacketHandler.INSTANCE.sendToServer(new UpgradeToggleMessage(slotKeybind.getKey()));
            }
        }
    }

    private static void screenKeyPressed(ScreenEvent.KeyPressed.Post event) {
    }

    private static boolean tryCallSort(Screen gui) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (abstractContainerMenu = mc.f_91074_.f_36096_) instanceof BackpackContainer) {
            double mouseY;
            MouseHandler mh;
            double mouseX;
            BackpackScreen screen;
            Slot selectedSlot;
            BackpackContainer container = (BackpackContainer)abstractContainerMenu;
            if (gui instanceof BackpackScreen && (selectedSlot = (screen = (BackpackScreen)gui).m_97744_(mouseX = (mh = mc.f_91067_).m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_(), mouseY = mh.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_())) != null && container.isNotPlayersInventorySlot(selectedSlot.f_40219_)) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static void sendToolSwapMessage() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91077_ == null) {
            return;
        }
        if (player.m_21205_().m_41720_() instanceof BackpackItem) {
            player.m_5661_((Component)Component.m_237115_((String)"gui.sophisticatedbackpacks.status.unable_to_swap_tool_for_backpack"), true);
            return;
        }
        HitResult rayTrace = mc.f_91077_;
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)rayTrace;
            BlockPos pos = blockRayTraceResult.m_82425_();
            SBPPacketHandler.INSTANCE.sendToServer(new BlockToolSwapMessage(pos));
        } else if (rayTrace.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityRayTraceResult = (EntityHitResult)rayTrace;
            SBPPacketHandler.INSTANCE.sendToServer(new EntityToolSwapMessage(entityRayTraceResult.m_82443_().m_19879_()));
        }
    }

    private static void sendInteractWithInventoryMessage() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult rayTrace = mc.f_91077_;
        if (rayTrace == null || rayTrace.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockraytraceresult = (BlockHitResult)rayTrace;
        BlockPos pos = blockraytraceresult.m_82425_();
        if (!WorldHelper.getBlockEntity((BlockGetter)mc.f_91073_, (BlockPos)pos, BlockEntity.class).map(te -> te.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()).orElse(false).booleanValue()) {
            return;
        }
        SBPPacketHandler.INSTANCE.sendToServer(new InventoryInteractionMessage(pos, blockraytraceresult.m_82434_()));
    }

    private static void sendBackpackOpenOrCloseMessage() {
        InventoryScreen inventoryScreen;
        Slot slot;
        if (!KeyConflictContext.GUI.isActive()) {
            SBPPacketHandler.INSTANCE.sendToServer(new BackpackOpenMessage());
            return;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof BackpackScreen) {
            BackpackScreen backpackScreen = (BackpackScreen)screen;
            Slot slot2 = backpackScreen.getSlotUnderMouse();
            if (slot2 != null && slot2.m_7993_().m_41720_() instanceof BackpackItem) {
                if (slot2.m_7993_().m_41613_() == 1) {
                    SBPPacketHandler.INSTANCE.sendToServer(new BackpackOpenMessage(slot2.f_40219_));
                }
            } else {
                SBPPacketHandler.INSTANCE.sendToServer(new BackpackCloseMessage());
            }
        } else if (screen instanceof InventoryScreen && (slot = (inventoryScreen = (InventoryScreen)screen).getSlotUnderMouse()) != null && KeybindHandler.isSupportedPlayerInventorySlot(slot.f_40219_) && slot.m_7993_().m_41720_() instanceof BackpackItem) {
            SBPPacketHandler.INSTANCE.sendToServer(new BackpackOpenMessage(slot.getSlotIndex()));
        }
    }

    private static boolean isSupportedPlayerInventorySlot(int slotIndex) {
        return slotIndex == 6 || slotIndex > 8 && slotIndex < 46;
    }

    private static class BackpackGuiKeyConflictContext
    implements IKeyConflictContext {
        public static final BackpackGuiKeyConflictContext INSTANCE = new BackpackGuiKeyConflictContext();

        private BackpackGuiKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.GUI.isActive() && Minecraft.m_91087_().f_91080_ instanceof BackpackScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }

    private static class BackpackKeyConflictContext
    implements IKeyConflictContext {
        public static final BackpackKeyConflictContext INSTANCE = new BackpackKeyConflictContext();

        private BackpackKeyConflictContext() {
        }

        public boolean isActive() {
            if (!KeyConflictContext.GUI.isActive()) {
                return true;
            }
            Screen screen = Minecraft.m_91087_().f_91080_;
            return screen instanceof BackpackScreen || screen instanceof InventoryScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

