/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.network.StorageInsertMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class ClientEventHandler {
    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::stitchTextures);
        modBus.addListener(ModParticles::registerFactories);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onPlayerJoinServer);
        eventBus.addListener(StorageSoundHandler::tick);
        eventBus.addListener(StorageSoundHandler::onWorldUnload);
        eventBus.addListener(ClientEventHandler::onDrawScreen);
        eventBus.addListener(EventPriority.HIGH, ClientEventHandler::onRightClick);
    }

    public static void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            evt.addSprite(StorageContainerMenuBase.EMPTY_UPGRADE_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_INPUT_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_OUTPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_INPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_OUTPUT_SLOT_BACKGROUND);
        }
    }

    private static void onDrawScreen(ScreenEvent.Render.Post event) {
        AbstractContainerScreen containerGui;
        Minecraft mc;
        block7: {
            block6: {
                mc = Minecraft.m_91087_();
                Screen gui = mc.f_91080_;
                if (!(gui instanceof AbstractContainerScreen)) break block6;
                containerGui = (AbstractContainerScreen)gui;
                if (!(gui instanceof CreativeModeInventoryScreen) && mc.f_91074_ != null) break block7;
            }
            return;
        }
        AbstractContainerMenu menu = containerGui.m_6262_();
        ItemStack held = menu.m_142621_();
        if (!held.m_41619_()) {
            Slot under = containerGui.getSlotUnderMouse();
            PoseStack poseStack = event.getPoseStack();
            for (Slot s : menu.f_38839_) {
                int y;
                int x;
                IStashStorageItem stashStorageItem;
                Item item;
                ItemStack stack = s.m_7993_();
                if (!s.m_8010_((Player)mc.f_91074_) || stack.m_41613_() != 1 || !((item = stack.m_41720_()) instanceof IStashStorageItem) || !(stashStorageItem = (IStashStorageItem)item).isItemStashable(stack, held)) continue;
                if (s == under) {
                    x = event.getMouseX();
                    y = event.getMouseY();
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.0, 0.0, containerGui instanceof StorageScreenBase ? -100.0 : 100.0);
                    containerGui.renderTooltip(poseStack, Collections.singletonList(Component.m_237115_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), stashStorageItem.getInventoryTooltip(stack), x, y, mc.f_91062_);
                    poseStack.m_85849_();
                    continue;
                }
                x = containerGui.getGuiLeft() + s.f_40220_;
                y = containerGui.getGuiTop() + s.f_40221_;
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, containerGui instanceof StorageScreenBase ? 100.0 : 499.0);
                mc.f_91062_.m_92750_(poseStack, "+", (float)x + 10.0f, (float)y + 8.0f, 0xFFFF00);
                poseStack.m_85849_();
            }
        }
    }

    private static void onRightClick(ScreenEvent.MouseButtonReleased.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen container = (AbstractContainerScreen)screen;
            if (!(screen instanceof CreativeModeInventoryScreen) && event.getButton() == 1) {
                ItemStack stack;
                Slot under = container.getSlotUnderMouse();
                ItemStack held = container.m_6262_().m_142621_();
                if (under != null && !held.m_41619_() && mc.f_91074_ != null && under.m_8010_((Player)mc.f_91074_) && (stack = under.m_7993_()).m_41720_() instanceof IStashStorageItem && stack.m_41613_() == 1) {
                    SophisticatedCore.PACKET_HANDLER.sendToServer(new StorageInsertMessage(under.f_40219_));
                    screen.m_6348_(0.0, 0.0, -1);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static void onPlayerJoinServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        RecipeHelper.setWorld((Level)Minecraft.m_91087_().f_91073_);
    }
}

