/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.InventoryScrollPanel;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.settings.StorageSettingsTabControlBase;

public abstract class SettingsScreen
extends AbstractContainerScreen<SettingsContainer<?>>
implements InventoryScrollPanel.IInventoryScreen {
    public static final int HEIGHT_WITHOUT_STORAGE_SLOTS = 114;
    private StorageSettingsTabControlBase settingsTabControl;
    private InventoryScrollPanel inventoryScrollPanel = null;
    private StorageBackgroundProperties storageBackgroundProperties;

    protected SettingsScreen(SettingsContainer<?> screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.updateDimensionsAndSlotPositions(Minecraft.m_91087_().m_91268_().m_85446_());
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        this.updateDimensionsAndSlotPositions(pHeight);
        super.m_6574_(pMinecraft, pWidth, pHeight);
    }

    private void updateDimensionsAndSlotPositions(int pHeight) {
        int displayableNumberOfRows = Math.min((pHeight - 114) / 18, ((SettingsContainer)this.m_6262_()).getNumberOfRows());
        int newImageHeight = 114 + this.getStorageInventoryHeight(displayableNumberOfRows);
        this.storageBackgroundProperties = ((SettingsContainer)this.m_6262_()).getNumberOfStorageInventorySlots() + ((SettingsContainer)this.m_6262_()).getColumnsTaken() * ((SettingsContainer)this.m_6262_()).getNumberOfRows() <= 81 ? StorageBackgroundProperties.REGULAR_9_SLOT : StorageBackgroundProperties.REGULAR_12_SLOT;
        this.f_97726_ = this.storageBackgroundProperties.getSlotsOnLine() * 18 + 14;
        this.updateStorageSlotsPositions();
        if (displayableNumberOfRows < ((SettingsContainer)this.m_6262_()).getNumberOfRows()) {
            this.storageBackgroundProperties = this.storageBackgroundProperties == StorageBackgroundProperties.REGULAR_9_SLOT ? StorageBackgroundProperties.WIDER_9_SLOT : StorageBackgroundProperties.WIDER_12_SLOT;
            this.f_97726_ += 6;
        }
        this.f_97727_ = newImageHeight;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8 + this.storageBackgroundProperties.getPlayerInventoryXOffset();
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return displayableNumberOfRows * 18;
    }

    private void updateInventoryScrollPanel() {
        int numberOfVisibleRows;
        if (this.inventoryScrollPanel != null) {
            this.m_169411_((GuiEventListener)this.inventoryScrollPanel);
        }
        if ((numberOfVisibleRows = this.getNumberOfVisibleRows()) < ((SettingsContainer)this.m_6262_()).getNumberOfRows()) {
            this.inventoryScrollPanel = new InventoryScrollPanel(Minecraft.m_91087_(), this, 0, ((SettingsContainer)this.m_6262_()).getNumberOfStorageInventorySlots(), this.getSlotsOnLine(), numberOfVisibleRows * 18, this.getGuiTop() + 17, this.getGuiLeft() + 7);
            this.m_142416_((GuiEventListener)this.inventoryScrollPanel);
            this.inventoryScrollPanel.updateSlotsYPosition();
        } else {
            this.inventoryScrollPanel = null;
        }
    }

    private int getNumberOfVisibleRows() {
        return Math.min((this.f_97727_ - 114) / 18, ((SettingsContainer)this.m_6262_()).getNumberOfRows());
    }

    protected void updateStorageSlotsPositions() {
        int yPosition = 18;
        int slotIndex = 0;
        while (slotIndex < ((SettingsContainer)this.m_6262_()).getNumberOfStorageInventorySlots()) {
            Slot slot = ((SettingsContainer)this.m_6262_()).m_38853_(slotIndex);
            int lineIndex = slotIndex % this.getSlotsOnLine();
            slot.f_40220_ = 8 + lineIndex * 18;
            slot.f_40221_ = yPosition;
            if (++slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - ((SettingsContainer)this.m_6262_()).getColumnsTaken();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateInventoryScrollPanel();
        this.settingsTabControl = this.initializeTabControl();
        this.m_7787_(this.settingsTabControl);
    }

    protected abstract StorageSettingsTabControlBase initializeTabControl();

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        StorageGuiHelper.renderStorageBackground(new Position(x, y), matrixStack, this.storageBackgroundProperties.getTextureName(), this.f_97726_, this.getStorageInventoryHeight(this.getNumberOfVisibleRows()));
        if (this.inventoryScrollPanel == null) {
            this.drawSlotBg(matrixStack, x, y);
        }
    }

    protected void drawSlotBg(PoseStack matrixStack, int x, int y) {
        int inventorySlots = ((SettingsContainer)this.m_6262_()).getStorageInventorySlots().size();
        int slotsOnLine = this.getSlotsOnLine();
        int slotRows = inventorySlots / slotsOnLine;
        int remainingSlots = inventorySlots % slotsOnLine;
        GuiHelper.renderSlotsBackground(matrixStack, x + 7, y + 17, slotsOnLine, slotRows, remainingSlots);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ((SettingsContainer)this.f_97732_).detectSettingsChangeAndReload();
        this.m_7333_(matrixStack);
        this.settingsTabControl.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85837_(0.0, 0.0, 200.0);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((Screen)this, matrixStack, mouseX, mouseY);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        if (this.inventoryScrollPanel == null) {
            this.renderInventorySlots(matrixStack, mouseX, mouseY, true);
        }
    }

    @Override
    public void renderInventorySlots(PoseStack matrixStack, int mouseX, int mouseY, boolean canShowHover) {
        for (int slotId = 0; slotId < ((SettingsContainer)this.f_97732_).ghostSlots.size(); ++slotId) {
            Slot slot = ((SettingsContainer)this.f_97732_).ghostSlots.get(slotId);
            this.m_97799_(matrixStack, slot);
            this.settingsTabControl.renderSlotOverlays(matrixStack, slot, this::renderSlotOverlay);
            if (canShowHover && this.m_97774_(slot, mouseX, mouseY) && slot.m_6659_()) {
                this.f_97734_ = slot;
                this.renderSlotOverlay(matrixStack, slot, this.getSlotColor(slotId));
            }
            this.settingsTabControl.renderSlotExtra(matrixStack, slot);
        }
    }

    protected void m_97799_(PoseStack poseStack, Slot slot) {
        Optional<ItemStack> memorizedStack = ((SettingsContainer)this.m_6262_()).getMemorizedStackInSlot(slot.getSlotIndex());
        ItemStack itemstack = slot.m_7993_();
        if (memorizedStack.isPresent()) {
            itemstack = memorizedStack.get();
        }
        this.m_93250_(100);
        this.f_96542_.f_115093_ = 100.0f;
        RenderSystem.m_69482_();
        poseStack.m_85836_();
        this.settingsTabControl.renderGuiItem(this.f_96542_, itemstack, slot);
        poseStack.m_85849_();
        this.f_96542_.f_115093_ = 0.0f;
        this.m_93250_(0);
        if (memorizedStack.isPresent()) {
            this.drawMemorizedStackOverlay(poseStack, slot.f_40220_, slot.f_40221_);
        }
    }

    private void drawMemorizedStackOverlay(PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiHelper.GUI_CONTROLS);
        this.m_93228_(poseStack, x, y, 77, 0, 16, 16);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, mouseButton);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, button);
        }
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Nullable
    protected Slot m_97744_(double mouseX, double mouseY) {
        for (int i = 0; i < ((SettingsContainer)this.f_97732_).ghostSlots.size(); ++i) {
            Slot slot = ((SettingsContainer)this.f_97732_).ghostSlots.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.m_110087_((int)mouseX, (int)mouseY));
    }

    private void renderSlotOverlay(PoseStack matrixStack, Slot slot, int slotColor) {
        this.renderSlotOverlay(matrixStack, slot.f_40220_, slot.f_40221_, 16, slotColor);
    }

    private void renderSlotOverlay(PoseStack matrixStack, int xPos, int yPos, int height, int slotColor) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.m_93179_(matrixStack, xPos, yPos, xPos + 16, yPos + height, slotColor, slotColor);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.sendStorageInventoryScreenOpenMessage();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected abstract void sendStorageInventoryScreenOpenMessage();

    public StorageSettingsTabControlBase getSettingsTabControl() {
        return this.settingsTabControl;
    }

    @Override
    public boolean isMouseOverSlot(Slot pSlot, double pMouseX, double pMouseY) {
        return this.m_97774_(pSlot, pMouseX, pMouseY);
    }

    @Override
    public void drawSlotBg(PoseStack matrixStack) {
        this.drawSlotBg(matrixStack, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2);
    }

    @Override
    public int getTopY() {
        return this.getGuiTop();
    }

    @Override
    public int getLeftX() {
        return this.getGuiLeft();
    }

    @Override
    public Slot getSlot(int slotIndex) {
        return ((SettingsContainer)this.m_6262_()).m_38853_(slotIndex);
    }
}

