/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsContainer;

public abstract class SettingsContainer<S extends IStorageWrapper>
extends AbstractContainerMenu
implements ISyncedContainer {
    private static final Map<String, ISettingsContainerFactory<?, ?>> SETTINGS_CONTAINER_FACTORIES = new HashMap();
    protected final Player player;
    protected final S storageWrapper;
    private final List<Slot> storageInventorySlots = new ArrayList<Slot>();
    public final NonNullList<ItemStack> lastGhostSlots = NonNullList.m_122779_();
    public final NonNullList<ItemStack> remoteGhostSlots = NonNullList.m_122779_();
    private final Map<String, SettingsContainerBase<?>> settingsContainers = new LinkedHashMap();
    public final List<Slot> ghostSlots = new ArrayList<Slot>();

    protected SettingsContainer(MenuType<?> menuType, int windowId, Player player, S storageWrapper) {
        super(menuType, windowId);
        this.player = player;
        this.storageWrapper = storageWrapper;
        this.addStorageInventorySlots();
        this.addSettingsContainers();
    }

    public int getNumberOfStorageInventorySlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public S getStorageWrapper() {
        return this.storageWrapper;
    }

    private void addSettingsContainers() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        settingsHandler.getSettingsCategories().forEach((name, category) -> this.settingsContainers.put((String)name, SettingsContainer.instantiateContainer(this, name, category)));
    }

    private void addStorageInventorySlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slotIndex = 0;
        while (slotIndex < inventoryHandler.getSlots()) {
            int finalSlotIndex = slotIndex++;
            this.storageInventorySlots.add(this.m_38897_((Slot)new ViewOnlyStorageInventorySlot((IItemHandler)inventoryHandler, finalSlotIndex)));
        }
    }

    public int getColumnsTaken() {
        return this.storageWrapper.getColumnsTaken();
    }

    protected Slot m_38897_(Slot slot) {
        slot.f_40219_ = this.ghostSlots.size();
        this.ghostSlots.add(slot);
        this.lastGhostSlots.add((Object)ItemStack.f_41583_);
        this.remoteGhostSlots.add((Object)ItemStack.f_41583_);
        return slot;
    }

    public void m_38946_() {
        for (int slot = 0; slot < this.ghostSlots.size(); ++slot) {
            ItemStack itemstack = this.ghostSlots.get(slot).m_7993_();
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).m_41777_());
            this.triggerSlotListeners(slot, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
            this.synchronizeSlotToRemote(slot, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
        }
    }

    public void m_182423_() {
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            ItemStack itemstack = this.ghostSlots.get(slotIndex).m_7993_();
            this.triggerSlotListeners(slotIndex, itemstack, () -> ((ItemStack)itemstack).m_41777_());
        }
        this.m_150429_();
    }

    private void triggerSlotListeners(int slotIndex, ItemStack slotStack, java.util.function.Supplier<ItemStack> slotStackCopy) {
        ItemStack itemstack = (ItemStack)this.lastGhostSlots.get(slotIndex);
        if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)slotStack)) {
            boolean clientStackChanged = !slotStack.equals(itemstack, true);
            ItemStack itemstack1 = slotStackCopy.get();
            this.lastGhostSlots.set(slotIndex, (Object)itemstack1);
            if (clientStackChanged) {
                for (ContainerListener containerlistener : this.f_38848_) {
                    containerlistener.m_7934_((AbstractContainerMenu)this, slotIndex, itemstack1);
                }
            }
        }
    }

    private void synchronizeSlotToRemote(int slotIndex, ItemStack slotStack, java.util.function.Supplier<ItemStack> slotStackCopy) {
        ItemStack itemstack;
        if (!this.f_150398_ && !ItemStack.m_41728_((ItemStack)(itemstack = (ItemStack)this.remoteGhostSlots.get(slotIndex)), (ItemStack)slotStack)) {
            ItemStack stackCopy = slotStackCopy.get();
            this.remoteGhostSlots.set(slotIndex, (Object)stackCopy);
            if (this.f_150397_ != null) {
                this.f_150397_.m_142074_((AbstractContainerMenu)this, slotIndex, stackCopy);
            }
        }
    }

    public int getNumberOfSlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public void m_150429_() {
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            this.remoteGhostSlots.set(slotIndex, (Object)this.ghostSlots.get(slotIndex).m_7993_().m_41777_());
        }
        if (this.f_150397_ != null) {
            this.f_150397_.m_142589_((AbstractContainerMenu)this, this.remoteGhostSlots, this.f_150396_, new int[0]);
        }
    }

    public abstract void detectSettingsChangeAndReload();

    public void m_150416_(ContainerSynchronizer synchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.storageWrapper.getInventoryHandler().getStackSizeMultiplier() > 1) {
                super.m_150416_((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
                return;
            }
        }
        super.m_150416_(synchronizer);
    }

    public Slot m_38853_(int slotId) {
        return this.ghostSlots.get(slotId);
    }

    public Optional<ItemStack> getMemorizedStackInSlot(int slotId) {
        return this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotFilterStack(slotId, false);
    }

    public void onMemorizedStackRemoved(int slotId) {
        if (this.m_38853_(slotId).m_7993_().m_41619_()) {
            this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemChanged(slotId);
        }
    }

    public void onMemorizedItemsChanged() {
        this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemsChanged();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public List<Slot> getStorageInventorySlots() {
        return this.storageInventorySlots;
    }

    @Override
    public void handleMessage(CompoundTag data) {
        String categoryName;
        if (data.m_128441_("categoryName") && this.settingsContainers.containsKey(categoryName = data.m_128461_("categoryName"))) {
            this.settingsContainers.get(categoryName).handleMessage(data);
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public void forEachSettingsContainer(BiConsumer<String, ? super SettingsContainerBase<?>> consumer) {
        this.settingsContainers.forEach(consumer);
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getBlockPosition() {
        return BlockPos.f_121853_;
    }

    public int getNumberOfRows() {
        return this.storageWrapper.getNumberOfSlotRows();
    }

    protected static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> void addFactory(String categoryName, ISettingsContainerFactory<C, T> factory) {
        SETTINGS_CONTAINER_FACTORIES.put(categoryName, factory);
    }

    private static <C extends ISettingsCategory> SettingsContainerBase<C> instantiateContainer(SettingsContainer<?> settingsContainer, String name, C category) {
        return SettingsContainer.getSettingsContainerFactory(name).create(settingsContainer, name, category);
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> ISettingsContainerFactory<C, T> getSettingsContainerFactory(String name) {
        return SETTINGS_CONTAINER_FACTORIES.get(name);
    }

    static {
        SettingsContainer.addFactory("global", MainSettingsContainer::new);
        SettingsContainer.addFactory("no_sort", NoSortSettingsContainer::new);
        SettingsContainer.addFactory("memory", MemorySettingsContainer::new);
        SettingsContainer.addFactory("item_display", ItemDisplaySettingsContainer::new);
    }

    private static class ViewOnlyStorageInventorySlot
    extends SlotItemHandler {
        public ViewOnlyStorageInventorySlot(IItemHandler inventoryHandler, int slotIndex) {
            super(inventoryHandler, slotIndex, 0, 0);
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    public static interface ISettingsContainerFactory<C extends ISettingsCategory, T extends SettingsContainerBase<C>> {
        public T create(SettingsContainer<?> var1, String var2, C var3);
    }
}

