/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public class NBTHelper {
    private NBTHelper() {
    }

    public static Optional<Integer> getInt(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundTag::m_128451_);
    }

    public static Optional<Integer> getInt(CompoundTag tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundTag::m_128451_);
    }

    public static Optional<int[]> getIntArray(CompoundTag tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundTag::m_128465_);
    }

    private static <T> Optional<T> getTagValue(ItemStack stack, String key, BiFunction<CompoundTag, String, T> getValue) {
        return NBTHelper.getTagValue(stack, "", key, getValue);
    }

    public static <T> Optional<T> getTagValue(ItemStack stack, String parentKey, String key, BiFunction<CompoundTag, String, T> getValue) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Optional.empty();
        }
        if (!parentKey.isEmpty()) {
            Tag parentTag = tag.m_128423_(parentKey);
            if (!(parentTag instanceof CompoundTag)) {
                return Optional.empty();
            }
            tag = (CompoundTag)parentTag;
        }
        return NBTHelper.getTagValue(tag, key, getValue);
    }

    public static Optional<Boolean> getBoolean(CompoundTag tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundTag::m_128471_);
    }

    public static Optional<CompoundTag> getCompound(CompoundTag tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundTag::m_128469_);
    }

    public static <T> Optional<T> getTagValue(CompoundTag tag, String key, BiFunction<CompoundTag, String, T> getValue) {
        if (!tag.m_128441_(key)) {
            return Optional.empty();
        }
        return Optional.of(getValue.apply(tag, key));
    }

    public static <E, C extends Collection<E>> Optional<C> getCollection(ItemStack stack, String parentKey, String tagName, byte listType, Function<Tag, Optional<E>> getElement, Supplier<C> initCollection) {
        return NBTHelper.getTagValue(stack, parentKey, tagName, (c, n) -> c.m_128437_(n, (int)listType)).map(listNbt -> {
            Collection ret = (Collection)initCollection.get();
            listNbt.forEach(elementNbt -> ((Optional)getElement.apply((Tag)elementNbt)).ifPresent(ret::add));
            return ret;
        });
    }

    public static <E, C extends Collection<E>> Optional<C> getCollection(CompoundTag tag, String key, byte listType, Function<Tag, Optional<E>> getElement, Supplier<C> initCollection) {
        return NBTHelper.getTagValue(tag, key, (CompoundTag c, String n) -> c.m_128437_(n, (int)listType)).map(listNbt -> {
            Collection ret = (Collection)initCollection.get();
            listNbt.forEach(elementNbt -> ((Optional)getElement.apply((Tag)elementNbt)).ifPresent(ret::add));
            return ret;
        });
    }

    public static Optional<CompoundTag> getCompound(ItemStack stack, String parentKey, String tagName) {
        return NBTHelper.getTagValue(stack, parentKey, tagName, CompoundTag::m_128469_);
    }

    public static Optional<CompoundTag> getCompound(ItemStack stack, String tagName) {
        return NBTHelper.getTagValue(stack, tagName, CompoundTag::m_128469_);
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(ItemStack stack, String parentKey, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, parentKey, key, (t, k) -> (Enum)deserialize.apply(t.m_128461_(k)));
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(ItemStack stack, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, key, (CompoundTag t, String k) -> (Enum)deserialize.apply(t.m_128461_(k)));
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(CompoundTag tag, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(tag, key, (CompoundTag t, String k) -> (Enum)deserialize.apply(t.m_128461_(k)));
    }

    public static Optional<Boolean> getBoolean(ItemStack stack, String parentKey, String key) {
        return NBTHelper.getTagValue(stack, parentKey, key, CompoundTag::m_128471_);
    }

    public static Optional<Boolean> getBoolean(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundTag::m_128471_);
    }

    public static Optional<Long> getLong(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundTag::m_128454_);
    }

    public static Optional<Long> getLong(CompoundTag tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundTag::m_128454_);
    }

    public static Optional<UUID> getUniqueId(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, (CompoundTag compound, String k) -> NbtUtils.m_129233_((Tag)compound.m_128423_(k)));
    }

    public static void setCompoundNBT(ItemStack stack, String key, CompoundTag tag) {
        NBTHelper.setCompoundNBT(stack, "", key, tag);
    }

    public static void setCompoundNBT(ItemStack stack, String parentKey, String key, CompoundTag tag) {
        if (parentKey.isEmpty()) {
            stack.m_41784_().m_128365_(key, (Tag)tag);
            return;
        }
        stack.m_41698_(parentKey).m_128365_(key, (Tag)tag);
    }

    public static void setBoolean(ItemStack stack, String parentKey, String key, boolean value) {
        if (parentKey.isEmpty()) {
            NBTHelper.setBoolean(stack, key, value);
            return;
        }
        NBTHelper.putBoolean(stack.m_41698_(parentKey), key, value);
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        NBTHelper.putBoolean(stack.m_41784_(), key, value);
    }

    public static <T extends Enum<T>> void setEnumConstant(ItemStack stack, String parentKey, String key, T enumConstant) {
        if (parentKey.isEmpty()) {
            NBTHelper.setEnumConstant(stack, key, enumConstant);
            return;
        }
        NBTHelper.putEnumConstant(stack.m_41698_(parentKey), key, enumConstant);
    }

    public static <T extends Enum<T>> void setEnumConstant(ItemStack stack, String key, T enumConstant) {
        NBTHelper.putEnumConstant(stack.m_41784_(), key, enumConstant);
    }

    public static CompoundTag putBoolean(CompoundTag tag, String key, boolean value) {
        tag.m_128379_(key, value);
        return tag;
    }

    public static CompoundTag putInt(CompoundTag tag, String key, int value) {
        tag.m_128405_(key, value);
        return tag;
    }

    public static CompoundTag putString(CompoundTag tag, String key, String value) {
        tag.m_128359_(key, value);
        return tag;
    }

    public static <T extends Enum<T>> CompoundTag putEnumConstant(CompoundTag tag, String key, T enumConstant) {
        tag.m_128359_(key, ((StringRepresentable)enumConstant).m_7912_());
        return tag;
    }

    public static void setLong(ItemStack stack, String key, long value) {
        stack.m_41784_().m_128356_(key, value);
    }

    public static void setInteger(ItemStack stack, String key, int value) {
        stack.m_41784_().m_128405_(key, value);
    }

    public static void setUniqueId(ItemStack stack, String key, UUID uuid) {
        stack.m_41784_().m_128385_(key, UUIDUtil.m_235881_((UUID)uuid));
    }

    public static void removeTag(ItemStack stack, String key) {
        if (stack.m_41783_() == null) {
            return;
        }
        stack.m_41783_().m_128473_(key);
    }

    public static Optional<Component> getComponent(CompoundTag tag, String key) {
        return NBTHelper.getTagValue(tag, key, (CompoundTag t, String k) -> Component.Serializer.m_130701_((String)t.m_128461_(k)));
    }

    public static Optional<String> getString(CompoundTag tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundTag::m_128461_);
    }

    public static Optional<String> getString(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundTag::m_128461_);
    }

    public static Optional<Float> getFloat(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundTag::m_128457_);
    }

    public static <K, V> Optional<Map<K, V>> getMap(CompoundTag tag, String key, Function<String, K> getKey, BiFunction<String, Tag, Optional<V>> getValue) {
        CompoundTag mapNbt = tag.m_128469_(key);
        HashMap map = new HashMap();
        for (String tagName : mapNbt.m_128431_()) {
            getValue.apply(tagName, mapNbt.m_128423_(tagName)).ifPresent(value -> map.put(getKey.apply(tagName), value));
        }
        return Optional.of(map);
    }

    public static <K, V> CompoundTag putMap(CompoundTag tag, String key, Map<K, V> map, Function<K, String> getStringKey, Function<V, Tag> getNbtValue) {
        CompoundTag mapNbt = new CompoundTag();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            mapNbt.m_128365_(getStringKey.apply(entry.getKey()), getNbtValue.apply(entry.getValue()));
        }
        tag.m_128365_(key, (Tag)mapNbt);
        return tag;
    }

    public static <T> void setList(ItemStack stack, String parentKey, String key, Collection<T> values, Function<T, Tag> getNbtValue) {
        ListTag list = new ListTag();
        values.forEach(v -> list.add((Object)((Tag)getNbtValue.apply(v))));
        if (parentKey.isEmpty()) {
            stack.m_41784_().m_128365_(key, (Tag)list);
        } else {
            stack.m_41698_(parentKey).m_128365_(key, (Tag)list);
        }
    }

    public static <T> void putList(CompoundTag tag, String key, Collection<T> values, Function<T, Tag> getNbtValue) {
        ListTag list = new ListTag();
        values.forEach(v -> list.add((Object)((Tag)getNbtValue.apply(v))));
        tag.m_128365_(key, (Tag)list);
    }
}

