/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.client.gui.IButtonFactory;
import net.p3pp3rf1y.sophisticatedcore.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.ISlotDecorationRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeGuiManager;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTabControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.InventoryScrollPanel;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.TransferFullSlotMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.ICraftingUIPart;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import org.joml.Matrix4f;

public abstract class StorageScreenBase<S extends StorageContainerMenuBase<?>>
extends AbstractContainerScreen<S>
implements InventoryScrollPanel.IInventoryScreen {
    public static final int ERROR_BACKGROUND_COLOR = -267386864;
    public static final int ERROR_BORDER_COLOR = ColorHelper.getColor(DyeColor.RED.m_41068_()) | 0xFF000000;
    private static final int DISABLED_SLOT_COLOR = -1072689136;
    private static final int UPGRADE_TOP_HEIGHT = 7;
    private static final int UPGRADE_SLOT_HEIGHT = 16;
    private static final int UPGRADE_BOTTOM_HEIGHT = 6;
    public static final int UPGRADE_INVENTORY_OFFSET = 21;
    public static final int DISABLED_SLOT_X_POS = -1000;
    static final int SLOTS_Y_OFFSET = 17;
    static final int SLOTS_X_OFFSET = 7;
    public static final int ERROR_SLOT_COLOR = ColorHelper.getColor(DyeColor.RED.m_41068_()) | 0xAA000000;
    private static final int ERROR_TEXT_COLOR = ColorHelper.getColor(DyeColor.RED.m_41068_());
    public static final int HEIGHT_WITHOUT_STORAGE_SLOTS = 114;
    private UpgradeSettingsTabControl settingsTabControl = new UpgradeSettingsTabControl(new Position(0, 0), this, "");
    private final int numberOfUpgradeSlots;
    @Nullable
    private Button sortButton = null;
    @Nullable
    private ToggleButton<SortBy> sortByButton = null;
    private InventoryScrollPanel inventoryScrollPanel = null;
    private final Set<ToggleButton<Boolean>> upgradeSwitches = new HashSet<ToggleButton<Boolean>>();
    private final Map<Integer, UpgradeInventoryPartBase<?>> inventoryParts = new LinkedHashMap();
    private static ICraftingUIPart craftingUIPart = ICraftingUIPart.NOOP;
    private static ISlotDecorationRenderer slotDecorationRenderer = (guiGraphics, slot) -> {};
    private StorageBackgroundProperties storageBackgroundProperties;
    private static final Set<IButtonFactory> buttonFactories = new HashSet<IButtonFactory>();

    public static void setCraftingUIPart(ICraftingUIPart part) {
        craftingUIPart = part;
    }

    public static void setSlotDecorationRenderer(ISlotDecorationRenderer renderer) {
        slotDecorationRenderer = renderer;
    }

    public static void addButtonFactory(IButtonFactory buttonFactory) {
        buttonFactories.add(buttonFactory);
    }

    protected StorageScreenBase(S pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.numberOfUpgradeSlots = ((StorageContainerMenuBase)this.m_6262_()).getNumberOfUpgradeSlots();
        this.updateDimensionsAndSlotPositions(Minecraft.m_91087_().m_91268_().m_85446_());
    }

    public ICraftingUIPart getCraftingUIAddition() {
        return craftingUIPart;
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        this.updateDimensionsAndSlotPositions(pHeight);
        super.m_6574_(pMinecraft, pWidth, pHeight);
    }

    private void updateDimensionsAndSlotPositions(int pHeight) {
        int displayableNumberOfRows = Math.min((pHeight - 114) / 18, ((StorageContainerMenuBase)this.m_6262_()).getNumberOfRows());
        int newImageHeight = 114 + this.getStorageInventoryHeight(displayableNumberOfRows);
        this.storageBackgroundProperties = ((StorageContainerMenuBase)this.m_6262_()).getNumberOfStorageInventorySlots() + ((StorageContainerMenuBase)this.m_6262_()).getColumnsTaken() * ((StorageContainerMenuBase)this.m_6262_()).getNumberOfRows() <= 81 ? StorageBackgroundProperties.REGULAR_9_SLOT : StorageBackgroundProperties.REGULAR_12_SLOT;
        this.f_97726_ = this.storageBackgroundProperties.getSlotsOnLine() * 18 + 14;
        this.updateStorageSlotsPositions();
        if (displayableNumberOfRows < ((StorageContainerMenuBase)this.m_6262_()).getNumberOfRows()) {
            this.storageBackgroundProperties = this.storageBackgroundProperties == StorageBackgroundProperties.REGULAR_9_SLOT ? StorageBackgroundProperties.WIDER_9_SLOT : StorageBackgroundProperties.WIDER_12_SLOT;
            this.f_97726_ += 6;
        }
        this.f_97727_ = newImageHeight;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8 + this.storageBackgroundProperties.getPlayerInventoryXOffset();
        this.updatePlayerSlotsPositions();
        this.updateUpgradeSlotsPositions();
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return displayableNumberOfRows * 18;
    }

    @Override
    public Slot getSlot(int slotIndex) {
        return ((StorageContainerMenuBase)this.m_6262_()).m_38853_(slotIndex);
    }

    private void updateUpgradeSlotsPositions() {
        int yPosition = 6;
        for (int slotIndex = 0; slotIndex < this.numberOfUpgradeSlots; ++slotIndex) {
            Slot slot = ((StorageContainerMenuBase)this.m_6262_()).m_38853_(((StorageContainerMenuBase)this.m_6262_()).getFirstUpgradeSlot() + slotIndex);
            slot.f_40221_ = yPosition;
            yPosition += 16;
        }
    }

    protected void updateStorageSlotsPositions() {
        int yPosition = 18;
        int slotIndex = 0;
        while (slotIndex < ((StorageContainerMenuBase)this.m_6262_()).getNumberOfStorageInventorySlots()) {
            Slot slot = ((StorageContainerMenuBase)this.m_6262_()).m_38853_(slotIndex);
            int lineIndex = slotIndex % this.getSlotsOnLine();
            slot.f_40220_ = 8 + lineIndex * 18;
            slot.f_40221_ = yPosition;
            if (++slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    protected void updatePlayerSlotsPositions() {
        int playerInventoryXOffset = this.storageBackgroundProperties.getPlayerInventoryXOffset();
        int yPosition = this.f_97731_ + 12;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9;
                int xPosition = playerInventoryXOffset + 8 + j * 18;
                Slot slot = ((StorageContainerMenuBase)this.m_6262_()).m_38853_(((StorageContainerMenuBase)this.m_6262_()).getInventorySlotsSize() - 36 + slotIndex);
                slot.f_40220_ = xPosition;
                slot.f_40221_ = yPosition;
            }
            yPosition += 18;
        }
        yPosition += 4;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int xPosition = playerInventoryXOffset + 8 + slotIndex * 18;
            Slot slot = ((StorageContainerMenuBase)this.m_6262_()).m_38853_(((StorageContainerMenuBase)this.m_6262_()).getInventorySlotsSize() - 36 + 27 + slotIndex);
            slot.f_40220_ = xPosition;
            slot.f_40221_ = yPosition;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateInventoryScrollPanel();
        craftingUIPart.setStorageScreen(this);
        this.initUpgradeSettingsControl();
        this.initUpgradeInventoryParts();
        this.addUpgradeSwitches();
        ((StorageContainerMenuBase)this.m_6262_()).setUpgradeChangeListener(c -> {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateUpgradeSlotsPositions();
            this.updateInventoryScrollPanel();
            this.m_6702_().remove(this.settingsTabControl);
            craftingUIPart.onCraftingSlotsHidden();
            this.initUpgradeSettingsControl();
            this.initUpgradeInventoryParts();
            this.addUpgradeSwitches();
        });
        if (this.shouldShowSortButtons()) {
            this.addSortButtons();
        }
        this.addAdditionalButtons();
    }

    protected boolean shouldShowSortButtons() {
        return true;
    }

    private void addAdditionalButtons() {
        buttonFactories.forEach(factory -> this.m_142416_((GuiEventListener)factory.instantiateButton(this)));
    }

    private void updateInventoryScrollPanel() {
        int numberOfVisibleRows;
        if (this.inventoryScrollPanel != null) {
            this.m_169411_((GuiEventListener)this.inventoryScrollPanel);
        }
        if ((numberOfVisibleRows = this.getNumberOfVisibleRows()) < ((StorageContainerMenuBase)this.m_6262_()).getNumberOfRows()) {
            this.inventoryScrollPanel = new InventoryScrollPanel(Minecraft.m_91087_(), this, 0, ((StorageContainerMenuBase)this.m_6262_()).getNumberOfStorageInventorySlots(), this.getSlotsOnLine(), numberOfVisibleRows * 18, this.getGuiTop() + 17, this.getGuiLeft() + 7);
            this.m_142416_((GuiEventListener)this.inventoryScrollPanel);
            this.inventoryScrollPanel.updateSlotsYPosition();
        } else {
            this.inventoryScrollPanel = null;
        }
    }

    private int getNumberOfVisibleRows() {
        return Math.min((this.f_97727_ - 114) / 18, ((StorageContainerMenuBase)this.m_6262_()).getNumberOfRows());
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - ((StorageContainerMenuBase)this.m_6262_()).getColumnsTaken();
    }

    private void initUpgradeInventoryParts() {
        this.inventoryParts.clear();
        if (((StorageContainerMenuBase)this.m_6262_()).getColumnsTaken() == 0) {
            return;
        }
        int numberOfVisibleRows = this.getNumberOfVisibleRows();
        int scrollBarOffset = numberOfVisibleRows < ((StorageContainerMenuBase)this.m_6262_()).getNumberOfRows() ? 6 : 0;
        AtomicReference<Position> pos = new AtomicReference<Position>(new Position(7 + this.getSlotsOnLine() * 18 + scrollBarOffset, 17));
        int height = numberOfVisibleRows * 18;
        for (Map.Entry<Integer, UpgradeContainerBase<?, ?>> entry : ((StorageContainerMenuBase)this.m_6262_()).getUpgradeContainers().entrySet()) {
            UpgradeContainerBase<?, ?> container = entry.getValue();
            UpgradeGuiManager.getInventoryPart(entry.getKey(), container, pos.get(), height, this).ifPresent(part -> {
                this.inventoryParts.put((Integer)entry.getKey(), (UpgradeInventoryPartBase<?>)part);
                pos.set(new Position(((Position)pos.get()).x() + 36, ((Position)pos.get()).y()));
            });
        }
    }

    private void addUpgradeSwitches() {
        this.upgradeSwitches.clear();
        int switchTop = this.f_97736_ + 8;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.f_97732_).canDisableUpgrade(slot)) {
                int finalSlot = slot;
                ToggleButton<Boolean> upgradeSwitch = new ToggleButton<Boolean>(new Position(this.f_97735_ - 22, switchTop), ButtonDefinitions.UPGRADE_SWITCH, button -> ((StorageContainerMenuBase)this.m_6262_()).setUpgradeEnabled(finalSlot, !((StorageContainerMenuBase)this.m_6262_()).getUpgradeEnabled(finalSlot)), () -> ((StorageContainerMenuBase)this.m_6262_()).getUpgradeEnabled(finalSlot));
                this.m_7787_(upgradeSwitch);
                this.upgradeSwitches.add(upgradeSwitch);
            }
            switchTop += 16;
        }
    }

    private void addSortButtons() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        if (sortButtonsPosition == SortButtonsPosition.HIDDEN) {
            return;
        }
        Position pos = this.getSortButtonsPosition(sortButtonsPosition);
        this.sortButton = new Button(new Position(pos.x(), pos.y()), ButtonDefinitions.SORT, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.m_6262_()).sort();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"Sorted"), true);
            }
        });
        this.m_7787_(this.sortButton);
        this.sortByButton = new ToggleButton<SortBy>(new Position(pos.x() + 14, pos.y()), ButtonDefinitions.SORT_BY, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.m_6262_()).setSortBy(((StorageContainerMenuBase)this.m_6262_()).getSortBy().next());
            }
        }, () -> ((StorageContainerMenuBase)this.m_6262_()).getSortBy());
        this.m_7787_(this.sortByButton);
    }

    private Position getSortButtonsPosition(SortButtonsPosition sortButtonsPosition) {
        return switch (sortButtonsPosition) {
            case SortButtonsPosition.BELOW_UPGRADES -> new Position(this.f_97735_ - 21 - 2, this.f_97736_ + this.getUpgradeHeightWithoutBottom() + 6 + 2);
            case SortButtonsPosition.BELOW_UPGRADE_TABS -> new Position(this.settingsTabControl.getX() + 2, this.settingsTabControl.getY() + Math.max(0, this.settingsTabControl.getHeight() + 2));
            default -> new Position(this.f_97735_ + this.f_97726_ - 34, this.f_97736_ + 4);
        };
    }

    private void initUpgradeSettingsControl() {
        this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.f_97735_ + this.f_97726_, this.f_97736_ + 4), this, this.getStorageSettingsTabTooltip());
        this.m_7787_(this.settingsTabControl);
    }

    protected abstract String getStorageSettingsTabTooltip();

    public int getUpgradeHeight() {
        return this.getUpgradeHeightWithoutBottom() + 7;
    }

    protected int getUpgradeHeightWithoutBottom() {
        return 6 + this.numberOfUpgradeSlots * 16;
    }

    public Optional<Rect2i> getSortButtonsRectangle() {
        if (this.sortButton == null || this.sortByButton == null) {
            return Optional.empty();
        }
        return GuiHelper.getPositiveRectangle(this.sortButton.getX(), this.sortButton.getY(), this.sortByButton.getX() + this.sortByButton.getWidth() - this.sortButton.getX(), this.sortByButton.getY() + this.sortByButton.getHeight() - this.sortButton.getY());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        if (((StorageContainerMenuBase)this.f_97732_).detectSettingsChangeAndReload()) {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateInventoryScrollPanel();
        }
        this.m_280273_(guiGraphics);
        this.settingsTabControl.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        poseStack.m_85836_();
        this.renderSuper(guiGraphics, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((Screen)this, guiGraphics, mouseX, mouseY);
        if (this.sortButton != null && this.sortByButton != null) {
            this.sortButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.sortByButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.upgradeSwitches.forEach(us -> us.m_88315_(guiGraphics, mouseX, mouseY, partialTicks));
        this.renderErrorOverlay(guiGraphics);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        poseStack.m_85849_();
    }

    private void renderSuper(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        ItemStack itemstack;
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_7286_(guiGraphics, pPartialTick, pMouseX, pMouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, pMouseX, pMouseY));
        RenderSystem.disableDepthTest();
        this.f_97734_ = null;
        for (Renderable widget : this.f_169369_) {
            widget.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)i, (double)j, 0.0);
        for (int k = 0; k < 36; ++k) {
            Slot slot = ((StorageContainerMenuBase)this.m_6262_()).m_38853_(((StorageContainerMenuBase)this.m_6262_()).getInventorySlotsSize() - 36 + k);
            if (slot.m_6659_()) {
                this.m_280092_(guiGraphics, slot);
            }
            if (!this.m_97774_(slot, pMouseX, pMouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            int l = slot.f_40220_;
            int i1 = slot.f_40221_;
            StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)l, (int)i1, (int)0, (int)this.getSlotColor(k));
        }
        this.m_280003_(guiGraphics, pMouseX, pMouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, pMouseX, pMouseY));
        ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((StorageContainerMenuBase)this.f_97732_).m_142621_() : this.f_97711_;
        if (!itemstack.m_41619_()) {
            int i2 = this.f_97711_.m_41619_() ? 8 : 16;
            String s = null;
            if (!this.f_97711_.m_41619_() && this.f_97710_) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(Mth.m_14167_((float)((float)itemstack.m_41613_() / 2.0f)));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(this.f_97720_);
                if (itemstack.m_41619_()) {
                    s = ChatFormatting.YELLOW + "0";
                }
            }
            this.m_280211_(guiGraphics, itemstack, pMouseX - i - 8, pMouseY - j - i2, s);
        }
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        this.renderUpgradeInventoryParts(guiGraphics, mouseX, mouseY);
        this.renderUpgradeSlots(guiGraphics, mouseX, mouseY);
        if (this.inventoryScrollPanel == null) {
            this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderUpgradeInventoryParts(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.inventoryParts.values().forEach(ip -> ip.render(guiGraphics, mouseX, mouseY));
    }

    private void renderStorageInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY, true);
    }

    private void renderStorageInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.size(); ++slotId) {
            Slot slot = ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.get(slotId);
            this.m_280092_(guiGraphics, slot);
            if (!canShowHover || !this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.f_40220_, (int)slot.f_40221_, (int)0, (int)this.getSlotColor(slotId));
        }
    }

    private void renderUpgradeSlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.size(); ++slotId) {
            Slot slot = ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.get(slotId);
            if (slot.f_40220_ != -1000) {
                this.m_280092_(guiGraphics, slot);
                if (!slot.m_6659_()) {
                    this.renderSlotOverlay(guiGraphics, slot, -1072689136);
                }
            }
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.f_40220_, (int)slot.f_40221_, (int)0, (int)this.getSlotColor(slotId));
        }
    }

    protected void m_280092_(GuiGraphics guiGraphics, Slot slot) {
        int i = slot.f_40220_;
        int j = slot.f_40221_;
        ItemStack stackToRender = slot.m_7993_();
        boolean flag = false;
        boolean rightClickDragging = slot == this.f_97706_ && !this.f_97711_.m_41619_() && !this.f_97710_;
        ItemStack carriedStack = ((StorageContainerMenuBase)this.m_6262_()).m_142621_();
        String stackCountText = null;
        if (slot == this.f_97706_ && !this.f_97711_.m_41619_() && this.f_97710_ && !stackToRender.m_41619_()) {
            stackToRender = stackToRender.m_41777_();
            stackToRender.m_41764_(stackToRender.m_41613_() / 2);
        } else if (this.f_97738_ && this.f_97737_.contains(slot) && !carriedStack.m_41619_()) {
            if (this.f_97737_.size() == 1) {
                return;
            }
            if (StorageContainerMenuBase.canItemQuickReplace(slot, carriedStack) && ((StorageContainerMenuBase)this.f_97732_).m_5622_(slot)) {
                int slotLimit;
                flag = true;
                int slotStackCount = stackToRender.m_41619_() ? 0 : stackToRender.m_41613_();
                int renderCount = AbstractContainerMenu.m_278794_((Set)this.f_97737_, (int)this.f_97717_, (ItemStack)carriedStack) + slotStackCount;
                if (renderCount > (slotLimit = slot.m_5866_(stackToRender))) {
                    stackCountText = ChatFormatting.YELLOW + CountAbbreviator.abbreviate(slotLimit);
                }
                stackToRender = carriedStack.m_255036_(renderCount);
            } else {
                this.f_97737_.remove(slot);
                this.m_97818_();
            }
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        if (stackToRender.m_41619_() && slot.m_6659_()) {
            this.renderSlotBackground(guiGraphics, slot, i, j);
        } else if (!rightClickDragging) {
            this.renderStack(guiGraphics, i, j, stackToRender, flag, stackCountText);
            slotDecorationRenderer.renderDecoration(guiGraphics, slot);
        }
        poseStack.m_85849_();
    }

    private void renderStack(GuiGraphics guiGraphics, int x, int y, ItemStack itemstack, boolean flag, @Nullable String stackCountText) {
        if (flag) {
            guiGraphics.m_280509_(x, y, x + 16, y + 16, -2130706433);
        }
        RenderSystem.enableDepthTest();
        guiGraphics.m_280480_(itemstack, x, y);
        if (this.shouldUseSpecialCountRender(itemstack)) {
            guiGraphics.m_280302_(this.f_96547_, itemstack, x, y, "");
            if (stackCountText == null) {
                stackCountText = CountAbbreviator.abbreviate(itemstack.m_41613_());
            }
            this.renderStackCount(guiGraphics, stackCountText, x, y);
        } else {
            guiGraphics.m_280302_(this.f_96547_, itemstack, x, y, stackCountText);
        }
    }

    private void renderSlotBackground(GuiGraphics guiGraphics, Slot slot, int i, int j) {
        Optional<ItemStack> memorizedStack = ((StorageContainerMenuBase)this.m_6262_()).getMemorizedStackInSlot(slot.f_40219_);
        if (memorizedStack.isPresent()) {
            guiGraphics.m_280480_(memorizedStack.get(), i, j);
            this.drawStackOverlay(guiGraphics, i, j);
        } else if (!((StorageContainerMenuBase)this.m_6262_()).getSlotFilterItem(slot.f_40219_).m_41619_()) {
            guiGraphics.m_280480_(((StorageContainerMenuBase)this.m_6262_()).getSlotFilterItem(slot.f_40219_), i, j);
            this.drawStackOverlay(guiGraphics, i, j);
        } else {
            Pair pair = slot.m_7543_();
            if (pair != null) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
                guiGraphics.m_280159_(i, j, 0, 16, 16, textureatlassprite);
            }
        }
    }

    private void drawStackOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        guiGraphics.m_280218_(GuiHelper.GUI_CONTROLS, x, y, 77, 0, 16, 16);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        guiGraphics.m_280168_().m_85849_();
    }

    private boolean shouldUseSpecialCountRender(ItemStack itemstack) {
        return itemstack.m_41613_() > 99;
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor) {
        this.renderSlotOverlay(guiGraphics, slot, slotColor, 0, 16);
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor, int yOffset, int height) {
        this.renderOverlay(guiGraphics, slotColor, slot.f_40220_, slot.f_40221_ + yOffset, 16, height);
    }

    public void renderOverlay(GuiGraphics guiGraphics, int slotColor, int xPos, int yPos, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.m_280120_(xPos, yPos, xPos + width, yPos + height, 0, slotColor, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.drawInventoryBg(guiGraphics, x, y, this.storageBackgroundProperties.getTextureName());
        if (this.inventoryScrollPanel == null) {
            this.drawSlotBg(guiGraphics, x, y);
            this.drawSlotOverlays(guiGraphics);
        }
        this.drawUpgradeBackground(guiGraphics);
    }

    protected void drawSlotBg(GuiGraphics guiGraphics, int x, int y) {
        int inventorySlots = ((StorageContainerMenuBase)this.m_6262_()).getNumberOfStorageInventorySlots();
        int slotsOnLine = this.getSlotsOnLine();
        int slotRows = inventorySlots / slotsOnLine;
        int remainingSlots = inventorySlots % slotsOnLine;
        GuiHelper.renderSlotsBackground(guiGraphics, x + 7, y + 17, slotsOnLine, slotRows, remainingSlots);
    }

    private void drawSlotOverlays(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
        for (int slotNumber = 0; slotNumber < ((StorageContainerMenuBase)this.f_97732_).getNumberOfStorageInventorySlots(); ++slotNumber) {
            List<Integer> colors = ((StorageContainerMenuBase)this.f_97732_).getSlotOverlayColors(slotNumber);
            if (colors.isEmpty()) continue;
            int stripeHeight = 16 / colors.size();
            int i = 0;
            for (int slotColor : colors) {
                int yOffset = i * stripeHeight;
                this.renderSlotOverlay(guiGraphics, ((StorageContainerMenuBase)this.f_97732_).m_38853_(slotNumber), slotColor | 0x50000000, yOffset, i == colors.size() - 1 ? 16 - yOffset : stripeHeight);
                ++i;
            }
        }
        poseStack.m_85849_();
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        this.inventoryParts.values().forEach(part -> part.renderTooltip(this, guiGraphics, x, y));
        if (((StorageContainerMenuBase)this.m_6262_()).m_142621_().m_41619_() && this.f_97734_ != null) {
            if (this.f_97734_.m_6657_()) {
                guiGraphics.m_280153_(this.f_96547_, this.f_97734_.m_7993_(), x, y);
            } else {
                INameableEmptySlot emptySlot;
                Slot slot = this.f_97734_;
                if (slot instanceof INameableEmptySlot && (emptySlot = (INameableEmptySlot)slot).hasEmptyTooltip()) {
                    guiGraphics.m_280666_(this.f_96547_, Collections.singletonList(emptySlot.getEmptyTooltip()), x, y);
                }
            }
        }
        if (this.sortButton != null) {
            this.sortButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
        if (this.sortByButton != null) {
            this.sortByButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
    }

    protected List<Component> m_280553_(ItemStack itemStack) {
        List ret = super.m_280553_(itemStack);
        if (itemStack.m_41613_() > 999) {
            ret.add(Component.m_237110_((String)"gui.sophisticatedcore.tooltip.stack_count", (Object[])new Object[]{Component.m_237113_((String)NumberFormat.getNumberInstance().format(itemStack.m_41613_())).m_130940_(ChatFormatting.DARK_AQUA)}).m_130940_(ChatFormatting.GRAY));
        }
        return ret;
    }

    public void drawInventoryBg(GuiGraphics guiGraphics, int x, int y, ResourceLocation textureName) {
        StorageGuiHelper.renderStorageBackground(new Position(x, y), guiGraphics, textureName, this.f_97726_, this.f_97727_ - 114);
    }

    private void drawUpgradeBackground(GuiGraphics guiGraphics) {
        if (this.numberOfUpgradeSlots == 0) {
            return;
        }
        int heightWithoutBottom = this.getUpgradeHeightWithoutBottom();
        guiGraphics.m_280163_(GuiHelper.GUI_CONTROLS, this.f_97735_ - 21, this.f_97736_, 0.0f, 0.0f, 26, 4, 256, 256);
        guiGraphics.m_280163_(GuiHelper.GUI_CONTROLS, this.f_97735_ - 21, this.f_97736_ + 4, 0.0f, 4.0f, 25, heightWithoutBottom - 4, 256, 256);
        guiGraphics.m_280163_(GuiHelper.GUI_CONTROLS, this.f_97735_ - 21, this.f_97736_ + heightWithoutBottom, 0.0f, 198.0f, 25, 6, 256, 256);
        boolean previousHasSwitch = false;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.f_97732_).canDisableUpgrade(slot)) {
                int y = this.f_97736_ + 5 + slot * 16 + (previousHasSwitch ? 1 : 0);
                guiGraphics.m_280163_(GuiHelper.GUI_CONTROLS, this.f_97735_ - 21 - 4, y, 0.0f, (float)(204 + (previousHasSwitch ? 1 : 0)), 7, 18 - (previousHasSwitch ? 1 : 0), 256, 256);
                previousHasSwitch = true;
                continue;
            }
            previousHasSwitch = false;
        }
    }

    public UpgradeSettingsTabControl getUpgradeSettingsControl() {
        return this.settingsTabControl;
    }

    @Nullable
    public Slot m_97744_(double mouseX, double mouseY) {
        Slot slot;
        int i;
        for (i = 0; i < ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        if (this.inventoryScrollPanel != null) {
            Optional<Slot> result = this.inventoryScrollPanel.findSlot(mouseX, mouseY);
            if (result.isPresent()) {
                return result.get();
            }
            slot = super.m_97744_(mouseX, mouseY);
            return slot == null || ((StorageContainerMenuBase)this.f_97732_).isStorageInventorySlot(slot.f_40219_) ? null : slot;
        }
        for (i = 0; i < ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return super.m_97744_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (UpgradeInventoryPartBase<?> inventoryPart : this.inventoryParts.values()) {
            if (!inventoryPart.handleMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        this.handleQuickMoveAll(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void handleQuickMoveAll(double mouseX, double mouseY, int button) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (this.f_97723_ && !((StorageContainerMenuBase)this.m_6262_()).m_142621_().m_41619_() && slot != null && button == 0 && ((StorageContainerMenuBase)this.f_97732_).m_5882_(ItemStack.f_41583_, slot) && StorageScreenBase.m_96638_() && !this.f_97724_.m_41619_()) {
            for (Slot slot2 : ((StorageContainerMenuBase)this.f_97732_).realInventorySlots) {
                this.tryQuickMoveSlot(button, slot, slot2);
            }
        }
    }

    private void tryQuickMoveSlot(int button, Slot slot, Slot slot2) {
        ItemStack slotItem;
        if (slot2.m_8010_((Player)this.f_96541_.f_91074_) && slot2.m_6657_() && slot2.isSameInventory(slot) && ItemStack.m_150942_((ItemStack)this.f_97724_, (ItemStack)(slotItem = slot2.m_7993_()))) {
            if (slotItem.m_41613_() > slotItem.m_41741_()) {
                PacketHandler.INSTANCE.sendToServer(new TransferFullSlotMessage(slot2.f_40219_));
            } else {
                this.m_6597_(slot2, slot2.f_40219_, button, ClickType.QUICK_MOVE);
            }
        }
    }

    protected void m_6597_(Slot slot, int slotNumber, int mouseButton, ClickType type) {
        if (type == ClickType.PICKUP_ALL && !((StorageContainerMenuBase)this.f_97732_).getSlotUpgradeContainer(slot).map(c -> c.allowsPickupAll(slot)).orElse(true).booleanValue()) {
            type = ClickType.PICKUP;
        }
        this.handleInventoryMouseClick(slotNumber, mouseButton, type);
    }

    private void handleInventoryMouseClick(int slotNumber, int mouseButton, ClickType type) {
        ItemStack itemstack;
        int lastChecked;
        ItemStack slotStack;
        ItemStack itemstack2;
        int i;
        StorageContainerMenuBase menu = (StorageContainerMenuBase)this.m_6262_();
        ArrayList realInventoryItems = new ArrayList(menu.realInventorySlots.size());
        menu.realInventorySlots.forEach(slot -> realInventoryItems.add(slot.m_7993_().m_41777_()));
        ArrayList upgradeItems = new ArrayList(menu.upgradeSlots.size());
        menu.upgradeSlots.forEach(slot -> upgradeItems.add(slot.m_7993_().m_41777_()));
        menu.m_150399_(slotNumber, mouseButton, type, (Player)this.f_96541_.f_91074_);
        Int2ObjectOpenHashMap changedSlotIndexes = new Int2ObjectOpenHashMap();
        int inventorySlotsToCheck = Math.min(realInventoryItems.size() - 36, menu.getInventorySlotsSize() - 36);
        for (i = 0; i < inventorySlotsToCheck; ++i) {
            ItemStack slotStack2;
            itemstack2 = (ItemStack)realInventoryItems.get(i);
            if (ItemStack.m_41728_((ItemStack)itemstack2, (ItemStack)(slotStack2 = menu.m_38853_(i).m_7993_()))) continue;
            changedSlotIndexes.put(i, (Object)slotStack2.m_41777_());
        }
        for (i = 0; i < 36; ++i) {
            int slotIndex;
            itemstack2 = (ItemStack)realInventoryItems.get(realInventoryItems.size() - 36 + i);
            if (ItemStack.m_41728_((ItemStack)itemstack2, (ItemStack)(slotStack = menu.m_38853_(slotIndex = menu.getInventorySlotsSize() - 36 + i).m_7993_()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack.m_41777_());
        }
        int upgradeSlotsToCheck = Math.min(menu.getUpgradeSlotsSize(), upgradeItems.size());
        for (lastChecked = 0; lastChecked < upgradeSlotsToCheck && ItemStack.m_41728_((ItemStack)(itemstack = (ItemStack)upgradeItems.get(lastChecked)), (ItemStack)(slotStack = menu.m_38853_(menu.getInventorySlotsSize() + lastChecked).m_7993_())); ++lastChecked) {
        }
        for (int i2 = upgradeSlotsToCheck - 1; i2 >= lastChecked; --i2) {
            int slotIndex;
            ItemStack slotStack3;
            ItemStack itemstack3 = (ItemStack)upgradeItems.get(i2);
            if (ItemStack.m_41728_((ItemStack)itemstack3, (ItemStack)(slotStack3 = menu.m_38853_(slotIndex = menu.getInventorySlotsSize() + i2).m_7993_()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack3.m_41777_());
        }
        this.f_96541_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundContainerClickPacket(menu.f_38840_, menu.m_182424_(), slotNumber, mouseButton, type, menu.m_142621_().m_41777_(), (Int2ObjectMap)changedSlotIndexes));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (StorageScreenBase.m_96638_() && StorageScreenBase.m_96637_() && slot instanceof StorageInventorySlot && button == 0) {
            PacketHandler.INSTANCE.sendToServer(new TransferFullSlotMessage(slot.f_40219_));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        Slot slot = this.m_97744_(mouseX, mouseY);
        ItemStack itemstack = ((StorageContainerMenuBase)this.m_6262_()).m_142621_();
        if (this.f_97738_ && slot != null && !itemstack.m_41619_() && (itemstack.m_41613_() > this.f_97737_.size() || this.f_97717_ == 2) && StorageContainerMenuBase.canItemQuickReplace(slot, itemstack) && slot.m_5857_(itemstack) && ((StorageContainerMenuBase)this.f_97732_).m_5622_(slot)) {
            this.f_97737_.add(slot);
            this.m_97818_();
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfUpgradeSlots(mouseX, mouseY) && this.hasClickedOutsideOfUpgradeSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfUpgradeSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.m_110087_((int)mouseX, (int)mouseY));
    }

    private boolean hasClickedOutsideOfUpgradeSlots(double mouseX, double mouseY) {
        return this.getUpgradeSlotsRectangle().map(r -> r.m_110087_((int)mouseX, (int)mouseY)).orElse(false) == false;
    }

    public Optional<Rect2i> getUpgradeSlotsRectangle() {
        return this.numberOfUpgradeSlots == 0 ? Optional.empty() : GuiHelper.getPositiveRectangle(this.f_97735_ - 21 + 4, this.f_97736_, 25, this.getUpgradeHeight());
    }

    private void renderStackCount(GuiGraphics guiGraphics, String count, int x, int y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 200.0);
        float scale = Math.min(1.0f, 16.0f / (float)this.f_96547_.m_92895_(count));
        if (scale < 1.0f) {
            poseStack.m_85841_(scale, scale, 1.0f);
        }
        MultiBufferSource.BufferSource renderBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.f_96547_.m_271703_(count, ((float)(x + 19 - 2) - (float)this.f_96547_.m_92895_(count) * scale) / scale, ((float)(y + 6 + 3) + (1.0f / (scale * scale) - 1.0f)) / scale, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)renderBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        renderBuffer.m_109911_();
        poseStack.m_85849_();
    }

    protected void m_97818_() {
        ItemStack carriedStack = ((StorageContainerMenuBase)this.m_6262_()).m_142621_();
        if (!carriedStack.m_41619_() && this.f_97738_) {
            if (this.f_97717_ == 2) {
                this.f_97720_ = carriedStack.m_41741_();
            } else {
                this.f_97720_ = carriedStack.m_41613_();
                for (Slot slot : this.f_97737_) {
                    ItemStack slotStack = slot.m_7993_();
                    int slotStackCount = slotStack.m_41619_() ? 0 : slotStack.m_41613_();
                    int maxStackSize = slot.m_5866_(carriedStack);
                    int quickCraftPlaceCount = Math.min(AbstractContainerMenu.m_278794_((Set)this.f_97737_, (int)this.f_97717_, (ItemStack)carriedStack) + slotStackCount, maxStackSize);
                    this.f_97720_ -= quickCraftPlaceCount - slotStackCount;
                }
            }
        }
    }

    private void renderErrorOverlay(GuiGraphics guiGraphics) {
        ((StorageContainerMenuBase)this.f_97732_).getErrorUpgradeSlotChangeResult().ifPresent(upgradeSlotChangeResult -> upgradeSlotChangeResult.getErrorMessage().ifPresent(overlayErrorMessage -> {
            RenderSystem.disableDepthTest();
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
            upgradeSlotChangeResult.getErrorUpgradeSlots().forEach(slotIndex -> {
                Slot upgradeSlot = ((StorageContainerMenuBase)this.f_97732_).m_38853_(((StorageContainerMenuBase)this.f_97732_).getFirstUpgradeSlot() + slotIndex);
                StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)upgradeSlot.f_40220_, (int)upgradeSlot.f_40221_, (int)0, (int)ERROR_SLOT_COLOR);
            });
            upgradeSlotChangeResult.getErrorInventorySlots().forEach(slotIndex -> {
                Slot slot = ((StorageContainerMenuBase)this.f_97732_).m_38853_((int)slotIndex);
                if (slot != null) {
                    StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.f_40220_, (int)slot.f_40221_, (int)0, (int)ERROR_SLOT_COLOR);
                }
            });
            upgradeSlotChangeResult.getErrorInventoryParts().forEach(partIndex -> {
                UpgradeInventoryPartBase<?> inventoryPart;
                if (this.inventoryParts.size() > partIndex && (inventoryPart = this.inventoryParts.get(partIndex)) != null) {
                    inventoryPart.renderErrorOverlay(guiGraphics);
                }
            });
            poseStack.m_85849_();
            this.renderErrorMessage(poseStack, (Component)overlayErrorMessage);
        }));
    }

    private void renderErrorMessage(PoseStack matrixStack, Component overlayErrorMessage) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)this.f_97736_ + (double)this.f_97731_ + 4.0, 300.0);
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        int tooltipWidth = this.f_96547_.m_92852_((FormattedText)overlayErrorMessage);
        ArrayList<Object> wrappedTextLines = new ArrayList<Object>();
        int maxLineWidth = 260;
        if (tooltipWidth > maxLineWidth) {
            int wrappedTooltipWidth = 0;
            List wrappedLine = this.f_96547_.m_92865_().m_92414_((FormattedText)overlayErrorMessage, maxLineWidth, Style.f_131099_);
            for (FormattedText line : wrappedLine) {
                int lineWidth = this.f_96547_.m_92852_(line);
                if (lineWidth > wrappedTooltipWidth) {
                    wrappedTooltipWidth = lineWidth;
                }
                wrappedTextLines.add(line);
            }
            tooltipWidth = wrappedTooltipWidth;
        } else {
            wrappedTextLines.add(overlayErrorMessage);
        }
        int tooltipHeight = 8;
        if (wrappedTextLines.size() > 1) {
            tooltipHeight += 2 + (wrappedTextLines.size() - 1) * 10;
        }
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float leftX = (float)(-tooltipWidth) / 2.0f;
        GuiHelper.renderTooltipBackground(matrix4f, tooltipWidth, (int)leftX, 0, tooltipHeight, -267386864, ERROR_BORDER_COLOR, ERROR_BORDER_COLOR);
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85837_(0.0, 0.0, 400.0);
        GuiHelper.writeTooltipLines(wrappedTextLines, fontrenderer, leftX, 0, matrix4f, renderTypeBuffer, ERROR_TEXT_COLOR);
        renderTypeBuffer.m_109911_();
        matrixStack.m_85849_();
    }

    @Override
    public void renderInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY, canShowHover);
    }

    @Override
    public boolean isMouseOverSlot(Slot pSlot, double pMouseX, double pMouseY) {
        return this.m_97774_(pSlot, pMouseX, pMouseY);
    }

    @Override
    public int getTopY() {
        return this.getGuiTop();
    }

    @Override
    public void drawSlotBg(GuiGraphics guiGraphics) {
        this.drawSlotBg(guiGraphics, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2);
        this.drawSlotOverlays(guiGraphics);
    }

    @Override
    public int getLeftX() {
        return this.getGuiLeft();
    }

    public Position getRightTopAbovePlayersInventory() {
        return new Position(this.storageBackgroundProperties.getPlayerInventoryXOffset() + 8 + 162, this.f_97731_);
    }
}

