/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class JukeboxUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, JukeboxUpgradeItem>
    implements ITickableUpgrade {
        private static final int KEEP_ALIVE_SEND_INTERVAL = 5;
        private final ItemStackHandler discInventory;
        private long lastKeepAliveSendTime = 0L;
        private boolean isPlaying;

        protected Wrapper(IStorageWrapper storageWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
            this.discInventory = new ItemStackHandler(1){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    upgrade.m_41700_("discInventory", (Tag)this.serializeNBT());
                    this.save();
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    return stack.m_41720_() instanceof RecordItem;
                }
            };
            NBTHelper.getCompound(upgrade, "discInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.discInventory).deserializeNBT(arg_0));
            this.isPlaying = NBTHelper.getBoolean(upgrade, "isPlaying").orElse(false);
        }

        public void setDisc(ItemStack disc) {
            this.discInventory.setStackInSlot(0, disc);
        }

        public ItemStack getDisc() {
            return this.discInventory.getStackInSlot(0);
        }

        public void play(Level world, BlockPos pos) {
            this.play(world, (ServerLevel serverWorld, UUID storageUuid) -> ServerStorageSoundHandler.startPlayingDisc(serverWorld, pos, storageUuid, Item.m_41393_((Item)this.getDisc().m_41720_()), () -> this.setIsPlaying(false)));
        }

        public void play(LivingEntity entity) {
            this.play(entity.m_9236_(), (ServerLevel world, UUID storageUuid) -> ServerStorageSoundHandler.startPlayingDisc(world, entity.m_20182_(), storageUuid, entity.m_19879_(), Item.m_41393_((Item)this.getDisc().m_41720_()), () -> this.setIsPlaying(false)));
        }

        private void play(Level world, BiConsumer<ServerLevel, UUID> play) {
            if (!(world instanceof ServerLevel) || this.getDisc().m_41619_()) {
                return;
            }
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> play.accept((ServerLevel)world, (UUID)storageUuid));
            this.setIsPlaying(true);
        }

        private void setIsPlaying(boolean playing) {
            this.isPlaying = playing;
            NBTHelper.setBoolean(this.upgrade, "isPlaying", playing);
            if (this.isPlaying) {
                this.storageWrapper.getRenderInfo().setUpgradeRenderData(JukeboxUpgradeRenderData.TYPE, new JukeboxUpgradeRenderData(true));
            } else {
                this.removeRenderData();
            }
            this.save();
        }

        private void removeRenderData() {
            this.storageWrapper.getRenderInfo().removeUpgradeRenderData(JukeboxUpgradeRenderData.TYPE);
        }

        public void stop(LivingEntity entity) {
            if (!(entity.m_9236_() instanceof ServerLevel)) {
                return;
            }
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.stopPlayingDisc((ServerLevel)entity.m_9236_(), entity.m_20182_(), storageUuid));
            this.setIsPlaying(false);
        }

        public IItemHandler getDiscInventory() {
            return this.discInventory;
        }

        @Override
        public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
            if (this.isPlaying && this.lastKeepAliveSendTime < world.m_46467_() - 5L) {
                this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.updateKeepAlive(storageUuid, world, entity != null ? entity.m_20182_() : Vec3.m_82512_((Vec3i)pos), () -> this.setIsPlaying(false)));
                this.lastKeepAliveSendTime = world.m_46467_();
            }
        }

        public boolean isPlaying() {
            return this.isPlaying;
        }

        @Override
        public void onBeforeRemoved() {
            this.removeRenderData();
        }
    }
}

