/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class ClientEventHandler {
    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ModParticles::registerFactories);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onPlayerJoinServer);
        eventBus.addListener(StorageSoundHandler::tick);
        eventBus.addListener(StorageSoundHandler::onWorldUnload);
        eventBus.addListener(ClientEventHandler::onDrawScreen);
    }

    private static void onDrawScreen(ScreenEvent.Render.Post event) {
        AbstractContainerScreen containerGui;
        Minecraft mc;
        block7: {
            block6: {
                mc = Minecraft.m_91087_();
                Screen gui = mc.f_91080_;
                if (!(gui instanceof AbstractContainerScreen)) break block6;
                containerGui = (AbstractContainerScreen)gui;
                if (!(gui instanceof CreativeModeInventoryScreen) && mc.f_91074_ != null) break block7;
            }
            return;
        }
        AbstractContainerMenu menu = containerGui.m_6262_();
        ItemStack held = menu.m_142621_();
        if (!held.m_41619_()) {
            Slot under = containerGui.getSlotUnderMouse();
            for (Slot s : menu.f_38839_) {
                Optional<TooltipComponent> tooltip;
                ItemStack stack = s.m_7993_();
                if (!s.m_8010_((Player)mc.f_91074_) || stack.m_41619_() || (tooltip = ClientEventHandler.getStashableAndTooltip(stack, held)).isEmpty()) continue;
                if (s == under) {
                    ClientEventHandler.renderSpecialTooltip(event, mc, containerGui, event.getGuiGraphics(), tooltip);
                    continue;
                }
                ClientEventHandler.renderStashSign(mc, containerGui, event.getGuiGraphics(), s, stack);
            }
        }
    }

    private static void renderStashSign(Minecraft mc, AbstractContainerScreen<?> containerGui, GuiGraphics guiGraphics, Slot s, ItemStack stack) {
        int x = containerGui.getGuiLeft() + s.f_40220_;
        int y = containerGui.getGuiTop() + s.f_40221_;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, containerGui instanceof StorageScreenBase ? 150.0f : 499.0f);
        if (stack.m_41720_() instanceof IStashStorageItem) {
            guiGraphics.m_280488_(mc.f_91062_, "+", x + 10, y + 8, 0xFFFF00);
        } else {
            guiGraphics.m_280488_(mc.f_91062_, "-", x + 1, y, 0xFFFF00);
        }
        poseStack.m_85849_();
    }

    private static void renderSpecialTooltip(ScreenEvent.Render.Post event, Minecraft mc, AbstractContainerScreen<?> containerGui, GuiGraphics guiGraphics, Optional<TooltipComponent> tooltip) {
        int x = event.getMouseX();
        int y = event.getMouseY();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, containerGui instanceof StorageScreenBase ? -100.0f : 100.0f);
        guiGraphics.m_280677_(containerGui.f_96547_, Collections.singletonList(Component.m_237115_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), tooltip, x, y);
        poseStack.m_85849_();
    }

    private static Optional<TooltipComponent> getStashableAndTooltip(ItemStack inInventory, ItemStack held) {
        IStashStorageItem stashStorageItem;
        Item item;
        if (inInventory.m_41613_() == 1 && (item = inInventory.m_41720_()) instanceof IStashStorageItem && (stashStorageItem = (IStashStorageItem)item).isItemStashable(inInventory, held)) {
            return stashStorageItem.getInventoryTooltip(inInventory);
        }
        item = held.m_41720_();
        if (item instanceof IStashStorageItem && (stashStorageItem = (IStashStorageItem)item).isItemStashable(held, inInventory)) {
            return stashStorageItem.getInventoryTooltip(held);
        }
        return Optional.empty();
    }

    private static void onPlayerJoinServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        RecipeHelper.setWorld((Level)Minecraft.m_91087_().f_91073_);
    }
}

