/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.ToolInfoOverlay;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ClientStorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ControllerRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LimitedBarrelDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LimitedBarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SimpleCompositeModel;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.network.ScrolledToolMessage;
import net.p3pp3rf1y.sophisticatedstorage.network.StoragePacketHandler;

public class ClientEventHandler {
    private static final String KEYBIND_SOPHISTICATEDSTORAGE_CATEGORY = "keybind.sophisticatedstorage.category";
    private static final int MIDDLE_BUTTON = 2;
    public static final KeyMapping SORT_KEYBIND = new KeyMapping(StorageTranslationHelper.INSTANCE.translKeybind("sort"), (IKeyConflictContext)StorageGuiKeyConflictContext.INSTANCE, InputConstants.Type.MOUSE.m_84895_(2), "keybind.sophisticatedstorage.category");
    private static final ResourceLocation CHEST_RL = new ResourceLocation("sophisticatedstorage", "chest");
    public static final ModelLayerLocation CHEST_LAYER = new ModelLayerLocation(CHEST_RL, "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::onModelRegistry);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::registerTooltipComponent);
        modBus.addListener(ClientEventHandler::registerOverlay);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ModParticles::registerProviders);
        modBus.addListener(ClientEventHandler::registerKeyMappings);
        modBus.addListener(ModItemColors::registerItemColorHandlers);
        modBus.addListener(ModBlockColors::registerBlockColorHandlers);
        modBus.addListener(ClientEventHandler::registerStorageLayerLoader);
        modBus.addListener(ClientEventHandler::onRegisterAdditionalModels);
        modBus.addListener(ClientEventHandler::onRegisterReloadListeners);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientStorageContentsTooltip::onWorldLoad);
        eventBus.addListener(EventPriority.HIGH, ClientEventHandler::handleGuiMouseKeyPress);
        eventBus.addListener(EventPriority.HIGH, ClientEventHandler::handleGuiKeyPress);
        eventBus.addListener(ClientEventHandler::onLimitedBarrelClicked);
        eventBus.addListener(ClientEventHandler::onMouseScrolled);
    }

    private static void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        ClientEventHandler.addBarrelPartModelsToBake(event);
    }

    private static void addBarrelPartModelsToBake(ModelEvent.RegisterAdditional event) {
        Map models = Minecraft.m_91087_().m_91098_().m_214159_("models/block/barrel_part", fileName -> fileName.m_135815_().endsWith(".json"));
        models.forEach((modelName, resource) -> {
            if (modelName.m_135827_().equals("sophisticatedstorage")) {
                event.register(new ResourceLocation(modelName.m_135827_(), modelName.m_135815_().substring("models/".length()).replace(".json", "")));
            }
        });
    }

    private static void onMouseScrolled(InputEvent.MouseScrollingEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6144_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.STORAGE_TOOL.get()) {
            return;
        }
        StoragePacketHandler.INSTANCE.sendToServer(new ScrolledToolMessage(evt.getScrollDelta() > 0.0));
        evt.setCanceled(true);
    }

    private static void onLimitedBarrelClicked(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof LimitedBarrelBlock)) {
            return;
        }
        LimitedBarrelBlock limitedBarrel = (LimitedBarrelBlock)block;
        if (limitedBarrel.isLookingAtFront(player, pos, state)) {
            if (player.m_7500_()) {
                event.setCanceled(true);
            } else if (event.getEntity().getDigSpeed(state, event.getPos()) < 2.0f) {
                event.setUseItem(Event.Result.DENY);
                Minecraft.m_91087_().f_91072_.f_105195_ = 5;
            }
        }
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        if (SORT_KEYBIND.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode())) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    private static void registerStorageLayerLoader(AddPackFindersEvent event) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)resourceManager;
            reloadableResourceManager.m_7217_((PreparableReloadListener)StorageTextureManager.INSTANCE);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(event.getButton());
        if (SORT_KEYBIND.isActiveAndMatches(input) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    private static boolean tryCallSort(Screen gui) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (abstractContainerMenu = mc.f_91074_.f_36096_) instanceof StorageContainerMenu) {
            double mouseY;
            MouseHandler mh;
            double mouseX;
            StorageScreen screen;
            Slot selectedSlot;
            StorageContainerMenu container = (StorageContainerMenu)abstractContainerMenu;
            if (gui instanceof StorageScreen && (selectedSlot = (screen = (StorageScreen)gui).m_97744_(mouseX = (mh = mc.f_91067_).m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_(), mouseY = mh.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_())) != null && container.isNotPlayersInventorySlot(selectedSlot.f_40219_)) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static void onModelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register("barrel", (IGeometryLoader)BarrelDynamicModel.Loader.INSTANCE);
        event.register("limited_barrel", (IGeometryLoader)LimitedBarrelDynamicModel.Loader.INSTANCE);
        event.register("chest", (IGeometryLoader)ChestDynamicModel.Loader.INSTANCE);
        event.register("shulker_box", (IGeometryLoader)ShulkerBoxDynamicModel.Loader.INSTANCE);
        event.register("simple_composite", (IGeometryLoader)SimpleCompositeModel.Loader.INSTANCE);
    }

    private static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
            BarrelDynamicModelBase.invalidateCache();
            BarrelBakedModelBase.invalidateCache();
        }));
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CHEST_LAYER, () -> ChestRenderer.createSingleBodyLayer(true));
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(SORT_KEYBIND);
    }

    private static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(StorageContentsTooltip.class, ClientStorageContentsTooltip::new);
    }

    private static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "storage_tool_info", ToolInfoOverlay.HUD_TOOL_INFO);
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get(), context -> new BarrelRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get(), context -> new LimitedBarrelRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get(), ChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get(), ShulkerBoxRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.CONTROLLER_BLOCK_ENTITY_TYPE.get(), context -> new ControllerRenderer());
    }

    private static class StorageGuiKeyConflictContext
    implements IKeyConflictContext {
        public static final StorageGuiKeyConflictContext INSTANCE = new StorageGuiKeyConflictContext();

        private StorageGuiKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.GUI.isActive() && Minecraft.m_91087_().f_91080_ instanceof StorageScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

