/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.tag.ModTags;
import com.ldtteam.structurize.util.JavaUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.Nullable;

public final class BlockUtils {
    private static final Set<Block> trueSolidBlocks = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<BiPredicate<Block, BlockState>> FREE_TO_PLACE_BLOCKS = Arrays.asList((block, iBlockState) -> block.equals(Blocks.f_50016_), (block, iBlockState) -> BlockUtils.isLiquidOnlyBlock(iBlockState.m_60734_()), (block, iBlockState) -> BlockUtils.isWater(block.m_49966_()), (block, iBlockState) -> block instanceof LeavesBlock, (block, iBlockState) -> block instanceof DoublePlantBlock, (block, iBlockState) -> block.equals(Blocks.f_50034_), (block, iBlockState) -> block instanceof DoorBlock && iBlockState != null && (Boolean)iBlockState.m_61143_((Property)BooleanProperty.m_61465_((String)"upper")) != false);

    private BlockUtils() {
    }

    public static void checkOrInit() {
        if (trueSolidBlocks.isEmpty()) {
            ForgeRegistries.BLOCKS.getValues().stream().filter(BlockUtils::canBlockSurviveWithoutSupport).filter(block -> !block.m_49966_().m_60795_() && !(block instanceof LiquidBlock) && !block.m_204297_().m_203656_(ModTags.WEAK_SOLID_BLOCKS)).forEach(trueSolidBlocks::add);
        }
    }

    public static Rotation getRotation(int rotation) {
        switch (rotation) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static int getRotationFromFacing(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 1;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    public static BlockState getSubstitutionBlockAtWorld(Level world, BlockPos location) {
        return Blocks.f_50493_.m_49966_();
    }

    public static BlockState getSubstitutionBlockAtWorld(Level level, BlockPos location, @Nullable Function<BlockPos, BlockState> virtualBlocks) {
        BlockState result = BlockUtils.getWorldgenBlock(level, location, virtualBlocks);
        if (result != null && result.m_60734_() == Blocks.f_152499_) {
            result = Blocks.f_50127_.m_49966_();
        } else if (!(result != null && BlockUtils.isAnySolid(result) && result.m_60734_() != Blocks.f_50752_ || (result = BlockUtils.getDefaultBlockForLevel(level, null)) != null && BlockUtils.isAnySolid(result) && result.m_60734_() != Blocks.f_50069_)) {
            result = Blocks.f_50493_.m_49966_();
        }
        return result;
    }

    @Nullable
    public static BlockState getWorldgenBlock(Level level, BlockPos location, @Nullable Function<BlockPos, BlockState> virtualBlocks) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkGenerator generator = serverLevel.m_7726_().m_8481_();
            if (generator instanceof NoiseBasedChunkGenerator) {
                BlockState bs;
                int tempY;
                NoiseBasedChunkGenerator chunkGenerator = (NoiseBasedChunkGenerator)generator;
                NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)chunkGenerator.m_224341_().m_203334_();
                ChunkAccess chunk = serverLevel.m_46865_(location);
                SurfaceRules.Context ctx = new SurfaceRules.Context(serverLevel.m_7726_().m_214994_().m_224580_(), serverLevel.m_7726_().m_214994_(), chunk, chunk.m_223012_(c -> BlockUtils.createNoiseBiome(serverLevel, chunkGenerator, c)), arg_0 -> ((BiomeManager)serverLevel.m_7062_()).m_204214_(arg_0), serverLevel.m_9598_().m_175515_(Registries.f_256952_), new WorldGenerationContext((ChunkGenerator)chunkGenerator, (LevelHeightAccessor)serverLevel));
                int locX = location.m_123341_();
                int locY = location.m_123342_();
                int locZ = location.m_123343_();
                int stoneDepthAbove = 1;
                int stoneDepthBelow = DimensionType.f_188294_;
                int waterHeight = Integer.MIN_VALUE;
                BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos(locX, locY, locZ);
                for (tempY = locY + 1; tempY <= chunk.m_151558_() + 1; ++tempY) {
                    temp.m_142448_(tempY);
                    BlockState blockState = bs = virtualBlocks == null ? chunk.m_8055_((BlockPos)temp) : Objects.requireNonNullElseGet(virtualBlocks.apply((BlockPos)temp), () -> chunk.m_8055_((BlockPos)temp));
                    if (bs.m_60795_()) break;
                    if (!bs.m_60819_().m_76178_()) {
                        waterHeight = tempY + 1;
                    }
                    ++stoneDepthAbove;
                }
                for (tempY = locY - 1; tempY >= chunk.m_141937_() - 1; --tempY) {
                    temp.m_142448_(tempY);
                    BlockState blockState = bs = virtualBlocks == null ? chunk.m_8055_((BlockPos)temp) : Objects.requireNonNullElseGet(virtualBlocks.apply((BlockPos)temp), () -> chunk.m_8055_((BlockPos)temp));
                    if (!bs.m_60795_() && bs.m_60819_().m_76178_()) continue;
                    stoneDepthBelow = tempY + 1;
                    break;
                }
                stoneDepthBelow = locY - stoneDepthBelow + 1;
                ctx.m_189569_(locX, locZ);
                ctx.m_189576_(stoneDepthAbove, stoneDepthBelow, waterHeight, locX, locY, locZ);
                return ((SurfaceRules.SurfaceRule)generatorSettings.f_188871_().apply((Object)ctx)).m_183550_(locX, locY, locZ);
            }
            if (generator instanceof FlatLevelSource) {
                FlatLevelSource chunkGenerator = (FlatLevelSource)generator;
                List layers = chunkGenerator.m_64191_().m_161917_();
                int locY = location.m_123342_() - serverLevel.m_141937_();
                if (locY >= 0 && locY < layers.size()) {
                    return (BlockState)layers.get(locY);
                }
            }
        }
        return null;
    }

    private static NoiseChunk createNoiseBiome(ServerLevel serverLevel, NoiseBasedChunkGenerator chunkGenerator, ChunkAccess chunk) {
        int chunkX = chunk.m_7697_().f_45578_;
        int chunkZ = chunk.m_7697_().f_45579_;
        int chunkRange = ChunkStatus.f_62319_.m_62488_();
        ArrayList<ChunkAccess> surroundingChunks = new ArrayList<ChunkAccess>(4 * chunkRange * (chunkRange + 1) + 1);
        for (int z = -chunkRange; z <= chunkRange; ++z) {
            for (int x = -chunkRange; x <= chunkRange; ++x) {
                ChunkAccess surroundingChunk = serverLevel.m_46819_(chunkX + x, chunkZ + z, ChunkStatus.f_62319_);
                if (surroundingChunk instanceof ImposterProtoChunk) {
                    ImposterProtoChunk imposterProtoChunk = (ImposterProtoChunk)surroundingChunk;
                    surroundingChunk = new ImposterProtoChunk(imposterProtoChunk.m_62768_(), true);
                } else if (surroundingChunk instanceof LevelChunk) {
                    LevelChunk levelChunk = (LevelChunk)surroundingChunk;
                    surroundingChunk = new ImposterProtoChunk(levelChunk, true);
                }
                surroundingChunks.add(surroundingChunk);
            }
        }
        OurWorldGenRegion worldGenRegion = new OurWorldGenRegion(serverLevel, surroundingChunks);
        return chunkGenerator.m_224256_(chunk, serverLevel.m_215010_().m_220468_((WorldGenRegion)worldGenRegion), Blender.m_190202_((WorldGenRegion)worldGenRegion), serverLevel.m_7726_().m_214994_());
    }

    public static boolean isWater(BlockState iBlockState) {
        return iBlockState.m_60734_() == Blocks.f_49990_;
    }

    private static Item getItem(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block.equals(Blocks.f_49991_)) {
            return Items.f_42448_;
        }
        if (block instanceof CropBlock) {
            ItemStack stack = ((CropBlock)block).m_7397_(null, null, blockState);
            if (stack != null) {
                return stack.m_41720_();
            }
            return Items.f_42404_;
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return BlockUtils.getItemFromBlock(Blocks.f_50493_);
        }
        if (block instanceof FireBlock) {
            return Items.f_42409_;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.f_42618_;
        }
        if (block == Blocks.f_50570_) {
            return Items.f_41911_;
        }
        return BlockUtils.getItemFromBlock(block);
    }

    private static Item getItemFromBlock(Block block) {
        return (Item)GameData.getBlockItemMap().get(block);
    }

    public static boolean areBlockStatesEqual(BlockState structureState, BlockState worldState, Predicate<BlockState> shallReplace, boolean fancy, BiPredicate<BlockState, BlockState> specialEqualRule, CompoundTag tileEntityData, BlockEntity worldEntity) {
        if (structureState == null || worldState == null) {
            return true;
        }
        Block structureBlock = structureState.m_60734_();
        Block worldBlock = worldState.m_60734_();
        if (worldState.equals(structureState)) {
            if (tileEntityData == null) {
                return true;
            }
            if (worldEntity == null) {
                return false;
            }
            if (worldEntity instanceof MateriallyTexturedBlockEntity) {
                CompoundTag tag = tileEntityData.m_6426_();
                tag.m_128405_("x", worldEntity.m_58899_().m_123341_());
                tag.m_128405_("y", worldEntity.m_58899_().m_123342_());
                tag.m_128405_("z", worldEntity.m_58899_().m_123343_());
                return Utils.nbtContains(tag, worldEntity.m_187480_());
            }
            return true;
        }
        if (worldEntity instanceof MateriallyTexturedBlockEntity) {
            return false;
        }
        if (fancy) {
            if (structureBlock == ModBlocks.blockSubstitution.get()) {
                return true;
            }
            if (structureBlock instanceof AirBlock && worldBlock instanceof AirBlock) {
                return true;
            }
            if (structureBlock == Blocks.f_50493_ && worldState.m_204336_(BlockTags.f_144274_)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockSolidSubstitution.get() && !shallReplace.test(worldState)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockFluidSubstitution.get() && (worldState.m_60819_().m_76170_() || !worldState.m_61138_((Property)BlockStateProperties.f_61362_) && BlockUtils.isAnySolid(worldState)) || worldBlock == ModBlocks.blockFluidSubstitution.get() && (structureState.m_60819_().m_76170_() || !structureState.m_61138_((Property)BlockStateProperties.f_61362_) && BlockUtils.isAnySolid(structureState))) {
                return true;
            }
        }
        return specialEqualRule.test(structureState, worldState);
    }

    public static BlockState getBlockStateFromStack(ItemStack stack) {
        return BlockUtils.getBlockStateFromStack(stack, Blocks.f_50016_.m_49966_());
    }

    public static BlockState getBlockStateFromStack(ItemStack stack, BlockState def) {
        if (stack.m_41720_() == Items.f_41852_) {
            return Blocks.f_50016_.m_49966_();
        }
        if (stack.m_41720_() instanceof BucketItem) {
            return ((BucketItem)stack.m_41720_()).getFluid().m_76145_().m_76188_();
        }
        if (stack.m_41720_() instanceof BlockItem) {
            return ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        }
        return def;
    }

    public static ItemStack getItemStackFromBlockState(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquid = (LiquidBlock)block;
            return new ItemStack((ItemLike)liquid.getFluid().m_6859_(), 1);
        }
        Item item = BlockUtils.getItem(blockState);
        if (item != Items.f_41852_ && item != null) {
            return new ItemStack((ItemLike)item, 1);
        }
        return new ItemStack((ItemLike)blockState.m_60734_(), 1);
    }

    public static void handleCorrectBlockPlacement(Level world, FakePlayer fakePlayer, ItemStack itemStack, BlockState blockState, BlockPos here) {
        ItemStack stackToPlace = itemStack.m_41777_();
        Item item = stackToPlace.m_41720_();
        stackToPlace.m_41764_(stackToPlace.m_41741_());
        if (item instanceof AirItem) {
            world.m_7471_(here, false);
        } else if (item instanceof BlockItem) {
            Block targetBlock = ((BlockItem)item).m_40614_();
            BlockState newState = BlockUtils.copyFirstCommonBlockStateProperties(targetBlock.m_49966_(), blockState);
            if (newState == null) {
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stackToPlace);
                if (stackToPlace.m_204117_(ItemTags.f_13146_) && blockState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                    fakePlayer.m_146922_((float)(((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122416_() * 90));
                }
                if ((newState = targetBlock.m_5573_(new BlockPlaceContext(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), itemStack.m_41720_() instanceof BedItem ? Direction.UP : Direction.NORTH, here, true))))) == null) {
                    return;
                }
            }
            world.m_7731_(here, Blocks.f_50652_.m_49966_(), 2);
            world.m_7731_(here, newState, 3);
            targetBlock.m_6402_(world, here, newState, (LivingEntity)fakePlayer, stackToPlace);
        } else if (item instanceof BucketItem) {
            Block sourceBlock = blockState.m_60734_();
            BucketItem bucket = (BucketItem)item;
            Fluid fluid = bucket.getFluid();
            if (sourceBlock instanceof LiquidBlockContainer) {
                LiquidBlockContainer liquidContainer = (LiquidBlockContainer)sourceBlock;
                if (liquidContainer.m_6044_((BlockGetter)world, here, blockState, fluid)) {
                    liquidContainer.m_7361_((LevelAccessor)world, here, blockState, fluid.m_76145_());
                    bucket.m_142131_(null, world, stackToPlace, here);
                }
            } else {
                world.m_7731_(here, Blocks.f_50652_.m_49966_(), 2);
                world.m_7731_(here, fluid.m_76145_().m_76188_(), 3);
                bucket.m_142131_(null, world, stackToPlace, here);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Cannot handle placing of {0} instead of {1}?!", itemStack.toString(), blockState.toString()));
        }
    }

    public static void removeFluid(Level world, BlockPos pos) {
        BucketPickup bucketBlock;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if ((!(block instanceof BucketPickup) || (bucketBlock = (BucketPickup)block).m_142598_((LevelAccessor)world, pos, state).m_41619_()) && block instanceof LiquidBlock) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static BlockState getFluidForDimension(Level world) {
        NoiseBasedChunkGenerator chunkGenerator;
        BlockState defaultFluid;
        ServerLevel serverLevel;
        ChunkGenerator generator;
        if (world instanceof ServerLevel && (generator = (serverLevel = (ServerLevel)world).m_7726_().m_8481_()) instanceof NoiseBasedChunkGenerator && !(defaultFluid = ((NoiseGeneratorSettings)(chunkGenerator = (NoiseBasedChunkGenerator)generator).m_224341_().m_203334_()).f_64441_()).m_60819_().m_76178_()) {
            return defaultFluid;
        }
        return world == null || !world.m_6042_().f_63857_() ? Blocks.f_49990_.m_49966_() : Blocks.f_49991_.m_49966_();
    }

    public static BlockState getDefaultBlockForLevel(Level level, BlockState defaultValue) {
        ServerLevel serverLevel;
        ChunkGenerator generator;
        if (level instanceof ServerLevel && (generator = (serverLevel = (ServerLevel)level).m_7726_().m_8481_()) instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator chunkGenerator = (NoiseBasedChunkGenerator)generator;
            return ((NoiseGeneratorSettings)chunkGenerator.m_224341_().m_203334_()).f_64440_();
        }
        return defaultValue;
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos coords, int fortune, ItemStack stack) {
        if (!(world instanceof ServerLevel)) {
            throw new IllegalArgumentException("trying to get block drops at client side?!");
        }
        ServerLevel serverLevel = (ServerLevel)world;
        return world.m_8055_(coords).m_287290_(new LootParams.Builder(serverLevel).m_287239_((float)fortune).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82528_((Vec3i)coords)).m_287289_(LootContextParams.f_81462_, (Object)world.m_7702_(coords)).m_287286_(LootContextParams.f_81463_, (Object)stack));
    }

    public static BlockState copyBlockStateProperties(Block target, BlockState propertiesOrigin) {
        return target.getClass().equals(propertiesOrigin.m_60734_().getClass()) ? BlockUtils.unsafeCopyBlockStateProperties(target.m_49966_(), propertiesOrigin, propertiesOrigin.m_61147_()) : null;
    }

    public static BlockState copyFirstCommonBlockStateProperties(BlockState target, BlockState propertiesOrigin) {
        BlockState sameClass = BlockUtils.copyBlockStateProperties(target.m_60734_(), propertiesOrigin);
        if (sameClass != null) {
            return sameClass;
        }
        Class<?> firstCommonClass = JavaUtils.getFirstCommonSuperClass(target.m_60734_().getClass(), propertiesOrigin.m_60734_().getClass());
        if (firstCommonClass == Block.class || !Block.class.isAssignableFrom(firstCommonClass)) {
            return null;
        }
        ArrayList properties = new ArrayList(target.m_61147_());
        properties.retainAll(propertiesOrigin.m_61147_());
        return BlockUtils.unsafeCopyBlockStateProperties(target, propertiesOrigin, properties);
    }

    private static BlockState unsafeCopyBlockStateProperties(BlockState target, BlockState propertiesOrigin, Collection<Property<?>> properties) {
        BlockState blockState = target;
        for (Property<?> property : properties) {
            blockState = (BlockState)blockState.m_61124_(property, propertiesOrigin.m_61143_(property));
        }
        return blockState;
    }

    public static boolean canBlockFloatInAir(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof LeavesBlock) {
            LeavesBlock leaves = (LeavesBlock)block;
            return !leaves.m_6724_(blockState);
        }
        return trueSolidBlocks.contains(blockState.m_60734_());
    }

    public static boolean isLiquidOnlyBlock(BlockState blockState) {
        return blockState.m_278721_() || BlockUtils.isLiquidOnlyBlock(blockState.m_60734_());
    }

    public static boolean isLiquidOnlyBlock(Block block) {
        return block instanceof LiquidBlock || block instanceof BubbleColumnBlock;
    }

    public static boolean isWeakSolidBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof LeavesBlock) {
            LeavesBlock leaves = (LeavesBlock)block;
            return leaves.m_6724_(blockState);
        }
        Block block2 = blockState.m_60734_();
        return block2.m_204297_().m_203656_(ModTags.WEAK_SOLID_BLOCKS) && BlockUtils.canBlockSurviveWithoutSupport(block2);
    }

    public static boolean canBlockSurviveWithoutSupport(Block block) {
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return true;
        }
        try {
            return block.m_7898_(block.m_49966_(), null, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAnySolid(BlockState blockState) {
        return BlockUtils.canBlockFloatInAir(blockState) || BlockUtils.isWeakSolidBlock(blockState);
    }

    public static boolean isGoodFloorBlock(BlockState blockState) {
        return BlockUtils.isAnySolid(blockState) && !blockState.m_204336_(ModTags.UNSUITABLE_SOLID_FOR_PLACEHOLDER);
    }

    public static SolidnessInfo getSolidInfo(BlockState blockState) {
        return new SolidnessInfo(BlockUtils.canBlockFloatInAir(blockState), BlockUtils.isWeakSolidBlock(blockState));
    }

    private static class OurWorldGenRegion
    extends WorldGenRegion {
        private OurWorldGenRegion(ServerLevel p_143484_, List<ChunkAccess> p_143485_) {
            super(p_143484_, p_143485_, null, -1);
        }

        public boolean m_7740_(BlockPos p_9550_, boolean p_9551_, @Nullable Entity p_9552_, int p_9553_) {
            return false;
        }

        public boolean m_180807_(BlockPos p_181031_) {
            return false;
        }

        public boolean m_6933_(BlockPos p_9539_, BlockState p_9540_, int p_9541_, int p_9542_) {
            return false;
        }

        public boolean m_7967_(Entity p_9580_) {
            return false;
        }

        public boolean m_7471_(BlockPos p_9547_, boolean p_9548_) {
            return false;
        }
    }

    public record SolidnessInfo(boolean canFloatInAir, boolean isWeakSolid) {
        public boolean isAnySolid() {
            return this.canFloatInAir || this.isWeakSolid;
        }
    }
}

