/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class NotResourceCondition
implements ResourceCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ICondition condition;

    public NotResourceCondition(ICondition condition) {
        this.condition = condition;
    }

    public NotResourceCondition(ResourceCondition condition) {
        this(ResourceCondition.createForgeCondition(condition));
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        return !this.condition.test(context.getUnderlying(), context.getDynamicOps());
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements ResourceConditionSerializer<NotResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, NotResourceCondition condition) {
            json.add("condition", (JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition.condition).getOrThrow());
        }

        @Override
        public NotResourceCondition deserialize(JsonObject json) {
            if (!json.has("condition") || !json.get("condition").isJsonObject()) {
                throw new RuntimeException("Condition must have key 'condition' with a json object!");
            }
            return new NotResourceCondition((ICondition)((Pair)ICondition.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("condition").getAsJsonObject()).getOrThrow()).getFirst());
        }
    }
}

