/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.codec.CodecHelper;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.crafting.conditions.ICondition;

class ResourceConditions {
    private static final Map<ResourceConditionSerializer<?>, MapCodec<? extends ICondition>> TO_UNDERLYING_MAP = new HashMap();

    ResourceConditions() {
    }

    static ConditionWrapper wrap(ResourceCondition condition) {
        return new ConditionWrapper(condition);
    }

    static MapCodec<? extends ICondition> serializerCodec(ResourceConditionSerializer<?> serializer) {
        return TO_UNDERLYING_MAP.computeIfAbsent(serializer, s -> CodecHelper.jsonSerializerToMapCodec(input -> {
            JsonObject json = new JsonObject();
            serializer.serialize(json, input.condition);
            return json;
        }, json -> new ConditionWrapper((ResourceCondition)serializer.deserialize((JsonObject)json))));
    }

    private static class ConditionWrapper
    implements ICondition {
        private final ResourceCondition condition;

        ConditionWrapper(ResourceCondition condition) {
            this.condition = condition;
        }

        public boolean test(ICondition.IContext context, DynamicOps<?> ops) {
            return this.condition.test(new ResourceConditionContext(context, ops));
        }

        public MapCodec<? extends ICondition> codec() {
            return ResourceConditions.serializerCodec(this.condition.getSerializer());
        }
    }
}

